/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.deferred;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorVersionHolder;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdOpenFileDescriptor;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020*2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020%H\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u0015H\u0016J\u0010\u00104\u001a\u00020*2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u000206H\u0016J\u0010\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020<H\u0016J\u0016\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001bJ\u000e\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010$\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006D"}, d2={"Lcom/jetbrains/rdclient/editors/deferred/PostponedEditorSynchronizer;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/intellij/openapi/editor/Document;)V", "getTextControlLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getTextControlId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getEditorModel", "()Lcom/jetbrains/rd/ide/model/TextControlModel;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "lastScrollingRequest", "Lcom/jetbrains/rd/ide/model/ScrollingInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "isDisabled", "", "isReceivingChange", "()Z", "versionHolder", "Lcom/jetbrains/rd/ide/editor/EditorVersionHolder;", "version", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "value", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "lastCaretChange", "getLastCaretChange", "()Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "resetVersion", "", "v", "Lcom/jetbrains/rd/ide/model/RdAbstractEditorVersion;", "setVisible", "setFocused", "setSelected", "receiveSelection", "change", "receiveScrollingRequest", "request", "receiveFocusRequestFromModel", "descriptor", "Lcom/jetbrains/rd/ide/model/RdOpenFileDescriptor;", "openEditor", "focus", "offset", "visibleAreaChanged", "e", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "softUpdate", "item", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "redo", "restoreTo", "synchronizer", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nPostponedEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostponedEditorSynchronizer.kt\ncom/jetbrains/rdclient/editors/deferred/PostponedEditorSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n1#2:113\n13#3:114\n*S KotlinDebug\n*F\n+ 1 PostponedEditorSynchronizer.kt\ncom/jetbrains/rdclient/editors/deferred/PostponedEditorSynchronizer\n*L\n22#1:114\n*E\n"})
public final class PostponedEditorSynchronizer
implements EditorSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime textControlLifetime;
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel editorModel;
    @NotNull
    private final Document document;
    @Nullable
    private ScrollingInfo lastScrollingRequest;
    private volatile boolean isDisabled;
    @NotNull
    private final EditorVersionHolder versionHolder;
    @Nullable
    private RdCaretModelChange lastCaretChange;
    @NotNull
    private static final Logger LOG;

    public PostponedEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.textControlLifetime = textControlLifetime;
        this.textControlId = textControlId;
        this.editorModel = editorModel;
        this.document = document;
        this.versionHolder = new EditorVersionHolder(EditorVersionsKt.getInitialEditorVersion());
    }

    @NotNull
    public Lifetime getTextControlLifetime() {
        return this.textControlLifetime;
    }

    @NotNull
    public TextControlId getTextControlId() {
        return this.textControlId;
    }

    @NotNull
    public TextControlModel getEditorModel() {
        return this.editorModel;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public Editor getEditor() {
        throw new IllegalStateException("Should not be called".toString());
    }

    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.isDisabled;
    }

    @NotNull
    public RdEditorVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Nullable
    public final RdCaretModelChange getLastCaretChange() {
        return this.lastCaretChange;
    }

    public void resetVersion(@NotNull RdAbstractEditorVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdEditorVersion cfr_ignored_0 = (RdEditorVersion)v;
        LOG.trace("resetting version to " + v);
        this.versionHolder.reset((RdEditorVersion)v);
    }

    public void setVisible(boolean value) {
        LOG.error("Calling setVisible on PostponedEditorSynchronizer is not supported");
    }

    public void setFocused(boolean value) {
        LOG.error("Calling setFocused on PostponedEditorSynchronizer is not supported");
    }

    public void setSelected(boolean value) {
        LOG.error("Calling setSelected on PostponedEditorSynchronizer is not supported");
    }

    public void receiveSelection(@NotNull RdCaretModelChange change) {
        RdCaretState rdCaretState;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        LOG.trace("Got receive selection patch: " + change);
        this.lastCaretChange = change;
        RdCaretModelChange rdCaretModelChange = change;
        if (rdCaretModelChange instanceof RdCaretStateChange) {
            rdCaretState = ((RdCaretStateChange)change).getNewState();
        } else if (rdCaretModelChange instanceof RdCaretStateSnapshotBase) {
            rdCaretState = ((RdCaretStateSnapshotBase)change).getState();
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(change.getClass()).getSimpleName()).toString());
        }
        RdCaretState state2 = rdCaretState;
        this.versionHolder.incrementVersion(state2);
    }

    public void receiveScrollingRequest(@NotNull ScrollingInfo request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.lastScrollingRequest = request;
    }

    public void receiveFocusRequestFromModel(@NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        LOG.error("Calling receiveFocusRequestFromModel on PostponedEditorSynchronizer is not supported");
    }

    public void openEditor(boolean focus, @NotNull RdOpenFileDescriptor offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        LOG.error("Calling openEditor on PostponedEditorSynchronizer is not supported");
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public final void softUpdate(@NotNull RdSelectionChangeBase item, boolean redo) {
        RdCaretState rdCaretState;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.lastCaretChange = (RdCaretModelChange)item;
        RdSelectionChangeBase rdSelectionChangeBase = item;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdCaretState = ((RdCaretStateChange)item).getNewState();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            rdCaretState = ((RdCaretStateSnapshotBase)item).getState();
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(item.getClass()).getSimpleName()).toString());
        }
        RdCaretState state2 = rdCaretState;
        this.versionHolder.incrementVersion(state2);
    }

    public final void restoreTo(@NotNull EditorSynchronizer synchronizer) {
        RdCaretModelChange p0;
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        RdCaretModelChange rdCaretModelChange = this.lastCaretChange;
        if (rdCaretModelChange != null) {
            p0 = rdCaretModelChange;
            boolean bl = false;
            synchronizer.receiveSelection(p0);
        }
        ScrollingInfo scrollingInfo = this.lastScrollingRequest;
        if (scrollingInfo != null) {
            p0 = scrollingInfo;
            boolean bl = false;
            synchronizer.receiveScrollingRequest((ScrollingInfo)p0);
        }
        synchronizer.resetVersion((RdAbstractEditorVersion)this.getVersion());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PostponedEditorSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/editors/deferred/PostponedEditorSynchronizer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rdclient/editors/deferred/PostponedEditorSynchronizer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PostponedEditorSynchronizer create(@NotNull Lifetime lifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return new PostponedEditorSynchronizer(lifetime, textControlId, editorModel, document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

