/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl.utils;

import com.intellij.profiler.ultimate.hprof.utils.IntList;
import com.intellij.profiler.ultimate.hprof.utils.IntMultimap;
import com.intellij.profiler.ultimate.hprof.utils.IntRoundQueue;
import java.util.BitSet;
import java.util.function.LongToIntFunction;

public class BfsObjectIterator
implements AutoCloseable {
    private final BitSet myVisited;
    private final IntList myPredecessor;
    private final IntRoundQueue myQueue;
    private final IntMultimap myInbounds;
    private final Pred myCanProceed;

    public BfsObjectIterator(long objectId, int totalInstances, LongToIntFunction remap, IntMultimap inbounds, Pred canProcess) {
        this.myPredecessor = new IntList.OffHeap(totalInstances);
        for (int i = 0; i < totalInstances; ++i) {
            this.myPredecessor.put(i, -1);
        }
        this.myQueue = new IntRoundQueue(this, totalInstances){

            @Override
            protected IntList create(int maximumSize) {
                return new IntList.OffHeap(maximumSize);
            }
        };
        this.myCanProceed = canProcess;
        this.myInbounds = inbounds;
        int objectIndex = remap.applyAsInt(objectId);
        this.myQueue.offer(objectIndex);
        this.myVisited = new BitSet(totalInstances);
        this.myVisited.set(objectIndex);
    }

    public boolean hasNext() {
        return !this.myQueue.empty();
    }

    public int nextInt() {
        int next = this.myQueue.poll();
        if (!this.myCanProceed.test(this, next)) {
            return next;
        }
        this.myInbounds.get(next, child -> {
            if (!this.myVisited.get(child)) {
                this.myQueue.offer(child);
                this.myPredecessor.put(child, next);
                this.myVisited.set(child);
            }
        });
        return next;
    }

    public int predcessor(int value) {
        return this.myPredecessor.get(value);
    }

    @Override
    public void close() {
        this.myQueue.close();
    }

    public static interface Pred {
        public boolean test(BfsObjectIterator var1, int var2);
    }
}

