/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsql;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.hsql.HsqlDdlParsing;
import com.intellij.sql.dialects.hsql.HsqlDialect;
import com.intellij.sql.dialects.hsql.HsqlDmlParsing;
import com.intellij.sql.dialects.hsql.HsqlExpressionParsing;
import com.intellij.sql.dialects.hsql.HsqlGeneratedParser;
import java.util.Set;

public class HsqlParser
extends SqlParser {
    public HsqlParser() {
        super((SqlLanguageDialectEx)HsqlDialect.INSTANCE);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return HsqlGeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return HsqlGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return HsqlDmlParsing.top_query_expression(builder, level);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return HsqlGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = HsqlExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return HsqlDdlParsing.type_element(builder, level);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, HsqlExpressionParsing::evaluable_expression);
    }

    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, BuiltinFunction definition, boolean plain, boolean ignoreParens, Set<BuiltinFunction.Location> locations) {
        if ("ARRAY".equals(functionName)) {
            if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_LEFT_BRACKET)) {
                return false;
            }
            if (SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
                this.parseQueryExpression(builder, level);
                SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
            }
            return true;
        }
        return super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain, ignoreParens, locations);
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, HsqlExpressionParsing::parenthesized_values_expr, HsqlDmlParsing::top_query_expression_simple, HsqlParser::parseTopQueryExpressionTail, HsqlExpressionParsing::row_element_list, (b, l) -> HsqlExpressionParsing.root_expr_0(b, l, -1) && HsqlExpressionParsing.row_element_list_separator(b, l) && HsqlExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, HsqlDmlParsing::parenthesized_aliased_join_expression, HsqlDmlParsing::top_query_expression, HsqlParser::parseTopQueryExpressionTail, (b, l) -> HsqlDmlParsing.join_expression(b, l, -1), (b, l) -> HsqlDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return HsqlGeneratedParser.table_opt_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        HsqlDmlParsing.query_expression_0(builder, level, -1);
        return HsqlDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

