/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.Maplet;

public final class CachingMaplet<K, V>
implements Maplet<K, V> {
    private static final Object NULL_OBJECT = new Object();
    private final LoadingCache<K, V> myCache;
    private final Maplet<K, V> myDelegate;

    public CachingMaplet(Maplet<K, V> delegate, int maxCacheSize) {
        this.myDelegate = delegate;
        this.myCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).build(key -> {
            V val = this.myDelegate.get(key);
            return val != null ? val : NULL_OBJECT;
        });
    }

    @Override
    public boolean containsKey(K key) {
        return this.myCache.getIfPresent(key) != null || this.myDelegate.containsKey(key);
    }

    @Override
    @Nullable
    public V get(K key) {
        Object val = this.myCache.get(key);
        return (V)(val == NULL_OBJECT ? null : val);
    }

    @Override
    public void put(K key, @NotNull V value) {
        if (value == null) {
            CachingMaplet.$$$reportNull$$$0(0);
        }
        try {
            this.myDelegate.put(key, value);
        }
        finally {
            if (this.myCache.getIfPresent(key) != null) {
                this.myCache.put(key, value);
            }
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.myDelegate.remove(key);
        }
        finally {
            this.myCache.invalidate(key);
        }
    }

    @Override
    @NotNull
    public Iterable<K> getKeys() {
        Iterable iterable = this.myDelegate.getKeys();
        if (iterable == null) {
            CachingMaplet.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    @Override
    public void close() throws IOException {
        this.myCache.invalidateAll();
        this.myDelegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.myDelegate.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/CachingMaplet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/CachingMaplet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

