/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00182\u0006\u0010\u0017\u001a\u00020\b\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016\"\u001d\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"JUPYTER_EDITOR_KEY", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "", "Lcom/intellij/openapi/editor/Editor;", "getJUPYTER_EDITOR_KEY", "()Lcom/intellij/openapi/util/KeyWithDefaultValue;", "NOTEBOOK_VIRTUAL_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getNOTEBOOK_VIRTUAL_FILE_KEY", "()Lcom/intellij/openapi/util/Key;", "toJupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "Lcom/intellij/notebooks/jupyter/core/jupyter/CellType;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "document", "Lcom/intellij/openapi/editor/Document;", "toJupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "file", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "toEditorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "intellij.jupyter.core"})
public final class JupyterCellLinesExtensionsKt {
    @NotNull
    private static final KeyWithDefaultValue<Set<Editor>> JUPYTER_EDITOR_KEY;
    @NotNull
    private static final Key<BackedNotebookVirtualFile> NOTEBOOK_VIRTUAL_FILE_KEY;

    @NotNull
    public static final KeyWithDefaultValue<Set<Editor>> getJUPYTER_EDITOR_KEY() {
        return JUPYTER_EDITOR_KEY;
    }

    @NotNull
    public static final Key<BackedNotebookVirtualFile> getNOTEBOOK_VIRTUAL_FILE_KEY() {
        return NOTEBOOK_VIRTUAL_FILE_KEY;
    }

    @NotNull
    public static final JupyterCellType toJupyterCellType(@NotNull CellType $this$toJupyterCellType) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCellType, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toJupyterCellType.ordinal()]) {
            case 1 -> JupyterCellType.Companion.getRAW();
            case 2 -> JupyterCellType.Companion.getMARKDOWN();
            case 3 -> JupyterCellType.Companion.getCODE();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final JupyterCellType toJupyterCellType(@NotNull NotebookCellLines.Interval $this$toJupyterCellType, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCellType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String topMarker = $this$toJupyterCellType.getTopMarker(document);
        if (Intrinsics.areEqual((Object)topMarker, (Object)"#%% sql")) {
            return JupyterCellType.Companion.getSQL();
        }
        if (Intrinsics.areEqual((Object)topMarker, (Object)"#%% data_input")) {
            return JupyterCellType.Companion.getDATA_INPUT();
        }
        return JupyterCellLinesExtensionsKt.toJupyterCellType($this$toJupyterCellType.getType());
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull JupyterFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiFileExtensionsKt.getNotebookVirtualFile(psiFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile file = backedNotebookVirtualFile;
        return JupyterCellLinesExtensionsKt.toJupyterCell($this$toJupyterCell, file);
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor);
        return jupyterNotebook != null ? jupyterNotebook.getCellOrNull($this$toJupyterCell.getOrdinal()) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JupyterNotebook jupyterNotebook = file.getNotebookOrNull();
        return jupyterNotebook != null ? jupyterNotebook.getCellOrNull($this$toJupyterCell.getOrdinal()) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookIntervalPointer $this$toJupyterCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellLines.Interval interval = $this$toJupyterCell.get();
        return interval != null ? JupyterCellLinesExtensionsKt.toJupyterCell(interval, editor) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookIntervalPointer $this$toJupyterCell, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        NotebookCellLines.Interval interval = $this$toJupyterCell.get();
        return interval != null ? JupyterCellLinesExtensionsKt.toJupyterCell(interval, file) : null;
    }

    @Nullable
    public static final EditorCell toEditorCell(@NotNull NotebookIntervalPointer $this$toEditorCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEditorCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        return notebookCellInlayManager != null ? notebookCellInlayManager.getCell($this$toEditorCell) : null;
    }

    private static final Set JUPYTER_EDITOR_KEY$lambda$0() {
        return ContainerUtil.createWeakSet();
    }

    static {
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"JUPYTER_EDITOR_KEY", JupyterCellLinesExtensionsKt::JUPYTER_EDITOR_KEY$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        JUPYTER_EDITOR_KEY = keyWithDefaultValue;
        Key key = Key.create((String)"NOTEBOOK_VIRTUAL_FILE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NOTEBOOK_VIRTUAL_FILE_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CellType.values().length];
            try {
                nArray[CellType.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.CODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

