/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackageRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.function.Supplier;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodePackageEditor
implements ComboBoxEditor {
    private final DefaultComboBoxModel<NodePackageRef> myComboBoxModel;
    private final JPanel myMainPanel;
    private final JBTextField myTextField;
    private final SimpleColoredComponent myDetailsComp;
    private final SimpleColoredComponent myVersionComp;
    private final Color myNormalForegroundColor;
    private final NodePackageDescriptor myDescriptor;
    private final TextComponentAccessor<ComboBox<NodePackageRef>> myTextComponentAccessor;
    private final NodePackageRefResolver myResolver;
    private final Project myProject;
    private final Supplier<? extends NodeJsInterpreter> myInterpreterSupplier;

    NodePackageEditor(@NotNull Project project, @NotNull DefaultComboBoxModel<NodePackageRef> comboBoxModel, @NotNull NodePackageDescriptor descriptor, @NotNull NodePackageRefResolver resolver, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageEditor.$$$reportNull$$$0(0);
        }
        if (comboBoxModel == null) {
            NodePackageEditor.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            NodePackageEditor.$$$reportNull$$$0(2);
        }
        if (resolver == null) {
            NodePackageEditor.$$$reportNull$$$0(3);
        }
        this.myMainPanel = new JPanel(new GridBagLayout()){
            {
                this.setBorder((Border)JBUI.Borders.empty());
            }

            @Override
            public synchronized void addFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.addFocusListener(l);
            }

            @Override
            public synchronized void removeFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.removeFocusListener(l);
            }

            @Override
            public void setFocusable(boolean focusable) {
                super.setFocusable(false);
            }

            @Override
            public void setBorder(Border border) {
                super.setBorder((Border)JBUI.Borders.empty());
            }

            @Override
            public void requestFocus() {
                NodePackageEditor.this.myTextField.requestFocus();
            }

            @Override
            public synchronized void addKeyListener(KeyListener l) {
                NodePackageEditor.this.myTextField.addKeyListener(l);
            }

            @Override
            public synchronized void removeKeyListener(KeyListener l) {
                NodePackageEditor.this.myTextField.removeKeyListener(l);
            }
        };
        this.myTextField = new JBTextField();
        this.myDetailsComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myNormalForegroundColor = this.myTextField.getForeground();
        this.myTextComponentAccessor = new NodePackageComboBoxTextComponentAccessor();
        this.myProject = project;
        this.myComboBoxModel = comboBoxModel;
        this.myInterpreterSupplier = interpreterSupplier;
        this.myMainPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.myMainPanel.setBackground(this.myTextField.getBackground());
        this.myTextField.setOpaque(false);
        this.myTextField.setMinimumSize(new Dimension(0, 0));
        this.myTextField.setBorder((Border)JBUI.Borders.empty());
        this.myDetailsComp.setOpaque(false);
        this.myDetailsComp.setForeground(this.myTextField.getForeground());
        this.myDetailsComp.setIpad((Insets)JBInsets.emptyInsets());
        this.myDetailsComp.setMyBorder(null);
        this.myVersionComp.setOpaque(false);
        this.myVersionComp.setForeground(this.myTextField.getForeground());
        this.myVersionComp.setIpad((Insets)JBInsets.emptyInsets());
        this.myVersionComp.setMyBorder(null);
        this.myDescriptor = descriptor;
        this.myResolver = resolver;
        String hintText = this.myDescriptor.getHintText();
        if (hintText != null) {
            this.myTextField.getEmptyText().setText(hintText);
        }
        this.myMainPanel.add((Component)this.myTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 1, (Insets)JBInsets.emptyInsets(), JBUIScale.scale((int)1), 0));
        this.myMainPanel.add((Component)this.myDetailsComp, new GridBagConstraints(1, 0, 1, 1, 1.0E100, 0.0, 256, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.myVersionComp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                NodePackageEditor.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/util/NodePackageEditor$2", "textChanged"));
            }
        });
        this.myMainPanel.setFocusable(false);
        this.myVersionComp.setFocusable(false);
    }

    void update() {
        NodePackageRef ref2 = this.getItem();
        NodePackage pkg = !ref2.getIdentifier().equals(NodePackageField.SELECT_PACKAGE.getIdentifier()) ? this.myResolver.resolve(ref2) : null;
        NodeJsInterpreter interpreter2 = this.myInterpreterSupplier != null ? this.myInterpreterSupplier.get() : null;
        boolean valid = this.myResolver.isValidPackage(ref2, pkg, interpreter2);
        this.myTextField.setForeground(valid ? this.myNormalForegroundColor : JBColor.red);
        this.updateDetailsComponentVisibility(pkg == null || !pkg.isEmptyPath() && !ref2.isConstant());
        NodePackageRenderer.formatDetailsAndVersionComponents(this.myDetailsComp, this.myVersionComp, ref2, pkg, interpreter2, false, this.myProject, null, -1);
    }

    private void updateDetailsComponentVisibility(boolean detailsComponentVisible) {
        this.myDetailsComp.setVisible(detailsComponentVisible);
        if (detailsComponentVisible) {
            this.myTextField.setMinimumSize(new Dimension(this.myTextField.getPreferredSize().width, this.myTextField.getMinimumSize().height));
        } else {
            this.myTextField.setMinimumSize(null);
        }
    }

    @NotNull
    public JTextField getTextField() {
        JBTextField jBTextField = this.myTextField;
        if (jBTextField == null) {
            NodePackageEditor.$$$reportNull$$$0(4);
        }
        return jBTextField;
    }

    @Override
    @NotNull
    public Component getEditorComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            NodePackageEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    TextComponentAccessor<ComboBox<NodePackageRef>> getTextComponentAccessor() {
        TextComponentAccessor<ComboBox<NodePackageRef>> textComponentAccessor = this.myTextComponentAccessor;
        if (textComponentAccessor == null) {
            NodePackageEditor.$$$reportNull$$$0(6);
        }
        return textComponentAccessor;
    }

    @Override
    public void setItem(Object anObject) {
        String text;
        NodePackageRef ref2 = (NodePackageRef)ObjectUtils.tryCast((Object)anObject, NodePackageRef.class);
        String string = text = ref2 != null ? ref2.getPresentableText() : "";
        if (!this.myTextField.getText().equals(text)) {
            this.myTextField.setText(text);
        }
    }

    @Override
    @NotNull
    public NodePackageRef getItem() {
        NodePackageRef selectedRef;
        Object object = this.myComboBoxModel.getSelectedItem();
        if (object instanceof NodePackageRef && (selectedRef = (NodePackageRef)object).getPresentableText().trim().equals(this.myTextField.getText().trim())) {
            NodePackageRef nodePackageRef = selectedRef;
            if (nodePackageRef == null) {
                NodePackageEditor.$$$reportNull$$$0(7);
            }
            return nodePackageRef;
        }
        String text = OSAgnosticPathUtil.expandUserHome((String)this.myTextField.getText().trim());
        NodePackageRef ref2 = this.myDescriptor.createPackageRef(text);
        int ind = this.myComboBoxModel.getIndexOf(ref2);
        NodePackageRef nodePackageRef = ind >= 0 ? this.myComboBoxModel.getElementAt(ind) : ref2;
        if (nodePackageRef == null) {
            NodePackageEditor.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    @Override
    public void selectAll() {
        this.myTextField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTextField, true));
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.myTextField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.myTextField.removeActionListener(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBoxModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextComponentAccessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private class NodePackageComboBoxTextComponentAccessor
    implements TextComponentAccessor<ComboBox<NodePackageRef>> {
        private NodePackageComboBoxTextComponentAccessor() {
        }

        public String getText(ComboBox<NodePackageRef> component) {
            NodePackage pkg;
            Object obj = component.getEditor().getItem();
            if (obj instanceof NodePackageRef && (pkg = NodePackageEditor.this.myResolver.resolve((NodePackageRef)obj)) != null) {
                return pkg.getSystemDependentPath();
            }
            return "";
        }

        public void setText(ComboBox<NodePackageRef> component, @NotNull String text) {
            if (text == null) {
                NodePackageComboBoxTextComponentAccessor.$$$reportNull$$$0(0);
            }
            component.getEditor().setItem(NodePackageEditor.this.myDescriptor.createPackageRef(text));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/util/NodePackageEditor$NodePackageComboBoxTextComponentAccessor", "setText"));
        }
    }
}

