/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowContinuePattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.StepResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/formatter/model/FirstAndContinuePattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "firstNodeMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "continuePattern", "Lcom/intellij/sql/formatter/model/FlowContinuePattern;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Lcom/intellij/sql/formatter/model/NodeMatcher;Lcom/intellij/sql/formatter/model/FlowContinuePattern;Lkotlin/jvm/functions/Function0;)V", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "expandSingleNode", "", "getExpandSingleNode", "()Z", "getDescription", "", "intellij.database.sql.core.impl"})
public final class FirstAndContinuePattern
extends FlowPattern {
    @NotNull
    private final NodeMatcher firstNodeMatcher;
    @NotNull
    private final FlowContinuePattern continuePattern;

    public FirstAndContinuePattern(@NotNull NodeMatcher firstNodeMatcher, @NotNull FlowContinuePattern continuePattern, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)firstNodeMatcher, (String)"firstNodeMatcher");
        Intrinsics.checkNotNullParameter((Object)continuePattern, (String)"continuePattern");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(producer, null);
        this.firstNodeMatcher = firstNodeMatcher;
        this.continuePattern = continuePattern;
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        if (since >= n) {
            return null;
        }
        ASTNode firstNode = nodes.get(since);
        if (!this.firstNodeMatcher.matches(firstNode)) {
            return null;
        }
        int nLimited = this.continuePattern.limitLength() == Integer.MAX_VALUE ? n : Math.min(since + this.continuePattern.limitLength(), n);
        int acceptedTill = 0;
        int k = since + 1;
        block6: while (k <= nLimited && acceptedTill == 0) {
            ASTNode node = k < n ? nodes.get(k) : null;
            ++k;
            if (node != null) {
                IElementType t_k;
                if (node instanceof PsiErrorElement) continue;
                Intrinsics.checkNotNullExpressionValue((Object)node.getElementType(), (String)"getElementType(...)");
                if (t_k == TokenType.WHITE_SPACE) continue;
            }
            StepResult r = this.continuePattern.input(node);
            switch (WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
                case 1: {
                    acceptedTill = -1;
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    acceptedTill = k - 1;
                    continue block6;
                }
                case 4: {
                    acceptedTill = k;
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        while (acceptedTill > since && this.continuePattern.rollback(nodes.get(acceptedTill - 1))) {
            --acceptedTill;
        }
        return acceptedTill > since ? RangesKt.until((int)since, (int)acceptedTill) : null;
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.continuePattern.getRole();
    }

    @Override
    public boolean getExpandSingleNode() {
        return this.continuePattern.expandSingleNode();
    }

    @Override
    @NotNull
    protected String getDescription() {
        return "Continue with " + this.continuePattern;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StepResult.values().length];
            try {
                nArray[StepResult.REJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepResult.FORWARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepResult.ACCEPT_EXCLUSIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepResult.ACCEPT_INCLUSIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

