/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0000\"\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0015\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0018\u0010\u0017\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016\"\u0018\u0010\u0018\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"SQL_SETTING_FIELDS", "", "Ljava/lang/reflect/Field;", "[Ljava/lang/reflect/Field;", "createSqlFileForCodeStyleSettingsPreview", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "settingsActuallyDifferent", "", "settings1", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "settings2", "copyCodeStyleSettings", "", "source", "target", "isPublic", "(Ljava/lang/reflect/Field;)Z", "isStatic", "isDeprecated", "intellij.database.sql.core.impl"})
@JvmName(name="SqlCodeStyleSettingsUtil")
@SourceDebugExtension(value={"SMAP\nSqlCodeStyleSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCodeStyleSettingsUtil.kt\ncom/intellij/sql/formatter/settings/SqlCodeStyleSettingsUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n3919#2:69\n4434#2,2:70\n3919#2:72\n4434#2,2:73\n*S KotlinDebug\n*F\n+ 1 SqlCodeStyleSettingsUtil.kt\ncom/intellij/sql/formatter/settings/SqlCodeStyleSettingsUtil\n*L\n55#1:69\n55#1:70,2\n18#1:72\n18#1:73,2\n*E\n"})
public final class SqlCodeStyleSettingsUtil {
    @JvmField
    @NotNull
    public static final Field[] SQL_SETTING_FIELDS;

    @NotNull
    public static final PsiFile createSqlFileForCodeStyleSettingsPreview(@NotNull Project project, @NotNull String text, @NotNull SqlLanguageDialect dialect) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("preview\u22c8style.sql", (Language)dialect, (CharSequence)text, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    public static final boolean settingsActuallyDifferent(@NotNull SqlCodeStyleSettings settings1, @NotNull SqlCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings1, (String)"settings1");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings2");
        if (settings1 == settings2) {
            return false;
        }
        for (Field f : SQL_SETTING_FIELDS) {
            if (Intrinsics.areEqual((Object)f.get(settings1), (Object)f.get(settings2))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyCodeStyleSettings(@NotNull SqlCodeStyleSettings source, @NotNull SqlCodeStyleSettings target) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (source == target) {
            return;
        }
        CommonCodeStyleSettings commonCodeStyleSettings = source.getCorrespondedCommonSettings();
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCorrespondedCommonSettings(...)");
        CommonCodeStyleSettings sourceCommon = commonCodeStyleSettings;
        CommonCodeStyleSettings commonCodeStyleSettings2 = target.getCorrespondedCommonSettings();
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings2, (String)"getCorrespondedCommonSettings(...)");
        CommonCodeStyleSettings targetCommon = commonCodeStyleSettings2;
        if (sourceCommon != targetCommon) {
            targetCommon.copyFrom(sourceCommon);
        }
        Field[] fieldArray = SQL_SETTING_FIELDS;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!target.isSettingHidden(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Field[] fieldsToCopy = (Field[])UtilKt.toArray((Collection)((List)destination$iv$iv), (Object[])new Field[0]);
        ReflectionUtil.copyFields((Field[])fieldsToCopy, (Object)source, (Object)target);
        target.myVersion = source.myVersion;
    }

    private static final boolean isPublic(Field $this$isPublic) {
        return Modifier.isPublic($this$isPublic.getModifiers());
    }

    private static final boolean isStatic(Field $this$isStatic) {
        return Modifier.isStatic($this$isStatic.getModifiers());
    }

    private static final boolean isDeprecated(Field $this$isDeprecated) {
        return $this$isDeprecated.isAnnotationPresent(Deprecated.class);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Field[] fieldArray = SqlCodeStyleSettings.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(SqlCodeStyleSettingsUtil.isPublic(it) && Character.isUpperCase(it.getName().charAt(0)) && !SqlCodeStyleSettingsUtil.isStatic(it) && !SqlCodeStyleSettingsUtil.isDeprecated(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        SQL_SETTING_FIELDS = (Field[])UtilKt.toArray((Collection)((List)var3_3), (Object[])new Field[0]);
    }
}

