/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution;

import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.appServers.serverInstances.DefaultJ2EEServerEvent;
import com.intellij.javaee.appServers.serverInstances.DefaultServerInstance;
import com.intellij.javaee.appServers.serverInstances.J2EEServerEvent;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class LocalJavaeeServerProcessHandler
extends OSProcessHandler
implements J2EEProcess,
KillableProcess {
    private static final Logger LOG = Logger.getInstance(LocalJavaeeServerProcessHandler.class);
    private static final Pattern YES_OR_NO_QUESTION_MARK = Pattern.compile("\\(\\S/(?<nope>\\S)\\)\\?");
    protected final OSProcessHandler myStartupHandler;
    protected final J2EEProcessHandlerHelper myHelper;
    private boolean myIsInsideStartNotification = false;
    protected final boolean myStartupScriptTerminatesAfterServerStartup;

    public LocalJavaeeServerProcessHandler(J2EEProcessHandlerHelper helper, OSProcessHandler startupHandler, boolean startupScriptTerminatesAfterServerStartup) {
        super(startupHandler.getProcess(), startupHandler.getCommandLine(), EncodingManager.getInstance().getDefaultCharset());
        this.myStartupScriptTerminatesAfterServerStartup = startupScriptTerminatesAfterServerStartup;
        this.myHelper = helper;
        this.myStartupHandler = startupHandler;
        this.init();
    }

    private void init() {
        BuildManager.ALLOW_AUTOMAKE.set((UserDataHolder)this, (Object)Boolean.TRUE);
        ProcessListener baseProcessListener = new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LocalJavaeeServerProcessHandler.this.myIsInsideStartNotification) {
                    return;
                }
                LocalJavaeeServerProcessHandler.super.startNotify();
                LocalJavaeeServerProcessHandler.this.myHelper.startNotify();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalJavaeeServerProcessHandler.this.myStartupHandler.removeProcessListener((ProcessListener)this);
                ApplicationManager.getApplication().invokeLater(() -> LocalJavaeeServerProcessHandler.this.onBaseProcessTerminated());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (LocalJavaeeServerProcessHandler.this.myIsInsideStartNotification && ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    return;
                }
                String text = StringUtil.notNullize((String)event.getText());
                this.handleTerminateBatchJobQuestion(text);
                LocalJavaeeServerProcessHandler.this.notifyTextAvailable(text, outputType);
            }

            private void handleTerminateBatchJobQuestion(String question) {
                if (!SystemInfo.isWindows || !this.isJBossIntegration()) {
                    return;
                }
                if ((question = question.trim()).contains("Terminate batch job")) {
                    this.postQuestionAnswer("N");
                } else if (question.endsWith("?")) {
                    int lastSpace = question.lastIndexOf(32);
                    if (lastSpace < 0) {
                        return;
                    }
                    String lastWord = question.substring(lastSpace + " ".length());
                    Matcher matcher = YES_OR_NO_QUESTION_MARK.matcher(lastWord);
                    if (matcher.matches()) {
                        String charForNo = matcher.group("nope");
                        this.postQuestionAnswer(charForNo);
                    }
                }
            }

            private boolean isJBossIntegration() {
                return Optional.ofNullable(LocalJavaeeServerProcessHandler.this.myHelper.getServerInstance()).map(J2EEServerInstance::getIntegration).map(AppServerIntegration::getIntegrationId).map("JBossIntegration"::equals).orElse(false);
            }

            private void postQuestionAnswer(String text) {
                byte[] answer = (text + "\n").getBytes(StandardCharsets.UTF_8);
                try {
                    LocalJavaeeServerProcessHandler.this.myStartupHandler.getProcessInput().write(answer);
                    LocalJavaeeServerProcessHandler.this.myStartupHandler.getProcessInput().flush();
                    LOG.debug("Auto-answering completed: `" + text + "`");
                }
                catch (IOException e) {
                    LOG.error("Cannot auto-answer for: " + text, (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/appServers/run/execution/LocalJavaeeServerProcessHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myStartupHandler.addProcessListener(baseProcessListener);
    }

    public void destroyProcess() {
        this.detachProcess();
    }

    protected abstract void onBaseProcessTerminated();

    public abstract void shutdown();

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myStartupScriptTerminatesAfterServerStartup) {
            return;
        }
        this.myHelper.onTerminated(exitCode);
        super.onOSProcessTerminated(exitCode);
    }

    @Override
    public void terminate() {
        this.myHelper.onTerminated(0);
        if (this.myStartupScriptTerminatesAfterServerStartup) {
            this.notifyProcessTerminated(0);
        }
    }

    @NotNull
    protected Reader createProcessOutReader() {
        return new StringReader("");
    }

    @NotNull
    protected Reader createProcessErrReader() {
        return new StringReader("");
    }

    public void terminateAndNotify() {
        this.myHelper.onTerminated(0);
        this.notifyProcessTerminated(0);
    }

    @Override
    public void started() {
        this.notifyTextAvailable(AppServersIntegrationBundle.message((String)"message.text.connected.to.server", (Object[])new Object[0]) + "\n", ProcessOutputTypes.STDOUT);
    }

    @Override
    public CommonStrategy getCommonStrategy() {
        return this.myHelper.getStrategy();
    }

    @Override
    public void invokeTerminate() {
        this.myStartupHandler.destroyProcess();
    }

    public boolean canKillProcess() {
        return !this.myStartupScriptTerminatesAfterServerStartup && this.myStartupHandler != null && !this.myStartupHandler.isProcessTerminated();
    }

    public void killProcess() {
        this.killProcessTree(this.myStartupHandler.getProcess());
        J2EEServerInstance serverInstance = this.myHelper.getServerInstance();
        if (serverInstance instanceof DefaultServerInstance) {
            ((DefaultServerInstance)serverInstance).fireServerListeners((J2EEServerEvent)new DefaultJ2EEServerEvent(false, false, false, true));
        }
    }

    public void startNotify() {
        this.myIsInsideStartNotification = true;
        try {
            super.startNotify();
            this.myStartupHandler.startNotify();
            this.myHelper.startNotify();
        }
        finally {
            this.myIsInsideStartNotification = false;
        }
    }

    protected void destroyProcessImpl() {
        LOG.debug("shutting down server");
        boolean starting = this.myHelper.getServerInstance().isStarting();
        this.myHelper.destroy();
        if (this.myHelper.getServerInstance().getIntegration().isKillOnDestroyWhileStarting() && starting) {
            this.killProcess();
        } else {
            this.shutdown();
        }
    }

    protected void detachProcessImpl() {
        this.destroyProcessImpl();
    }

    @Override
    public J2EEServerInstance getServerInstance() {
        return this.myHelper.getServerInstance();
    }

    public Charset getCharset() {
        return this.myStartupHandler.getCharset();
    }
}

