/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.autodetected;

import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringAutodetectedModelsSearcher;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringAnnotationConfigApplicationContextSearcher
implements SpringAutodetectedModelsSearcher {
    @Override
    @NotNull
    public Set<SpringModel> getAutodetectedModels(@NotNull Module module, @NotNull Module contextModule) {
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(0);
        }
        if (contextModule == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(1);
        }
        Set<SpringModel> set = SpringAnnotationConfigApplicationContextSearcher.getSpringAnnotationConfigApplicationContexts(module).stream().map(config -> config.togSpringModel(module)).collect(Collectors.toSet());
        if (set == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static Set<AnnotationConfigApplicationContexts> getSpringAnnotationConfigApplicationContexts(@NotNull Module module) {
        PsiClass annotationConfigAppContext;
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(3);
        }
        if ((annotationConfigAppContext = SpringCommonUtils.findLibraryClass(module, "org.springframework.context.annotation.AnnotationConfigApplicationContext")) == null) {
            Set<AnnotationConfigApplicationContexts> set = Collections.emptySet();
            if (set == null) {
                SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<? extends LocalSearchScope> scopes = SpringAnnotationConfigApplicationContextSearcher.getAnnotationConfigApplicationContextScopes(module);
        if (scopes.isEmpty()) {
            Set<AnnotationConfigApplicationContexts> set = Collections.emptySet();
            if (set == null) {
                SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<AnnotationConfigApplicationContexts> set = SpringAnnotationConfigApplicationContextSearcher.getBasePackagesConstructor(annotationConfigAppContext).map(method -> SpringAnnotationConfigApplicationContextSearcher.getAnnotationConfigApplicationContexts(module, method, scopes)).orElse(Collections.emptySet());
        if (set == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static Set<? extends LocalSearchScope> getAnnotationConfigApplicationContextScopes(@NotNull Module module) {
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(7);
        }
        Set set = SearchService.getInstance().searchWord(module.getProject(), "AnnotationConfigApplicationContext").inContexts(SearchContext.inCode(), new SearchContext[0]).inScope((SearchScope)module.getModuleRuntimeScope(false)).buildQuery(occurrence -> {
            if (occurrence.getOffsetInStart() != 0) {
                return Collections.emptySet();
            }
            UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)occurrence.getStart(), UMethod.class);
            return uMethod != null ? Collections.singleton(uMethod) : Collections.emptySet();
        }).findAll().stream().map(method -> new LocalSearchScope((PsiElement)method.getJavaPsi())).collect(Collectors.toSet());
        if (set == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Set<AnnotationConfigApplicationContexts> getAnnotationConfigApplicationContexts(@NotNull Module module, PsiMethod constructor, @NotNull Set<? extends LocalSearchScope> launcherScopes) {
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(9);
        }
        if (launcherScopes == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(10);
        }
        Set<AnnotationConfigApplicationContexts> set = launcherScopes.stream().flatMap(scope -> SpringFunctionalSearchersUtils.findMethodCallsWithSearchService(constructor, (SearchScope)scope).stream().map(uCallExpression -> new AnnotationConfigApplicationContexts((UCallExpression)uCallExpression, SpringAnnotationConfigApplicationContextSearcher.getPsiPackages(module, uCallExpression))).filter(contexts -> !contexts.packages.isEmpty())).collect(Collectors.toSet());
        if (set == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private static Optional<PsiMethod> getBasePackagesConstructor(PsiClass annotationConfigAppContext) {
        Optional<PsiMethod> optional = Arrays.stream(annotationConfigAppContext.findMethodsByName("AnnotationConfigApplicationContext", false)).filter(method -> SpringAnnotationConfigApplicationContextSearcher.isBasePackagesConstructor(method)).findFirst();
        if (optional == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(12);
        }
        return optional;
    }

    private static boolean isBasePackagesConstructor(@NotNull PsiMethod runMethod) {
        PsiParameter[] parameters;
        if (runMethod == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(13);
        }
        return (parameters = runMethod.getParameterList().getParameters()).length == 1 && "basePackages".equals(parameters[0].getName());
    }

    @NotNull
    private static Set<PsiPackage> getPsiPackages(@NotNull Module module, @NotNull UCallExpression uCallExpression) {
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(14);
        }
        if (uCallExpression == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(15);
        }
        HashSet<PsiPackage> packages = new HashSet<PsiPackage>();
        for (UExpression argument : uCallExpression.getValueArguments()) {
            if (!(argument instanceof ULiteralExpression)) continue;
            ContainerUtil.addAll(packages, SpringAnnotationConfigApplicationContextSearcher.getClassConfiguration((ULiteralExpression)argument, module));
        }
        HashSet<PsiPackage> hashSet = packages;
        if (hashSet == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    private static Set<PsiPackage> getClassConfiguration(ULiteralExpression argument, @NotNull Module module) {
        if (module == null) {
            SpringAnnotationConfigApplicationContextSearcher.$$$reportNull$$$0(17);
        }
        HashSet<PsiPackage> pkgs = new HashSet<PsiPackage>();
        String pkg = UastUtils.evaluateString((UExpression)argument);
        if (pkg == null) {
            return pkgs;
        }
        ContainerUtil.addIfNotNull(pkgs, (Object)JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(pkg));
        return pkgs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/autodetected/SpringAnnotationConfigApplicationContextSearcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherScopes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/autodetected/SpringAnnotationConfigApplicationContextSearcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutodetectedModels";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringAnnotationConfigApplicationContexts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigApplicationContextScopes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePackagesConstructor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutodetectedModels";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpringAnnotationConfigApplicationContexts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationConfigApplicationContextScopes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBasePackagesConstructor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiPackages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8, 11, 12, 16 -> new IllegalStateException(string);
        };
    }

    private record AnnotationConfigApplicationContexts(@NotNull UCallExpression expression, @NotNull Set<PsiPackage> packages) {
        @NotNull
        private final UCallExpression expression;
        @NotNull
        private final Set<PsiPackage> packages;

        private AnnotationConfigApplicationContexts(@NotNull UCallExpression expression, @NotNull Set<PsiPackage> packages) {
            if (expression == null) {
                AnnotationConfigApplicationContexts.$$$reportNull$$$0(0);
            }
            if (packages == null) {
                AnnotationConfigApplicationContexts.$$$reportNull$$$0(1);
            }
        }

        public SpringModel togSpringModel(final @NotNull Module module) {
            if (module == null) {
                AnnotationConfigApplicationContexts.$$$reportNull$$$0(2);
            }
            return new SpringModel(module){

                @Override
                @NotNull
                public Set<CommonSpringModel> getRelatedModels(boolean checkActiveProfiles) {
                    Set<CommonSpringModel> set = Set.of(new ComponentScanPackagesModel((NotNullLazyValue<? extends Set<PsiPackage>>)NotNullLazyValue.lazy(() -> packages), module, false));
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/autodetected/SpringAnnotationConfigApplicationContextSearcher$AnnotationConfigApplicationContexts$1", "getRelatedModels"));
                }
            };
        }

        @NotNull
        public UCallExpression expression() {
            UCallExpression uCallExpression = this.expression;
            if (uCallExpression == null) {
                AnnotationConfigApplicationContexts.$$$reportNull$$$0(3);
            }
            return uCallExpression;
        }

        @NotNull
        public Set<PsiPackage> packages() {
            Set<PsiPackage> set = this.packages;
            if (set == null) {
                AnnotationConfigApplicationContexts.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/autodetected/SpringAnnotationConfigApplicationContextSearcher$AnnotationConfigApplicationContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/autodetected/SpringAnnotationConfigApplicationContextSearcher$AnnotationConfigApplicationContexts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "packages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "togSpringModel";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

