/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.xml.parsing.XmlParserBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001bH\u0002J\u0012\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/parsing/JSXmlTokensParser;", "Lcom/intellij/lang/javascript/parsing/JSXmlParser;", "parser", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "builder", "Lcom/intellij/lang/PsiBuilder;", "embeddedJsxElementTypes", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/lang/PsiBuilder;Lcom/intellij/psi/tree/TokenSet;)V", "getBuilder", "()Lcom/intellij/lang/PsiBuilder;", "emptyTagNameAllowed", "", "withEmptyTagNameAllowed", "isXmlTagStart", "currentToken", "Lcom/intellij/psi/tree/IElementType;", "parseTag", "names", "Lcom/intellij/util/containers/Stack;", "", "parseXmlJsScript", "", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "xmlLiteralExpression", "getXmlLiteralExpression", "()Lcom/intellij/psi/tree/IElementType;", "parseSpecialTagEntity", "currentTokenType", "parseAttribute", "parseAttributeValue", "Companion", "intellij.javascript.parser"})
public class JSXmlTokensParser
implements JSXmlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiBuilder builder;
    @NotNull
    private final TokenSet embeddedJsxElementTypes;
    private boolean emptyTagNameAllowed;
    @Nullable
    private final JavaScriptParser parser;
    @NotNull
    private static final WhitespacesAndCommentsBinder INCOMPLETE_TAG_WHITESPACE_BINDER = JSXmlTokensParser::INCOMPLETE_TAG_WHITESPACE_BINDER$lambda$0;

    @NotNull
    protected final PsiBuilder getBuilder() {
        return this.builder;
    }

    public JSXmlTokensParser(@NotNull JavaScriptParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.builder = parser.builder;
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        this.embeddedJsxElementTypes = tokenSet;
        this.parser = parser;
    }

    public JSXmlTokensParser(@NotNull PsiBuilder builder, @NotNull TokenSet embeddedJsxElementTypes) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)embeddedJsxElementTypes, (String)"embeddedJsxElementTypes");
        this.builder = builder;
        this.embeddedJsxElementTypes = embeddedJsxElementTypes;
        this.parser = null;
    }

    @NotNull
    public final JSXmlTokensParser withEmptyTagNameAllowed(boolean emptyTagNameAllowed) {
        this.emptyTagNameAllowed = emptyTagNameAllowed;
        return this;
    }

    @Override
    public boolean isXmlTagStart(@Nullable IElementType currentToken) {
        return currentToken == JSTokenTypes.XML_START_TAG_START || currentToken == JSTokenTypes.XML_START_TAG_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseTag(@NotNull Stack<String> names) {
        boolean bl;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        IElementType tokenType = this.builder.getTokenType();
        boolean bl2 = bl = JSTokenTypes.XML_START_TAG_START == tokenType || JSTokenTypes.XML_START_TAG_LIST == tokenType;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        String name = null;
        if (this.builder.getTokenType() == JSTokenTypes.XML_LBRACE) {
            StringBuilder nameBuilder = new StringBuilder();
            this.parseXmlJsScript(nameBuilder);
            name = nameBuilder.toString();
        } else {
            name = this.builder.getTokenText();
        }
        boolean seenEnd = JSTokenTypes.XML_START_TAG_LIST == tokenType;
        names.push((Object)name);
        boolean hasErrors = false;
        try {
            IElementType currentTokenType = this.builder.getTokenType();
            while (currentTokenType != null) {
                if (!JSElementTypes.XML_TOKENS.contains(currentTokenType) && !this.embeddedJsxElementTypes.contains(currentTokenType) && currentTokenType != JSTokenTypes.XML_LBRACE) {
                    PsiBuilder.Marker errorMarker;
                    if (this.parseSpecialTagEntity(currentTokenType)) {
                        currentTokenType = this.builder.getTokenType();
                        continue;
                    }
                    if (!seenEnd) {
                        this.builder.error(XmlParserBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                        boolean bl3 = false;
                        return bl3;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                    this.builder.advanceLexer();
                    errorMarker.error(JavaScriptParserBundle.message("javascript.parser.message.expected.xml.element", new Object[0]));
                    currentTokenType = this.builder.getTokenType();
                    continue;
                }
                if (currentTokenType == JSTokenTypes.XML_START_TAG_START || currentTokenType == JSTokenTypes.XML_START_TAG_LIST) {
                    this.parseTag(names);
                    currentTokenType = this.builder.getTokenType();
                    continue;
                }
                if (currentTokenType == JSTokenTypes.XML_EMPTY_TAG_END || currentTokenType == JSTokenTypes.XML_END_TAG_LIST) {
                    this.builder.advanceLexer();
                    boolean errorMarker = !hasErrors;
                    return errorMarker;
                }
                if (currentTokenType == JSTokenTypes.XML_END_TAG_START) {
                    if (!seenEnd) {
                        this.builder.error(XmlParserBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                        boolean errorMarker = false;
                        return errorMarker;
                    }
                    PsiBuilder.Marker marker3 = this.builder.mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
                    PsiBuilder.Marker endTagStart = marker3;
                    this.builder.advanceLexer();
                    IElementType type = this.builder.getTokenType();
                    if (type == XmlTokenType.XML_TAG_NAME || this.embeddedJsxElementTypes.contains(type) || type == JSTokenTypes.XML_LBRACE) {
                        String endName = null;
                        if (type == JSTokenTypes.XML_LBRACE) {
                            StringBuilder nameBuilder = new StringBuilder();
                            this.parseXmlJsScript(nameBuilder);
                            endName = nameBuilder.toString();
                        } else {
                            endName = this.builder.getTokenText();
                        }
                        if (!(StringUtil.equals((CharSequence)name, (CharSequence)endName) || endName != null && StringsKt.endsWith$default((String)endName, (String)"IntellijIdeaRulezzz", (boolean)false, (int)2, null))) {
                            if (names.contains((Object)endName)) {
                                endTagStart.rollbackTo();
                                Object[] objectArray = new Object[]{name};
                                this.builder.error(XmlParserBundle.message((String)"xml.parsing.named.element.is.not.closed", (Object[])objectArray));
                                boolean bl4 = !hasErrors;
                                return bl4;
                            }
                            this.builder.error(XmlParserBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                            hasErrors = true;
                        }
                        if (type != JSTokenTypes.XML_LBRACE) {
                            this.builder.advanceLexer();
                        }
                    } else if (!this.emptyTagNameAllowed && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
                        this.builder.error(XmlParserBundle.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
                        hasErrors = true;
                    }
                    if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END) {
                        this.builder.error(XmlParserBundle.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
                        hasErrors = true;
                    } else {
                        this.builder.advanceLexer();
                    }
                    endTagStart.drop();
                    boolean bl5 = !hasErrors;
                    return bl5;
                }
                if (currentTokenType == JSTokenTypes.XML_NAME) {
                    this.parseAttribute();
                    currentTokenType = this.builder.getTokenType();
                    continue;
                }
                if (currentTokenType == JSTokenTypes.XML_TAG_CONTENT) {
                    PsiBuilder.Marker xmlTextMarker;
                    Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                    this.builder.advanceLexer();
                    xmlTextMarker.done(JSElementTypes.XML_TEXT);
                    currentTokenType = this.builder.getTokenType();
                    continue;
                }
                if (currentTokenType == JSTokenTypes.XML_TAG_END) {
                    seenEnd = true;
                }
                if (currentTokenType == JSTokenTypes.XML_LBRACE) {
                    this.parseXmlJsScript(null);
                } else {
                    if (currentTokenType == JSTokenTypes.XML_RBRACE) {
                        Object[] objectArray = new Object[]{this.builder.getTokenText()};
                        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.unexpected.token", objectArray));
                    }
                    this.builder.advanceLexer();
                }
                if (currentTokenType != JSTokenTypes.XML_LBRACE && this.builder.getTokenType() == JSTokenTypes.XML_ATTR_EQUAL) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.attribute.name", new Object[0]));
                    hasErrors = true;
                }
                currentTokenType = this.builder.getTokenType();
            }
            boolean bl6 = !hasErrors;
            return bl6;
        }
        finally {
            names.pop();
            marker2.done(this.getXmlLiteralExpression());
            marker2.setCustomEdgeTokenBinders(null, INCOMPLETE_TAG_WHITESPACE_BINDER);
        }
    }

    private final void parseXmlJsScript(StringBuilder text) {
        block9: {
            int textStart = this.builder.getCurrentOffset();
            if (this.parser != null) {
                this.parser.getExpressionParser().parseScriptExpression(false);
            } else {
                boolean bl;
                boolean bl2 = bl = this.builder.getTokenType() == JSTokenTypes.XML_LBRACE;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                StringBuilder stringBuilder = text;
                if (stringBuilder != null) {
                    stringBuilder.append(this.builder.getTokenText());
                }
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker xmlJsScript = marker;
                this.builder.advanceLexer();
                int braceBalance = 1;
                while (braceBalance > 0 && !this.builder.eof()) {
                    IElementType tokenType = this.builder.getTokenType();
                    if (tokenType == JSTokenTypes.XML_LBRACE) {
                        ++braceBalance;
                    } else if (tokenType == JSTokenTypes.XML_RBRACE) {
                        --braceBalance;
                    }
                    StringBuilder stringBuilder2 = text;
                    if (stringBuilder2 != null) {
                        stringBuilder2.append(this.builder.getTokenText());
                    }
                    this.builder.advanceLexer();
                }
                xmlJsScript.collapse(JSElementTypes.XML_JS_SCRIPT);
            }
            StringBuilder stringBuilder = text;
            if (stringBuilder == null) break block9;
            CharSequence charSequence = this.builder.getOriginalText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOriginalText(...)");
            stringBuilder.append(StringUtil.trim((CharSequence)((CharSequence)new CharSequenceSubSequence(charSequence, textStart, this.builder.getCurrentOffset()))));
        }
    }

    @NotNull
    protected IElementType getXmlLiteralExpression() {
        return JSElementTypes.XML_LITERAL_EXPRESSION;
    }

    protected boolean parseSpecialTagEntity(@Nullable IElementType currentTokenType) {
        return false;
    }

    private final void parseAttribute() {
        boolean bl;
        boolean bl2 = bl = this.builder.getTokenType() == XmlTokenType.XML_NAME;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker att = marker;
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == XmlTokenType.XML_EQ) {
            this.builder.advanceLexer();
            this.parseAttributeValue();
        }
        att.done(JSElementTypes.XML_ATTRIBUTE);
    }

    private final void parseAttributeValue() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker attValue = marker;
        if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.builder.getTokenType()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(XmlParserBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END && this.builder.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            if (this.builder.getTokenType() == JSTokenTypes.XML_LBRACE) {
                this.parseXmlJsScript(null);
            } else {
                this.builder.advanceLexer();
            }
        }
        attValue.done(JSElementTypes.XML_ATTRIBUTE_VALUE);
    }

    private static final int INCOMPLETE_TAG_WHITESPACE_BINDER$lambda$0(List tokens, boolean bl, WhitespacesAndCommentsBinder.TokenTextGetter tokenTextGetter) {
        IElementType last = (IElementType)tokens.get(tokens.size() - 1);
        IElementType prev = (IElementType)tokens.get(tokens.size() - 2);
        return last == JSTokenTypes.WHITE_SPACE && prev != JSTokenTypes.XML_TAG_END && prev != JSTokenTypes.XML_END_TAG_LIST && prev != JSTokenTypes.XML_EMPTY_TAG_END && !JSElementTypes.COMMENTS.contains(prev) ? 1 : 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/parsing/JSXmlTokensParser$Companion;", "", "<init>", "()V", "INCOMPLETE_TAG_WHITESPACE_BINDER", "Lcom/intellij/lang/WhitespacesAndCommentsBinder;", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

