/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.providers.resolve.SwEndpointTargetInfo;
import com.intellij.swagger.core.providers.resolve.SwTargetInfo;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BC\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010.\u001a\u00020\r2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\b\u00101\u001a\u000202H\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00063"}, d2={"Lcom/intellij/swagger/core/providers/resolve/SwTargetInfo;", "Type", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "modelElement", "schemes", "", "", "authorities", "Lcom/intellij/microservices/url/Authority;", "methods", "", "isRemote", "", "<init>", "(Lcom/intellij/swagger/core/model/api/SwModelElement;Ljava/util/List;Ljava/util/List;Ljava/util/Set;Z)V", "getModelElement", "()Lcom/intellij/swagger/core/model/api/SwModelElement;", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "getSchemes", "()Ljava/util/List;", "getAuthorities", "getMethods", "()Ljava/util/Set;", "()Z", "parameters", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/api/SwParameter;", "getParameters", "()Lkotlin/sequences/Sequence;", "model", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "getModel", "()Lcom/intellij/swagger/core/model/api/SwModelBase;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "source", "getSource", "()Ljava/lang/String;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "equals", "other", "", "hashCode", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwTargetInfo\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n*L\n1#1,185:1\n38#2,2:186\n*S KotlinDebug\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwTargetInfo\n*L\n90#1:186,2\n*E\n"})
public abstract class SwTargetInfo<Type extends SwModelElement>
implements UrlTargetInfo {
    @NotNull
    private final Type modelElement;
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final Set<String> methods;
    private final boolean isRemote;

    public SwTargetInfo(@NotNull Type modelElement, @NotNull List<String> schemes2, @NotNull List<? extends Authority> authorities2, @NotNull Set<String> methods, boolean isRemote) {
        Intrinsics.checkNotNullParameter(modelElement, (String)"modelElement");
        Intrinsics.checkNotNullParameter(schemes2, (String)"schemes");
        Intrinsics.checkNotNullParameter(authorities2, (String)"authorities");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        this.modelElement = modelElement;
        this.schemes = schemes2;
        this.authorities = authorities2;
        this.methods = methods;
        this.isRemote = isRemote;
    }

    public /* synthetic */ SwTargetInfo(SwModelElement swModelElement, List list, List list2, Set set, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(swModelElement, list, list2, set, bl);
    }

    @NotNull
    public final Type getModelElement() {
        return this.modelElement;
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public Set<String> getMethods() {
        return this.methods;
    }

    public final boolean isRemote() {
        return this.isRemote;
    }

    @NotNull
    public abstract Sequence<SwParameter> getParameters();

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final SwModelBase getModel() {
        void $this$iv;
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        Type swElement$iv = this.modelElement;
        boolean withSelf$iv = false;
        boolean $i$f$getParentOfType = false;
        return $this$iv.getParentOfType(swElement$iv.getSourcePsi(), SwModelBase.class, withSelf$iv);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SwaggerCoreIcons.Endpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Endpoint");
        return icon;
    }

    @NotNull
    public String getSource() {
        String string;
        if (this.isRemote) {
            Object object = CollectionsKt.firstOrNull(this.getAuthorities());
            Authority.Exact exact = object instanceof Authority.Exact ? (Authority.Exact)object : null;
            String authority = exact != null ? exact.getText() : null;
            SwModelBase swModelBase = this.getModel();
            List list = swModelBase != null ? swModelBase.getBasePaths() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return SwaggerUtilsKt.getEndpointLocation$default(authority, list, null, 4, null);
        }
        SwModelBase swModelBase = this.getModel();
        if ((swModelBase != null && (swModelBase = swModelBase.getSourcePsi()) != null && (swModelBase = swModelBase.getContainingFile()) != null ? swModelBase.getName() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.getParameters(), (Function1)((Function1)queryParameters.1.INSTANCE)), SwTargetInfo::_get_queryParameters_$lambda$0));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwEndpointTargetInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modelElement.getSourcePsi(), (Object)this.modelElement.getSourcePsi());
    }

    public int hashCode() {
        PsiElement psiElement = this.modelElement.getSourcePsi();
        return psiElement != null ? psiElement.hashCode() : 0;
    }

    private static final queryParameters.2.1 _get_queryParameters_$lambda$0(SwParameter param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return new UrlQueryParameter(param){
            final /* synthetic */ SwParameter $param;
            {
                this.$param = $param;
            }

            public String getName() {
                return this.$param.getParameterName().getValue();
            }

            public String getDescription() {
                return this.$param.getType().getValue();
            }

            public boolean getRepeatable() {
                return true;
            }

            public PsiElement resolveToPsiElement() {
                return this.$param.getSourcePsi();
            }
        };
    }
}

