/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessConnection;
import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.JavaeeProcessObjectListener;
import com.intellij.javaee.process.JavaeeProcessResponseToListener;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodInvocator;
import com.intellij.javaee.process.common.MethodParamDeserializer;
import com.intellij.javaee.process.common.MethodParamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaeeProcessListenerRegistry
implements AbstractResponseHandler<JavaeeProcessResponseToListener> {
    private static final Logger LOG = Logger.getInstance(JavaeeProcessListenerRegistry.class);
    private final Map<Integer, JavaeeProcessObjectListener> myId2Listener = new HashMap<Integer, JavaeeProcessObjectListener>();
    private final ClassLoader myListenersClassLoader;
    private int myNextId = 0;

    public JavaeeProcessListenerRegistry(JavaeeProcessConnection connection, ClassLoader listenersClassLoader) {
        this.myListenersClassLoader = listenersClassLoader;
        connection.getSocketConnection().registerHandler(JavaeeProcessResponseToListener.class, (AbstractResponseHandler)this);
    }

    public void processResponse(@NotNull JavaeeProcessResponseToListener response) {
        if (response == null) {
            JavaeeProcessListenerRegistry.$$$reportNull$$$0(0);
        }
        try {
            MethodInvocator.invoke(this.myListenersClassLoader.loadClass(response.getListenerClassName()), (JavaeeProcessObject)((JavaeeProcessObject)this.myId2Listener.get(response.getListenerObjectId())), (String)response.getListenerMethodName(), (MethodParamProvider)response.getParamProvider(), (MethodParamDeserializer)new MethodParamDeserializer());
        }
        catch (JavaeeProcessUtilException | ClassNotFoundException e) {
            LOG.error(e);
        }
    }

    public int registerListener(JavaeeProcessObjectListener listener) {
        int result = this.myNextId++;
        this.myId2Listener.put(result, listener);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/intellij/javaee/process/JavaeeProcessListenerRegistry", "processResponse"));
    }
}

