/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private final Map<String, Entry> map = new HashMap<String, Entry>();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
    }

    public void reset() {
        this.map.clear();
    }

    public void endDocument() throws SAXException {
        for (String string : this.map.keySet()) {
            Entry entry = this.map.get(string);
            if (entry.hadId) continue;
            for (LocatorImpl locatorImpl : entry.idrefLocs) {
                this.error("missing_id", string, locatorImpl);
            }
        }
    }

    public void attribute(Name name, Name name2, String string, Locator locator) throws SAXException {
        int n = this.idTypeMap.getIdType(name, name2);
        if (n != 0) {
            String[] stringArray = StringSplitter.split(string);
            switch (n) {
                case 1: {
                    if (stringArray.length == 1) {
                        this.id(stringArray[0], locator);
                        break;
                    }
                    if (stringArray.length == 0) {
                        this.error("id_no_tokens", locator);
                        break;
                    }
                    this.error("id_multiple_tokens", locator);
                    break;
                }
                case 2: {
                    if (stringArray.length == 1) {
                        this.idref(stringArray[0], locator);
                        break;
                    }
                    if (stringArray.length == 0) {
                        this.error("idref_no_tokens", locator);
                        break;
                    }
                    this.error("idref_multiple_tokens", locator);
                    break;
                }
                case 3: {
                    if (stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.idref(stringArray[i], locator);
                        }
                        break;
                    }
                    this.error("idrefs_no_tokens", locator);
                }
            }
        }
    }

    private void id(String string, Locator locator) throws SAXException {
        Entry entry = this.map.get(string);
        if (entry == null) {
            entry = new Entry();
            this.map.put(string, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", string, locator);
            this.error("first_id", string, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(locator);
        entry.hadId = true;
    }

    private void idref(String string, Locator locator) {
        Entry entry = this.map.get(string);
        if (entry == null) {
            entry = new Entry();
            this.map.put(string, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new ArrayList<LocatorImpl>();
        }
        entry.idrefLocs.add(new LocatorImpl(locator));
    }

    private void error(String string, Locator locator) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), locator));
    }

    private void error(String string, String string2, Locator locator) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), locator));
    }

    private static class Entry {
        Locator idLoc;
        List<LocatorImpl> idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

