abi <abi/5.0>,

profile "test-mount-tmpfs-rw" flags=(attach_disconnected,mediate_deleted) {
  # See parser/mount.cc for implementation details.
  #
  # Note that on newer kernels, e.g. on Debian 13, with new-enough libmount,
  # this will be a sequence of fsopen, mount_setattr, fsconfig, fsmount,
  # mount_setattr and mount_move.  As such we need to allow the move flag for
  # the final operation and we need to allow the source of the move to be the
  # empty string. The following strace log illustrates the details:
  #
  # fsopen("tmpfs", FSOPEN_CLOEXEC)         = 3
  # mount_setattr(-1, NULL, 0, NULL, 0)     = -1 EINVAL (Invalid argument)
  # fsconfig(3, FSCONFIG_SET_STRING, "source", "none", 0) = 0
  # fsconfig(3, FSCONFIG_SET_FLAG, "rw", NULL, 0) = 0
  # fsconfig(3, FSCONFIG_CMD_CREATE, NULL, NULL, 0) = 0
  # fsmount(3, FSMOUNT_CLOEXEC, 0)          = 4
  # statx(4, "", AT_STATX_SYNC_AS_STAT|AT_EMPTY_PATH, STATX_MNT_ID, {stx_mask=STATX_BASIC_STATS|STATX_MNT_ID, stx_attributes=STATX_ATTR_MOUNT_ROOT, stx_mode=S_IFDIR|S_ISVTX|0777, stx_size=40, ...}) = 0
  # mount_setattr(4, "", AT_EMPTY_PATH, {attr_set=0, attr_clr=MOUNT_ATTR_RDONLY, propagation=0 /* MS_??? */, userns_fd=0}, 32) = 0
  # move_mount(4, "", AT_FDCWD, "/tmp/dir", MOVE_MOUNT_F_EMPTY_PATH) = 0
  # close(3)                                = 0
  # close(4)                                = 0
  mount fstype=tmpfs options=(rw) none -> /tmp/**,
  mount options=(rw, move) -> /tmp/**,

  capability sys_admin,

  # Remaining permissions required to run mount. We are _not_ using any
  # abstractions to avoid getting confused by what is really needed. This
  # approach helps both in understanding the test and in helping shape mount
  # profiles generated by snapd.
  /etc/ld.so.cache r,
  /etc/locale.alias r,
  /usr/share/locale/locale.alias r,
  /proc/*/mountinfo r,
  /proc/*/mounts r,
  /proc/filesystems r,
  /run/mount/utab r,
  /usr/lib{64,/*-linux-gnu}/gconv/gconv-modules.cache r,
  /usr/lib64/gconv/gconv-modules r,
  /usr/lib64/gconv/gconv-modules.d/ r,
  /usr/lib{64,/*-linux-gnu}/libblkid.so.* rm,
  /usr/lib{64,/*-linux-gnu}/libc.so.* rm,
  /usr/lib{64,/*-linux-gnu}/libmount.so.* rm,
  /usr/lib{64,/*-linux-gnu}/libpcre2-*.so.* rm,
  /usr/lib{64,/*-linux-gnu}/libselinux.so.* rm,
  /usr/lib{64,/*-linux-gnu}/libeconf.so.* rm,
  /usr/lib/locale/*/LC_ADDRESS r,
  /usr/lib/locale/*/LC_COLLATE r,
  /usr/lib/locale/*/LC_CTYPE r,
  /usr/lib/locale/*/LC_IDENTIFICATION r,
  /usr/lib/locale/*/LC_MEASUREMENT r,
  /usr/lib/locale/*/LC_MESSAGES/ r,
  /usr/lib/locale/*/LC_MESSAGES/SYS_LC_MESSAGES r,
  /usr/lib/locale/*/LC_MONETARY r,
  /usr/lib/locale/*/LC_NAME r,
  /usr/lib/locale/*/LC_NUMERIC r,
  /usr/lib/locale/*/LC_PAPER r,
  /usr/lib/locale/*/LC_TELEPHONE r,
  /usr/lib/locale/*/LC_TIME r,
  /usr/lib/locale/locale-archive r,
}
