// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![cfg(unix)]

use gstreamer_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gstreamer-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GstAllocationParams",
        Layout {
            size: size_of::<GstAllocationParams>(),
            alignment: align_of::<GstAllocationParams>(),
        },
    ),
    (
        "GstAllocator",
        Layout {
            size: size_of::<GstAllocator>(),
            alignment: align_of::<GstAllocator>(),
        },
    ),
    (
        "GstAllocatorClass",
        Layout {
            size: size_of::<GstAllocatorClass>(),
            alignment: align_of::<GstAllocatorClass>(),
        },
    ),
    (
        "GstAllocatorFlags",
        Layout {
            size: size_of::<GstAllocatorFlags>(),
            alignment: align_of::<GstAllocatorFlags>(),
        },
    ),
    (
        "GstBin",
        Layout {
            size: size_of::<GstBin>(),
            alignment: align_of::<GstBin>(),
        },
    ),
    (
        "GstBinClass",
        Layout {
            size: size_of::<GstBinClass>(),
            alignment: align_of::<GstBinClass>(),
        },
    ),
    (
        "GstBinFlags",
        Layout {
            size: size_of::<GstBinFlags>(),
            alignment: align_of::<GstBinFlags>(),
        },
    ),
    (
        "GstBuffer",
        Layout {
            size: size_of::<GstBuffer>(),
            alignment: align_of::<GstBuffer>(),
        },
    ),
    (
        "GstBufferCopyFlags",
        Layout {
            size: size_of::<GstBufferCopyFlags>(),
            alignment: align_of::<GstBufferCopyFlags>(),
        },
    ),
    (
        "GstBufferFlags",
        Layout {
            size: size_of::<GstBufferFlags>(),
            alignment: align_of::<GstBufferFlags>(),
        },
    ),
    (
        "GstBufferMapInfo",
        Layout {
            size: size_of::<GstBufferMapInfo>(),
            alignment: align_of::<GstBufferMapInfo>(),
        },
    ),
    (
        "GstBufferPool",
        Layout {
            size: size_of::<GstBufferPool>(),
            alignment: align_of::<GstBufferPool>(),
        },
    ),
    (
        "GstBufferPoolAcquireFlags",
        Layout {
            size: size_of::<GstBufferPoolAcquireFlags>(),
            alignment: align_of::<GstBufferPoolAcquireFlags>(),
        },
    ),
    (
        "GstBufferPoolAcquireParams",
        Layout {
            size: size_of::<GstBufferPoolAcquireParams>(),
            alignment: align_of::<GstBufferPoolAcquireParams>(),
        },
    ),
    (
        "GstBufferPoolClass",
        Layout {
            size: size_of::<GstBufferPoolClass>(),
            alignment: align_of::<GstBufferPoolClass>(),
        },
    ),
    (
        "GstBufferingMode",
        Layout {
            size: size_of::<GstBufferingMode>(),
            alignment: align_of::<GstBufferingMode>(),
        },
    ),
    (
        "GstBus",
        Layout {
            size: size_of::<GstBus>(),
            alignment: align_of::<GstBus>(),
        },
    ),
    (
        "GstBusClass",
        Layout {
            size: size_of::<GstBusClass>(),
            alignment: align_of::<GstBusClass>(),
        },
    ),
    (
        "GstBusFlags",
        Layout {
            size: size_of::<GstBusFlags>(),
            alignment: align_of::<GstBusFlags>(),
        },
    ),
    (
        "GstBusSyncReply",
        Layout {
            size: size_of::<GstBusSyncReply>(),
            alignment: align_of::<GstBusSyncReply>(),
        },
    ),
    (
        "GstByteArrayInterface",
        Layout {
            size: size_of::<GstByteArrayInterface>(),
            alignment: align_of::<GstByteArrayInterface>(),
        },
    ),
    (
        "GstCaps",
        Layout {
            size: size_of::<GstCaps>(),
            alignment: align_of::<GstCaps>(),
        },
    ),
    (
        "GstCapsFlags",
        Layout {
            size: size_of::<GstCapsFlags>(),
            alignment: align_of::<GstCapsFlags>(),
        },
    ),
    (
        "GstCapsIntersectMode",
        Layout {
            size: size_of::<GstCapsIntersectMode>(),
            alignment: align_of::<GstCapsIntersectMode>(),
        },
    ),
    (
        "GstChildProxyInterface",
        Layout {
            size: size_of::<GstChildProxyInterface>(),
            alignment: align_of::<GstChildProxyInterface>(),
        },
    ),
    (
        "GstClock",
        Layout {
            size: size_of::<GstClock>(),
            alignment: align_of::<GstClock>(),
        },
    ),
    (
        "GstClockClass",
        Layout {
            size: size_of::<GstClockClass>(),
            alignment: align_of::<GstClockClass>(),
        },
    ),
    (
        "GstClockEntry",
        Layout {
            size: size_of::<GstClockEntry>(),
            alignment: align_of::<GstClockEntry>(),
        },
    ),
    (
        "GstClockEntryType",
        Layout {
            size: size_of::<GstClockEntryType>(),
            alignment: align_of::<GstClockEntryType>(),
        },
    ),
    (
        "GstClockFlags",
        Layout {
            size: size_of::<GstClockFlags>(),
            alignment: align_of::<GstClockFlags>(),
        },
    ),
    (
        "GstClockID",
        Layout {
            size: size_of::<GstClockID>(),
            alignment: align_of::<GstClockID>(),
        },
    ),
    (
        "GstClockReturn",
        Layout {
            size: size_of::<GstClockReturn>(),
            alignment: align_of::<GstClockReturn>(),
        },
    ),
    (
        "GstClockTime",
        Layout {
            size: size_of::<GstClockTime>(),
            alignment: align_of::<GstClockTime>(),
        },
    ),
    (
        "GstClockTimeDiff",
        Layout {
            size: size_of::<GstClockTimeDiff>(),
            alignment: align_of::<GstClockTimeDiff>(),
        },
    ),
    (
        "GstClockType",
        Layout {
            size: size_of::<GstClockType>(),
            alignment: align_of::<GstClockType>(),
        },
    ),
    (
        "GstControlBinding",
        Layout {
            size: size_of::<GstControlBinding>(),
            alignment: align_of::<GstControlBinding>(),
        },
    ),
    (
        "GstControlBindingClass",
        Layout {
            size: size_of::<GstControlBindingClass>(),
            alignment: align_of::<GstControlBindingClass>(),
        },
    ),
    (
        "GstControlSource",
        Layout {
            size: size_of::<GstControlSource>(),
            alignment: align_of::<GstControlSource>(),
        },
    ),
    (
        "GstControlSourceClass",
        Layout {
            size: size_of::<GstControlSourceClass>(),
            alignment: align_of::<GstControlSourceClass>(),
        },
    ),
    (
        "GstCoreError",
        Layout {
            size: size_of::<GstCoreError>(),
            alignment: align_of::<GstCoreError>(),
        },
    ),
    (
        "GstCustomMeta",
        Layout {
            size: size_of::<GstCustomMeta>(),
            alignment: align_of::<GstCustomMeta>(),
        },
    ),
    (
        "GstDebugCategory",
        Layout {
            size: size_of::<GstDebugCategory>(),
            alignment: align_of::<GstDebugCategory>(),
        },
    ),
    (
        "GstDebugColorFlags",
        Layout {
            size: size_of::<GstDebugColorFlags>(),
            alignment: align_of::<GstDebugColorFlags>(),
        },
    ),
    (
        "GstDebugColorMode",
        Layout {
            size: size_of::<GstDebugColorMode>(),
            alignment: align_of::<GstDebugColorMode>(),
        },
    ),
    (
        "GstDebugGraphDetails",
        Layout {
            size: size_of::<GstDebugGraphDetails>(),
            alignment: align_of::<GstDebugGraphDetails>(),
        },
    ),
    (
        "GstDebugLevel",
        Layout {
            size: size_of::<GstDebugLevel>(),
            alignment: align_of::<GstDebugLevel>(),
        },
    ),
    (
        "GstDevice",
        Layout {
            size: size_of::<GstDevice>(),
            alignment: align_of::<GstDevice>(),
        },
    ),
    (
        "GstDeviceClass",
        Layout {
            size: size_of::<GstDeviceClass>(),
            alignment: align_of::<GstDeviceClass>(),
        },
    ),
    (
        "GstDeviceMonitor",
        Layout {
            size: size_of::<GstDeviceMonitor>(),
            alignment: align_of::<GstDeviceMonitor>(),
        },
    ),
    (
        "GstDeviceMonitorClass",
        Layout {
            size: size_of::<GstDeviceMonitorClass>(),
            alignment: align_of::<GstDeviceMonitorClass>(),
        },
    ),
    (
        "GstDeviceProvider",
        Layout {
            size: size_of::<GstDeviceProvider>(),
            alignment: align_of::<GstDeviceProvider>(),
        },
    ),
    (
        "GstDeviceProviderClass",
        Layout {
            size: size_of::<GstDeviceProviderClass>(),
            alignment: align_of::<GstDeviceProviderClass>(),
        },
    ),
    (
        "GstElement",
        Layout {
            size: size_of::<GstElement>(),
            alignment: align_of::<GstElement>(),
        },
    ),
    (
        "GstElementClass",
        Layout {
            size: size_of::<GstElementClass>(),
            alignment: align_of::<GstElementClass>(),
        },
    ),
    (
        "GstElementFactoryListType",
        Layout {
            size: size_of::<GstElementFactoryListType>(),
            alignment: align_of::<GstElementFactoryListType>(),
        },
    ),
    (
        "GstElementFlags",
        Layout {
            size: size_of::<GstElementFlags>(),
            alignment: align_of::<GstElementFlags>(),
        },
    ),
    (
        "GstEvent",
        Layout {
            size: size_of::<GstEvent>(),
            alignment: align_of::<GstEvent>(),
        },
    ),
    (
        "GstEventType",
        Layout {
            size: size_of::<GstEventType>(),
            alignment: align_of::<GstEventType>(),
        },
    ),
    (
        "GstEventTypeFlags",
        Layout {
            size: size_of::<GstEventTypeFlags>(),
            alignment: align_of::<GstEventTypeFlags>(),
        },
    ),
    (
        "GstFlowReturn",
        Layout {
            size: size_of::<GstFlowReturn>(),
            alignment: align_of::<GstFlowReturn>(),
        },
    ),
    (
        "GstFormat",
        Layout {
            size: size_of::<GstFormat>(),
            alignment: align_of::<GstFormat>(),
        },
    ),
    (
        "GstFormatDefinition",
        Layout {
            size: size_of::<GstFormatDefinition>(),
            alignment: align_of::<GstFormatDefinition>(),
        },
    ),
    (
        "GstGapFlags",
        Layout {
            size: size_of::<GstGapFlags>(),
            alignment: align_of::<GstGapFlags>(),
        },
    ),
    (
        "GstGhostPad",
        Layout {
            size: size_of::<GstGhostPad>(),
            alignment: align_of::<GstGhostPad>(),
        },
    ),
    (
        "GstGhostPadClass",
        Layout {
            size: size_of::<GstGhostPadClass>(),
            alignment: align_of::<GstGhostPadClass>(),
        },
    ),
    (
        "GstIdStr",
        Layout {
            size: size_of::<GstIdStr>(),
            alignment: align_of::<GstIdStr>(),
        },
    ),
    (
        "GstIterator",
        Layout {
            size: size_of::<GstIterator>(),
            alignment: align_of::<GstIterator>(),
        },
    ),
    (
        "GstIteratorItem",
        Layout {
            size: size_of::<GstIteratorItem>(),
            alignment: align_of::<GstIteratorItem>(),
        },
    ),
    (
        "GstIteratorResult",
        Layout {
            size: size_of::<GstIteratorResult>(),
            alignment: align_of::<GstIteratorResult>(),
        },
    ),
    (
        "GstLibraryError",
        Layout {
            size: size_of::<GstLibraryError>(),
            alignment: align_of::<GstLibraryError>(),
        },
    ),
    (
        "GstLockFlags",
        Layout {
            size: size_of::<GstLockFlags>(),
            alignment: align_of::<GstLockFlags>(),
        },
    ),
    (
        "GstLogContextFlags",
        Layout {
            size: size_of::<GstLogContextFlags>(),
            alignment: align_of::<GstLogContextFlags>(),
        },
    ),
    (
        "GstLogContextHashFlags",
        Layout {
            size: size_of::<GstLogContextHashFlags>(),
            alignment: align_of::<GstLogContextHashFlags>(),
        },
    ),
    (
        "GstMapFlags",
        Layout {
            size: size_of::<GstMapFlags>(),
            alignment: align_of::<GstMapFlags>(),
        },
    ),
    (
        "GstMapInfo",
        Layout {
            size: size_of::<GstMapInfo>(),
            alignment: align_of::<GstMapInfo>(),
        },
    ),
    (
        "GstMemory",
        Layout {
            size: size_of::<GstMemory>(),
            alignment: align_of::<GstMemory>(),
        },
    ),
    (
        "GstMemoryFlags",
        Layout {
            size: size_of::<GstMemoryFlags>(),
            alignment: align_of::<GstMemoryFlags>(),
        },
    ),
    (
        "GstMemoryMapInfo",
        Layout {
            size: size_of::<GstMemoryMapInfo>(),
            alignment: align_of::<GstMemoryMapInfo>(),
        },
    ),
    (
        "GstMessage",
        Layout {
            size: size_of::<GstMessage>(),
            alignment: align_of::<GstMessage>(),
        },
    ),
    (
        "GstMessageType",
        Layout {
            size: size_of::<GstMessageType>(),
            alignment: align_of::<GstMessageType>(),
        },
    ),
    (
        "GstMeta",
        Layout {
            size: size_of::<GstMeta>(),
            alignment: align_of::<GstMeta>(),
        },
    ),
    (
        "GstMetaFlags",
        Layout {
            size: size_of::<GstMetaFlags>(),
            alignment: align_of::<GstMetaFlags>(),
        },
    ),
    (
        "GstMetaInfo",
        Layout {
            size: size_of::<GstMetaInfo>(),
            alignment: align_of::<GstMetaInfo>(),
        },
    ),
    (
        "GstMetaTransformCopy",
        Layout {
            size: size_of::<GstMetaTransformCopy>(),
            alignment: align_of::<GstMetaTransformCopy>(),
        },
    ),
    (
        "GstMiniObject",
        Layout {
            size: size_of::<GstMiniObject>(),
            alignment: align_of::<GstMiniObject>(),
        },
    ),
    (
        "GstMiniObjectFlags",
        Layout {
            size: size_of::<GstMiniObjectFlags>(),
            alignment: align_of::<GstMiniObjectFlags>(),
        },
    ),
    (
        "GstObject",
        Layout {
            size: size_of::<GstObject>(),
            alignment: align_of::<GstObject>(),
        },
    ),
    (
        "GstObjectClass",
        Layout {
            size: size_of::<GstObjectClass>(),
            alignment: align_of::<GstObjectClass>(),
        },
    ),
    (
        "GstObjectFlags",
        Layout {
            size: size_of::<GstObjectFlags>(),
            alignment: align_of::<GstObjectFlags>(),
        },
    ),
    (
        "GstPad",
        Layout {
            size: size_of::<GstPad>(),
            alignment: align_of::<GstPad>(),
        },
    ),
    (
        "GstPadClass",
        Layout {
            size: size_of::<GstPadClass>(),
            alignment: align_of::<GstPadClass>(),
        },
    ),
    (
        "GstPadDirection",
        Layout {
            size: size_of::<GstPadDirection>(),
            alignment: align_of::<GstPadDirection>(),
        },
    ),
    (
        "GstPadFlags",
        Layout {
            size: size_of::<GstPadFlags>(),
            alignment: align_of::<GstPadFlags>(),
        },
    ),
    (
        "GstPadLinkCheck",
        Layout {
            size: size_of::<GstPadLinkCheck>(),
            alignment: align_of::<GstPadLinkCheck>(),
        },
    ),
    (
        "GstPadLinkReturn",
        Layout {
            size: size_of::<GstPadLinkReturn>(),
            alignment: align_of::<GstPadLinkReturn>(),
        },
    ),
    (
        "GstPadMode",
        Layout {
            size: size_of::<GstPadMode>(),
            alignment: align_of::<GstPadMode>(),
        },
    ),
    (
        "GstPadPresence",
        Layout {
            size: size_of::<GstPadPresence>(),
            alignment: align_of::<GstPadPresence>(),
        },
    ),
    (
        "GstPadProbeInfo",
        Layout {
            size: size_of::<GstPadProbeInfo>(),
            alignment: align_of::<GstPadProbeInfo>(),
        },
    ),
    (
        "GstPadProbeReturn",
        Layout {
            size: size_of::<GstPadProbeReturn>(),
            alignment: align_of::<GstPadProbeReturn>(),
        },
    ),
    (
        "GstPadProbeType",
        Layout {
            size: size_of::<GstPadProbeType>(),
            alignment: align_of::<GstPadProbeType>(),
        },
    ),
    (
        "GstPadTemplate",
        Layout {
            size: size_of::<GstPadTemplate>(),
            alignment: align_of::<GstPadTemplate>(),
        },
    ),
    (
        "GstPadTemplateClass",
        Layout {
            size: size_of::<GstPadTemplateClass>(),
            alignment: align_of::<GstPadTemplateClass>(),
        },
    ),
    (
        "GstPadTemplateFlags",
        Layout {
            size: size_of::<GstPadTemplateFlags>(),
            alignment: align_of::<GstPadTemplateFlags>(),
        },
    ),
    (
        "GstParamSpecArray",
        Layout {
            size: size_of::<GstParamSpecArray>(),
            alignment: align_of::<GstParamSpecArray>(),
        },
    ),
    (
        "GstParamSpecFraction",
        Layout {
            size: size_of::<GstParamSpecFraction>(),
            alignment: align_of::<GstParamSpecFraction>(),
        },
    ),
    (
        "GstParentBufferMeta",
        Layout {
            size: size_of::<GstParentBufferMeta>(),
            alignment: align_of::<GstParentBufferMeta>(),
        },
    ),
    (
        "GstParseError",
        Layout {
            size: size_of::<GstParseError>(),
            alignment: align_of::<GstParseError>(),
        },
    ),
    (
        "GstParseFlags",
        Layout {
            size: size_of::<GstParseFlags>(),
            alignment: align_of::<GstParseFlags>(),
        },
    ),
    (
        "GstPipeline",
        Layout {
            size: size_of::<GstPipeline>(),
            alignment: align_of::<GstPipeline>(),
        },
    ),
    (
        "GstPipelineClass",
        Layout {
            size: size_of::<GstPipelineClass>(),
            alignment: align_of::<GstPipelineClass>(),
        },
    ),
    (
        "GstPipelineFlags",
        Layout {
            size: size_of::<GstPipelineFlags>(),
            alignment: align_of::<GstPipelineFlags>(),
        },
    ),
    (
        "GstPluginAPIFlags",
        Layout {
            size: size_of::<GstPluginAPIFlags>(),
            alignment: align_of::<GstPluginAPIFlags>(),
        },
    ),
    (
        "GstPluginDependencyFlags",
        Layout {
            size: size_of::<GstPluginDependencyFlags>(),
            alignment: align_of::<GstPluginDependencyFlags>(),
        },
    ),
    (
        "GstPluginDesc",
        Layout {
            size: size_of::<GstPluginDesc>(),
            alignment: align_of::<GstPluginDesc>(),
        },
    ),
    (
        "GstPluginError",
        Layout {
            size: size_of::<GstPluginError>(),
            alignment: align_of::<GstPluginError>(),
        },
    ),
    (
        "GstPluginFlags",
        Layout {
            size: size_of::<GstPluginFlags>(),
            alignment: align_of::<GstPluginFlags>(),
        },
    ),
    (
        "GstPollFD",
        Layout {
            size: size_of::<GstPollFD>(),
            alignment: align_of::<GstPollFD>(),
        },
    ),
    (
        "GstPresetInterface",
        Layout {
            size: size_of::<GstPresetInterface>(),
            alignment: align_of::<GstPresetInterface>(),
        },
    ),
    (
        "GstProgressType",
        Layout {
            size: size_of::<GstProgressType>(),
            alignment: align_of::<GstProgressType>(),
        },
    ),
    (
        "GstPromise",
        Layout {
            size: size_of::<GstPromise>(),
            alignment: align_of::<GstPromise>(),
        },
    ),
    (
        "GstPromiseResult",
        Layout {
            size: size_of::<GstPromiseResult>(),
            alignment: align_of::<GstPromiseResult>(),
        },
    ),
    (
        "GstProtectionMeta",
        Layout {
            size: size_of::<GstProtectionMeta>(),
            alignment: align_of::<GstProtectionMeta>(),
        },
    ),
    (
        "GstProxyPad",
        Layout {
            size: size_of::<GstProxyPad>(),
            alignment: align_of::<GstProxyPad>(),
        },
    ),
    (
        "GstProxyPadClass",
        Layout {
            size: size_of::<GstProxyPadClass>(),
            alignment: align_of::<GstProxyPadClass>(),
        },
    ),
    (
        "GstQOSType",
        Layout {
            size: size_of::<GstQOSType>(),
            alignment: align_of::<GstQOSType>(),
        },
    ),
    (
        "GstQuery",
        Layout {
            size: size_of::<GstQuery>(),
            alignment: align_of::<GstQuery>(),
        },
    ),
    (
        "GstQueryType",
        Layout {
            size: size_of::<GstQueryType>(),
            alignment: align_of::<GstQueryType>(),
        },
    ),
    (
        "GstQueryTypeFlags",
        Layout {
            size: size_of::<GstQueryTypeFlags>(),
            alignment: align_of::<GstQueryTypeFlags>(),
        },
    ),
    (
        "GstRank",
        Layout {
            size: size_of::<GstRank>(),
            alignment: align_of::<GstRank>(),
        },
    ),
    (
        "GstReferenceTimestampMeta",
        Layout {
            size: size_of::<GstReferenceTimestampMeta>(),
            alignment: align_of::<GstReferenceTimestampMeta>(),
        },
    ),
    (
        "GstRegistry",
        Layout {
            size: size_of::<GstRegistry>(),
            alignment: align_of::<GstRegistry>(),
        },
    ),
    (
        "GstRegistryClass",
        Layout {
            size: size_of::<GstRegistryClass>(),
            alignment: align_of::<GstRegistryClass>(),
        },
    ),
    (
        "GstResourceError",
        Layout {
            size: size_of::<GstResourceError>(),
            alignment: align_of::<GstResourceError>(),
        },
    ),
    (
        "GstSchedulingFlags",
        Layout {
            size: size_of::<GstSchedulingFlags>(),
            alignment: align_of::<GstSchedulingFlags>(),
        },
    ),
    (
        "GstSearchMode",
        Layout {
            size: size_of::<GstSearchMode>(),
            alignment: align_of::<GstSearchMode>(),
        },
    ),
    (
        "GstSeekFlags",
        Layout {
            size: size_of::<GstSeekFlags>(),
            alignment: align_of::<GstSeekFlags>(),
        },
    ),
    (
        "GstSeekType",
        Layout {
            size: size_of::<GstSeekType>(),
            alignment: align_of::<GstSeekType>(),
        },
    ),
    (
        "GstSegment",
        Layout {
            size: size_of::<GstSegment>(),
            alignment: align_of::<GstSegment>(),
        },
    ),
    (
        "GstSegmentFlags",
        Layout {
            size: size_of::<GstSegmentFlags>(),
            alignment: align_of::<GstSegmentFlags>(),
        },
    ),
    (
        "GstSerializeFlags",
        Layout {
            size: size_of::<GstSerializeFlags>(),
            alignment: align_of::<GstSerializeFlags>(),
        },
    ),
    (
        "GstSharedTaskPool",
        Layout {
            size: size_of::<GstSharedTaskPool>(),
            alignment: align_of::<GstSharedTaskPool>(),
        },
    ),
    (
        "GstSharedTaskPoolClass",
        Layout {
            size: size_of::<GstSharedTaskPoolClass>(),
            alignment: align_of::<GstSharedTaskPoolClass>(),
        },
    ),
    (
        "GstStackTraceFlags",
        Layout {
            size: size_of::<GstStackTraceFlags>(),
            alignment: align_of::<GstStackTraceFlags>(),
        },
    ),
    (
        "GstState",
        Layout {
            size: size_of::<GstState>(),
            alignment: align_of::<GstState>(),
        },
    ),
    (
        "GstStateChange",
        Layout {
            size: size_of::<GstStateChange>(),
            alignment: align_of::<GstStateChange>(),
        },
    ),
    (
        "GstStateChangeReturn",
        Layout {
            size: size_of::<GstStateChangeReturn>(),
            alignment: align_of::<GstStateChangeReturn>(),
        },
    ),
    (
        "GstStaticCaps",
        Layout {
            size: size_of::<GstStaticCaps>(),
            alignment: align_of::<GstStaticCaps>(),
        },
    ),
    (
        "GstStaticPadTemplate",
        Layout {
            size: size_of::<GstStaticPadTemplate>(),
            alignment: align_of::<GstStaticPadTemplate>(),
        },
    ),
    (
        "GstStream",
        Layout {
            size: size_of::<GstStream>(),
            alignment: align_of::<GstStream>(),
        },
    ),
    (
        "GstStreamClass",
        Layout {
            size: size_of::<GstStreamClass>(),
            alignment: align_of::<GstStreamClass>(),
        },
    ),
    (
        "GstStreamCollection",
        Layout {
            size: size_of::<GstStreamCollection>(),
            alignment: align_of::<GstStreamCollection>(),
        },
    ),
    (
        "GstStreamCollectionClass",
        Layout {
            size: size_of::<GstStreamCollectionClass>(),
            alignment: align_of::<GstStreamCollectionClass>(),
        },
    ),
    (
        "GstStreamError",
        Layout {
            size: size_of::<GstStreamError>(),
            alignment: align_of::<GstStreamError>(),
        },
    ),
    (
        "GstStreamFlags",
        Layout {
            size: size_of::<GstStreamFlags>(),
            alignment: align_of::<GstStreamFlags>(),
        },
    ),
    (
        "GstStreamStatusType",
        Layout {
            size: size_of::<GstStreamStatusType>(),
            alignment: align_of::<GstStreamStatusType>(),
        },
    ),
    (
        "GstStreamType",
        Layout {
            size: size_of::<GstStreamType>(),
            alignment: align_of::<GstStreamType>(),
        },
    ),
    (
        "GstStructure",
        Layout {
            size: size_of::<GstStructure>(),
            alignment: align_of::<GstStructure>(),
        },
    ),
    (
        "GstStructureChangeType",
        Layout {
            size: size_of::<GstStructureChangeType>(),
            alignment: align_of::<GstStructureChangeType>(),
        },
    ),
    (
        "GstSystemClock",
        Layout {
            size: size_of::<GstSystemClock>(),
            alignment: align_of::<GstSystemClock>(),
        },
    ),
    (
        "GstSystemClockClass",
        Layout {
            size: size_of::<GstSystemClockClass>(),
            alignment: align_of::<GstSystemClockClass>(),
        },
    ),
    (
        "GstTagFlag",
        Layout {
            size: size_of::<GstTagFlag>(),
            alignment: align_of::<GstTagFlag>(),
        },
    ),
    (
        "GstTagList",
        Layout {
            size: size_of::<GstTagList>(),
            alignment: align_of::<GstTagList>(),
        },
    ),
    (
        "GstTagMergeMode",
        Layout {
            size: size_of::<GstTagMergeMode>(),
            alignment: align_of::<GstTagMergeMode>(),
        },
    ),
    (
        "GstTagScope",
        Layout {
            size: size_of::<GstTagScope>(),
            alignment: align_of::<GstTagScope>(),
        },
    ),
    (
        "GstTagSetterInterface",
        Layout {
            size: size_of::<GstTagSetterInterface>(),
            alignment: align_of::<GstTagSetterInterface>(),
        },
    ),
    (
        "GstTask",
        Layout {
            size: size_of::<GstTask>(),
            alignment: align_of::<GstTask>(),
        },
    ),
    (
        "GstTaskClass",
        Layout {
            size: size_of::<GstTaskClass>(),
            alignment: align_of::<GstTaskClass>(),
        },
    ),
    (
        "GstTaskPool",
        Layout {
            size: size_of::<GstTaskPool>(),
            alignment: align_of::<GstTaskPool>(),
        },
    ),
    (
        "GstTaskPoolClass",
        Layout {
            size: size_of::<GstTaskPoolClass>(),
            alignment: align_of::<GstTaskPoolClass>(),
        },
    ),
    (
        "GstTaskState",
        Layout {
            size: size_of::<GstTaskState>(),
            alignment: align_of::<GstTaskState>(),
        },
    ),
    (
        "GstTimedValue",
        Layout {
            size: size_of::<GstTimedValue>(),
            alignment: align_of::<GstTimedValue>(),
        },
    ),
    (
        "GstTocEntryType",
        Layout {
            size: size_of::<GstTocEntryType>(),
            alignment: align_of::<GstTocEntryType>(),
        },
    ),
    (
        "GstTocLoopType",
        Layout {
            size: size_of::<GstTocLoopType>(),
            alignment: align_of::<GstTocLoopType>(),
        },
    ),
    (
        "GstTocScope",
        Layout {
            size: size_of::<GstTocScope>(),
            alignment: align_of::<GstTocScope>(),
        },
    ),
    (
        "GstTocSetterInterface",
        Layout {
            size: size_of::<GstTocSetterInterface>(),
            alignment: align_of::<GstTocSetterInterface>(),
        },
    ),
    (
        "GstTracer",
        Layout {
            size: size_of::<GstTracer>(),
            alignment: align_of::<GstTracer>(),
        },
    ),
    (
        "GstTracerClass",
        Layout {
            size: size_of::<GstTracerClass>(),
            alignment: align_of::<GstTracerClass>(),
        },
    ),
    (
        "GstTracerValueFlags",
        Layout {
            size: size_of::<GstTracerValueFlags>(),
            alignment: align_of::<GstTracerValueFlags>(),
        },
    ),
    (
        "GstTracerValueScope",
        Layout {
            size: size_of::<GstTracerValueScope>(),
            alignment: align_of::<GstTracerValueScope>(),
        },
    ),
    (
        "GstTypeFind",
        Layout {
            size: size_of::<GstTypeFind>(),
            alignment: align_of::<GstTypeFind>(),
        },
    ),
    (
        "GstTypeFindProbability",
        Layout {
            size: size_of::<GstTypeFindProbability>(),
            alignment: align_of::<GstTypeFindProbability>(),
        },
    ),
    (
        "GstURIError",
        Layout {
            size: size_of::<GstURIError>(),
            alignment: align_of::<GstURIError>(),
        },
    ),
    (
        "GstURIHandlerInterface",
        Layout {
            size: size_of::<GstURIHandlerInterface>(),
            alignment: align_of::<GstURIHandlerInterface>(),
        },
    ),
    (
        "GstURIType",
        Layout {
            size: size_of::<GstURIType>(),
            alignment: align_of::<GstURIType>(),
        },
    ),
    (
        "GstValueTable",
        Layout {
            size: size_of::<GstValueTable>(),
            alignment: align_of::<GstValueTable>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(guint) GST_ALLOCATOR_FLAG_CUSTOM_ALLOC", "16"),
    ("(guint) GST_ALLOCATOR_FLAG_LAST", "1048576"),
    ("(guint) GST_ALLOCATOR_FLAG_NO_COPY", "32"),
    ("GST_ALLOCATOR_SYSMEM", "SystemMemory"),
    ("(guint) GST_BIN_FLAG_LAST", "524288"),
    ("(guint) GST_BIN_FLAG_NO_RESYNC", "16384"),
    ("(guint) GST_BIN_FLAG_STREAMS_AWARE", "32768"),
    ("(gint) GST_BUFFERING_DOWNLOAD", "1"),
    ("(gint) GST_BUFFERING_LIVE", "3"),
    ("(gint) GST_BUFFERING_STREAM", "0"),
    ("(gint) GST_BUFFERING_TIMESHIFT", "2"),
    ("GST_BUFFER_COPY_ALL", "15"),
    ("(guint) GST_BUFFER_COPY_DEEP", "32"),
    ("(guint) GST_BUFFER_COPY_FLAGS", "1"),
    ("(guint) GST_BUFFER_COPY_MEMORY", "8"),
    ("(guint) GST_BUFFER_COPY_MERGE", "16"),
    ("(guint) GST_BUFFER_COPY_META", "4"),
    ("GST_BUFFER_COPY_METADATA", "7"),
    ("(guint) GST_BUFFER_COPY_NONE", "0"),
    ("(guint) GST_BUFFER_COPY_TIMESTAMPS", "2"),
    ("(guint) GST_BUFFER_FLAG_CORRUPTED", "256"),
    ("(guint) GST_BUFFER_FLAG_DECODE_ONLY", "32"),
    ("(guint) GST_BUFFER_FLAG_DELTA_UNIT", "8192"),
    ("(guint) GST_BUFFER_FLAG_DISCONT", "64"),
    ("(guint) GST_BUFFER_FLAG_DROPPABLE", "4096"),
    ("(guint) GST_BUFFER_FLAG_GAP", "2048"),
    ("(guint) GST_BUFFER_FLAG_HEADER", "1024"),
    ("(guint) GST_BUFFER_FLAG_LAST", "1048576"),
    ("(guint) GST_BUFFER_FLAG_LIVE", "16"),
    ("(guint) GST_BUFFER_FLAG_MARKER", "512"),
    ("(guint) GST_BUFFER_FLAG_NON_DROPPABLE", "65536"),
    ("(guint) GST_BUFFER_FLAG_RESYNC", "128"),
    ("(guint) GST_BUFFER_FLAG_SYNC_AFTER", "32768"),
    ("(guint) GST_BUFFER_FLAG_TAG_MEMORY", "16384"),
    ("GST_BUFFER_OFFSET_NONE", "18446744073709551615"),
    ("(guint) GST_BUFFER_POOL_ACQUIRE_FLAG_DISCONT", "4"),
    ("(guint) GST_BUFFER_POOL_ACQUIRE_FLAG_DONTWAIT", "2"),
    ("(guint) GST_BUFFER_POOL_ACQUIRE_FLAG_KEY_UNIT", "1"),
    ("(guint) GST_BUFFER_POOL_ACQUIRE_FLAG_LAST", "65536"),
    ("(guint) GST_BUFFER_POOL_ACQUIRE_FLAG_NONE", "0"),
    ("(gint) GST_BUS_ASYNC", "2"),
    ("(gint) GST_BUS_DROP", "0"),
    ("(guint) GST_BUS_FLAG_LAST", "32"),
    ("(guint) GST_BUS_FLUSHING", "16"),
    ("(gint) GST_BUS_PASS", "1"),
    ("GST_CAN_INLINE", "1"),
    (
        "GST_CAPS_FEATURE_MEMORY_SYSTEM_MEMORY",
        "memory:SystemMemory",
    ),
    ("(guint) GST_CAPS_FLAG_ANY", "16"),
    ("(gint) GST_CAPS_INTERSECT_FIRST", "1"),
    ("(gint) GST_CAPS_INTERSECT_ZIG_ZAG", "0"),
    ("(gint) GST_CLOCK_BADTIME", "4"),
    ("(gint) GST_CLOCK_BUSY", "3"),
    ("(gint) GST_CLOCK_DONE", "7"),
    ("(gint) GST_CLOCK_EARLY", "1"),
    ("(gint) GST_CLOCK_ENTRY_PERIODIC", "1"),
    ("(gint) GST_CLOCK_ENTRY_SINGLE", "0"),
    ("(gint) GST_CLOCK_ERROR", "5"),
    ("(guint) GST_CLOCK_FLAG_CAN_DO_PERIODIC_ASYNC", "128"),
    ("(guint) GST_CLOCK_FLAG_CAN_DO_PERIODIC_SYNC", "64"),
    ("(guint) GST_CLOCK_FLAG_CAN_DO_SINGLE_ASYNC", "32"),
    ("(guint) GST_CLOCK_FLAG_CAN_DO_SINGLE_SYNC", "16"),
    ("(guint) GST_CLOCK_FLAG_CAN_SET_MASTER", "512"),
    ("(guint) GST_CLOCK_FLAG_CAN_SET_RESOLUTION", "256"),
    ("(guint) GST_CLOCK_FLAG_LAST", "4096"),
    ("(guint) GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC", "1024"),
    ("(gint) GST_CLOCK_OK", "0"),
    ("GST_CLOCK_TIME_NONE", "18446744073709551615"),
    ("(gint) GST_CLOCK_TYPE_MONOTONIC", "1"),
    ("(gint) GST_CLOCK_TYPE_OTHER", "2"),
    ("(gint) GST_CLOCK_TYPE_REALTIME", "0"),
    ("(gint) GST_CLOCK_TYPE_TAI", "3"),
    ("(gint) GST_CLOCK_UNSCHEDULED", "2"),
    ("(gint) GST_CLOCK_UNSUPPORTED", "6"),
    ("(gint) GST_CORE_ERROR_CAPS", "10"),
    ("(gint) GST_CORE_ERROR_CLOCK", "13"),
    ("(gint) GST_CORE_ERROR_DISABLED", "14"),
    ("(gint) GST_CORE_ERROR_EVENT", "8"),
    ("(gint) GST_CORE_ERROR_FAILED", "1"),
    ("(gint) GST_CORE_ERROR_MISSING_PLUGIN", "12"),
    ("(gint) GST_CORE_ERROR_NEGOTIATION", "7"),
    ("(gint) GST_CORE_ERROR_NOT_IMPLEMENTED", "3"),
    ("(gint) GST_CORE_ERROR_NUM_ERRORS", "15"),
    ("(gint) GST_CORE_ERROR_PAD", "5"),
    ("(gint) GST_CORE_ERROR_SEEK", "9"),
    ("(gint) GST_CORE_ERROR_STATE_CHANGE", "4"),
    ("(gint) GST_CORE_ERROR_TAG", "11"),
    ("(gint) GST_CORE_ERROR_THREAD", "6"),
    ("(gint) GST_CORE_ERROR_TOO_LAZY", "2"),
    ("(guint) GST_DEBUG_BG_BLACK", "0"),
    ("(guint) GST_DEBUG_BG_BLUE", "64"),
    ("(guint) GST_DEBUG_BG_CYAN", "96"),
    ("(guint) GST_DEBUG_BG_GREEN", "32"),
    ("(guint) GST_DEBUG_BG_MAGENTA", "80"),
    ("GST_DEBUG_BG_MASK", "240"),
    ("(guint) GST_DEBUG_BG_RED", "16"),
    ("(guint) GST_DEBUG_BG_WHITE", "112"),
    ("(guint) GST_DEBUG_BG_YELLOW", "48"),
    ("(guint) GST_DEBUG_BOLD", "256"),
    ("(gint) GST_DEBUG_COLOR_MODE_OFF", "0"),
    ("(gint) GST_DEBUG_COLOR_MODE_ON", "1"),
    ("(gint) GST_DEBUG_COLOR_MODE_UNIX", "2"),
    ("(guint) GST_DEBUG_FG_BLACK", "0"),
    ("(guint) GST_DEBUG_FG_BLUE", "4"),
    ("(guint) GST_DEBUG_FG_CYAN", "6"),
    ("(guint) GST_DEBUG_FG_GREEN", "2"),
    ("(guint) GST_DEBUG_FG_MAGENTA", "5"),
    ("GST_DEBUG_FG_MASK", "15"),
    ("(guint) GST_DEBUG_FG_RED", "1"),
    ("(guint) GST_DEBUG_FG_WHITE", "7"),
    ("(guint) GST_DEBUG_FG_YELLOW", "3"),
    ("GST_DEBUG_FORMAT_MASK", "65280"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_ALL", "15"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_CAPS_DETAILS", "2"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_FULL_PARAMS", "16"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_MEDIA_TYPE", "1"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_NON_DEFAULT_PARAMS", "4"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_STATES", "8"),
    ("(guint) GST_DEBUG_GRAPH_SHOW_VERBOSE", "4294967295"),
    ("(guint) GST_DEBUG_UNDERLINE", "512"),
    ("GST_ELEMENT_FACTORY_KLASS_DECODER", "Decoder"),
    ("GST_ELEMENT_FACTORY_KLASS_DECRYPTOR", "Decryptor"),
    ("GST_ELEMENT_FACTORY_KLASS_DEMUXER", "Demuxer"),
    ("GST_ELEMENT_FACTORY_KLASS_DEPAYLOADER", "Depayloader"),
    ("GST_ELEMENT_FACTORY_KLASS_ENCODER", "Encoder"),
    ("GST_ELEMENT_FACTORY_KLASS_ENCRYPTOR", "Encryptor"),
    ("GST_ELEMENT_FACTORY_KLASS_FORMATTER", "Formatter"),
    ("GST_ELEMENT_FACTORY_KLASS_HARDWARE", "Hardware"),
    ("GST_ELEMENT_FACTORY_KLASS_MEDIA_AUDIO", "Audio"),
    ("GST_ELEMENT_FACTORY_KLASS_MEDIA_IMAGE", "Image"),
    ("GST_ELEMENT_FACTORY_KLASS_MEDIA_METADATA", "Metadata"),
    ("GST_ELEMENT_FACTORY_KLASS_MEDIA_SUBTITLE", "Subtitle"),
    ("GST_ELEMENT_FACTORY_KLASS_MEDIA_VIDEO", "Video"),
    ("GST_ELEMENT_FACTORY_KLASS_MUXER", "Muxer"),
    ("GST_ELEMENT_FACTORY_KLASS_PARSER", "Parser"),
    ("GST_ELEMENT_FACTORY_KLASS_PAYLOADER", "Payloader"),
    ("GST_ELEMENT_FACTORY_KLASS_SINK", "Sink"),
    ("GST_ELEMENT_FACTORY_KLASS_SRC", "Source"),
    ("GST_ELEMENT_FACTORY_TYPE_ANY", "562949953421311"),
    (
        "GST_ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS",
        "3940649673949188",
    ),
    ("GST_ELEMENT_FACTORY_TYPE_AUDIO_ENCODER", "1125899906842626"),
    ("GST_ELEMENT_FACTORY_TYPE_DECODABLE", "1377"),
    ("GST_ELEMENT_FACTORY_TYPE_DECODER", "1"),
    ("GST_ELEMENT_FACTORY_TYPE_DECRYPTOR", "1024"),
    ("GST_ELEMENT_FACTORY_TYPE_DEMUXER", "32"),
    ("GST_ELEMENT_FACTORY_TYPE_DEPAYLOADER", "256"),
    ("GST_ELEMENT_FACTORY_TYPE_ENCODER", "2"),
    ("GST_ELEMENT_FACTORY_TYPE_ENCRYPTOR", "2048"),
    ("GST_ELEMENT_FACTORY_TYPE_FORMATTER", "512"),
    ("GST_ELEMENT_FACTORY_TYPE_HARDWARE", "4096"),
    ("GST_ELEMENT_FACTORY_TYPE_MAX_ELEMENTS", "281474976710656"),
    ("GST_ELEMENT_FACTORY_TYPE_MEDIA_ANY", "18446462598732840960"),
    ("GST_ELEMENT_FACTORY_TYPE_MEDIA_AUDIO", "1125899906842624"),
    ("GST_ELEMENT_FACTORY_TYPE_MEDIA_IMAGE", "2251799813685248"),
    (
        "GST_ELEMENT_FACTORY_TYPE_MEDIA_METADATA",
        "9007199254740992",
    ),
    (
        "GST_ELEMENT_FACTORY_TYPE_MEDIA_SUBTITLE",
        "4503599627370496",
    ),
    ("GST_ELEMENT_FACTORY_TYPE_MEDIA_VIDEO", "562949953421312"),
    ("GST_ELEMENT_FACTORY_TYPE_MUXER", "16"),
    ("GST_ELEMENT_FACTORY_TYPE_PARSER", "64"),
    ("GST_ELEMENT_FACTORY_TYPE_PAYLOADER", "128"),
    ("GST_ELEMENT_FACTORY_TYPE_SINK", "4"),
    ("GST_ELEMENT_FACTORY_TYPE_SRC", "8"),
    ("GST_ELEMENT_FACTORY_TYPE_TIMESTAMPER", "8192"),
    ("GST_ELEMENT_FACTORY_TYPE_VIDEO_ENCODER", "2814749767106562"),
    ("(guint) GST_ELEMENT_FLAG_INDEXABLE", "512"),
    ("(guint) GST_ELEMENT_FLAG_LAST", "16384"),
    ("(guint) GST_ELEMENT_FLAG_LOCKED_STATE", "16"),
    ("(guint) GST_ELEMENT_FLAG_PROVIDE_CLOCK", "128"),
    ("(guint) GST_ELEMENT_FLAG_REQUIRE_CLOCK", "256"),
    ("(guint) GST_ELEMENT_FLAG_SINK", "32"),
    ("(guint) GST_ELEMENT_FLAG_SOURCE", "64"),
    ("GST_ELEMENT_METADATA_AUTHOR", "author"),
    ("GST_ELEMENT_METADATA_DESCRIPTION", "description"),
    ("GST_ELEMENT_METADATA_DOC_URI", "doc-uri"),
    ("GST_ELEMENT_METADATA_ICON_NAME", "icon-name"),
    ("GST_ELEMENT_METADATA_KLASS", "klass"),
    ("GST_ELEMENT_METADATA_LONGNAME", "long-name"),
    ("(gint) GST_EVENT_BUFFERSIZE", "23054"),
    ("(gint) GST_EVENT_CAPS", "12814"),
    ("(gint) GST_EVENT_CUSTOM_BOTH", "79367"),
    ("(gint) GST_EVENT_CUSTOM_BOTH_OOB", "81923"),
    ("(gint) GST_EVENT_CUSTOM_DOWNSTREAM", "71686"),
    ("(gint) GST_EVENT_CUSTOM_DOWNSTREAM_OOB", "74242"),
    ("(gint) GST_EVENT_CUSTOM_DOWNSTREAM_STICKY", "76830"),
    ("(gint) GST_EVENT_CUSTOM_UPSTREAM", "69121"),
    ("(gint) GST_EVENT_EOS", "28174"),
    ("(gint) GST_EVENT_FLUSH_START", "2563"),
    ("(gint) GST_EVENT_FLUSH_STOP", "5127"),
    ("(gint) GST_EVENT_GAP", "40966"),
    ("(gint) GST_EVENT_INSTANT_RATE_CHANGE", "46090"),
    ("(gint) GST_EVENT_INSTANT_RATE_SYNC_TIME", "66817"),
    ("(gint) GST_EVENT_LATENCY", "56321"),
    ("(gint) GST_EVENT_NAVIGATION", "53761"),
    ("GST_EVENT_NUM_SHIFT", "8"),
    ("(gint) GST_EVENT_PROTECTION", "33310"),
    ("(gint) GST_EVENT_QOS", "48641"),
    ("(gint) GST_EVENT_RECONFIGURE", "61441"),
    ("(gint) GST_EVENT_SEEK", "51201"),
    ("(gint) GST_EVENT_SEGMENT", "17934"),
    ("(gint) GST_EVENT_SEGMENT_DONE", "38406"),
    ("(gint) GST_EVENT_SELECT_STREAMS", "66561"),
    ("(gint) GST_EVENT_SINK_MESSAGE", "25630"),
    ("(gint) GST_EVENT_STEP", "58881"),
    ("(gint) GST_EVENT_STREAM_COLLECTION", "19230"),
    ("(gint) GST_EVENT_STREAM_GROUP_DONE", "26894"),
    ("(gint) GST_EVENT_STREAM_START", "10254"),
    ("(gint) GST_EVENT_TAG", "20510"),
    ("(gint) GST_EVENT_TOC", "30750"),
    ("(gint) GST_EVENT_TOC_SELECT", "64001"),
    ("GST_EVENT_TYPE_BOTH", "3"),
    ("(guint) GST_EVENT_TYPE_DOWNSTREAM", "2"),
    ("(guint) GST_EVENT_TYPE_SERIALIZED", "4"),
    ("(guint) GST_EVENT_TYPE_STICKY", "8"),
    ("(guint) GST_EVENT_TYPE_STICKY_MULTI", "16"),
    ("(guint) GST_EVENT_TYPE_UPSTREAM", "1"),
    ("(gint) GST_EVENT_UNKNOWN", "0"),
    ("GST_FLAG_SET_MASK_EXACT", "4294967295"),
    ("(gint) GST_FLOW_CUSTOM_ERROR", "-100"),
    ("(gint) GST_FLOW_CUSTOM_ERROR_1", "-101"),
    ("(gint) GST_FLOW_CUSTOM_ERROR_2", "-102"),
    ("(gint) GST_FLOW_CUSTOM_SUCCESS", "100"),
    ("(gint) GST_FLOW_CUSTOM_SUCCESS_1", "101"),
    ("(gint) GST_FLOW_CUSTOM_SUCCESS_2", "102"),
    ("(gint) GST_FLOW_EOS", "-3"),
    ("(gint) GST_FLOW_ERROR", "-5"),
    ("(gint) GST_FLOW_FLUSHING", "-2"),
    ("(gint) GST_FLOW_NOT_LINKED", "-1"),
    ("(gint) GST_FLOW_NOT_NEGOTIATED", "-4"),
    ("(gint) GST_FLOW_NOT_SUPPORTED", "-6"),
    ("(gint) GST_FLOW_OK", "0"),
    ("(gint) GST_FORMAT_BUFFERS", "4"),
    ("(gint) GST_FORMAT_BYTES", "2"),
    ("(gint) GST_FORMAT_DEFAULT", "1"),
    ("(gint) GST_FORMAT_PERCENT", "5"),
    ("GST_FORMAT_PERCENT_MAX", "1000000"),
    ("GST_FORMAT_PERCENT_SCALE", "10000"),
    ("(gint) GST_FORMAT_TIME", "3"),
    ("(gint) GST_FORMAT_UNDEFINED", "0"),
    ("(guint) GST_GAP_FLAG_MISSING_DATA", "1"),
    ("GST_GROUP_ID_INVALID", "0"),
    ("(gint) GST_ITERATOR_DONE", "0"),
    ("(gint) GST_ITERATOR_ERROR", "3"),
    ("(gint) GST_ITERATOR_ITEM_END", "2"),
    ("(gint) GST_ITERATOR_ITEM_PASS", "1"),
    ("(gint) GST_ITERATOR_ITEM_SKIP", "0"),
    ("(gint) GST_ITERATOR_OK", "1"),
    ("(gint) GST_ITERATOR_RESYNC", "2"),
    ("(gint) GST_LEVEL_COUNT", "10"),
    ("(gint) GST_LEVEL_DEBUG", "5"),
    ("(gint) GST_LEVEL_ERROR", "1"),
    ("(gint) GST_LEVEL_FIXME", "3"),
    ("(gint) GST_LEVEL_INFO", "4"),
    ("(gint) GST_LEVEL_LOG", "6"),
    ("(gint) GST_LEVEL_MEMDUMP", "9"),
    ("(gint) GST_LEVEL_NONE", "0"),
    ("(gint) GST_LEVEL_TRACE", "7"),
    ("(gint) GST_LEVEL_WARNING", "2"),
    ("(gint) GST_LIBRARY_ERROR_ENCODE", "6"),
    ("(gint) GST_LIBRARY_ERROR_FAILED", "1"),
    ("(gint) GST_LIBRARY_ERROR_INIT", "3"),
    ("(gint) GST_LIBRARY_ERROR_NUM_ERRORS", "7"),
    ("(gint) GST_LIBRARY_ERROR_SETTINGS", "5"),
    ("(gint) GST_LIBRARY_ERROR_SHUTDOWN", "4"),
    ("(gint) GST_LIBRARY_ERROR_TOO_LAZY", "2"),
    ("GST_LICENSE_UNKNOWN", "unknown"),
    ("(guint) GST_LOCK_FLAG_EXCLUSIVE", "4"),
    ("(guint) GST_LOCK_FLAG_LAST", "256"),
    ("(guint) GST_LOCK_FLAG_READ", "1"),
    ("GST_LOCK_FLAG_READWRITE", "3"),
    ("(guint) GST_LOCK_FLAG_WRITE", "2"),
    ("(guint) GST_LOG_CONTEXT_DEFAULT", "0"),
    ("(guint) GST_LOG_CONTEXT_FLAG_NONE", "0"),
    ("(guint) GST_LOG_CONTEXT_FLAG_THROTTLE", "1"),
    ("(guint) GST_LOG_CONTEXT_IGNORE_FILE", "4"),
    ("(guint) GST_LOG_CONTEXT_IGNORE_FORMAT", "2"),
    ("(guint) GST_LOG_CONTEXT_IGNORE_OBJECT", "1"),
    ("(guint) GST_LOG_CONTEXT_USE_LINE_NUMBER", "8"),
    ("(guint) GST_LOG_CONTEXT_USE_STRING_ARGS", "16"),
    ("(guint) GST_MAP_FLAG_LAST", "65536"),
    ("(guint) GST_MAP_READ", "1"),
    ("GST_MAP_READWRITE", "3"),
    ("(guint) GST_MAP_REF_MEMORY", "256"),
    ("(guint) GST_MAP_WRITE", "2"),
    ("(guint) GST_MEMORY_FLAG_LAST", "1048576"),
    ("(guint) GST_MEMORY_FLAG_NOT_MAPPABLE", "256"),
    ("(guint) GST_MEMORY_FLAG_NO_SHARE", "16"),
    ("(guint) GST_MEMORY_FLAG_PHYSICALLY_CONTIGUOUS", "128"),
    ("(guint) GST_MEMORY_FLAG_READONLY", "2"),
    ("(guint) GST_MEMORY_FLAG_ZERO_PADDED", "64"),
    ("(guint) GST_MEMORY_FLAG_ZERO_PREFIXED", "32"),
    ("(guint) GST_MESSAGE_ANY", "4294967295"),
    ("(guint) GST_MESSAGE_APPLICATION", "16384"),
    ("(guint) GST_MESSAGE_ASYNC_DONE", "2097152"),
    ("(guint) GST_MESSAGE_ASYNC_START", "1048576"),
    ("(guint) GST_MESSAGE_BUFFERING", "32"),
    ("(guint) GST_MESSAGE_CLOCK_LOST", "1024"),
    ("(guint) GST_MESSAGE_CLOCK_PROVIDE", "512"),
    ("(guint) GST_MESSAGE_DEVICE_ADDED", "2147483649"),
    ("(guint) GST_MESSAGE_DEVICE_CHANGED", "2147483655"),
    ("(guint) GST_MESSAGE_DEVICE_MONITOR_STARTED", "2147483657"),
    ("(guint) GST_MESSAGE_DEVICE_REMOVED", "2147483650"),
    ("(guint) GST_MESSAGE_DURATION_CHANGED", "262144"),
    ("(guint) GST_MESSAGE_ELEMENT", "32768"),
    ("(guint) GST_MESSAGE_EOS", "1"),
    ("(guint) GST_MESSAGE_ERROR", "2"),
    ("(guint) GST_MESSAGE_EXTENDED", "2147483648"),
    ("(guint) GST_MESSAGE_HAVE_CONTEXT", "1073741824"),
    ("(guint) GST_MESSAGE_INFO", "8"),
    ("(guint) GST_MESSAGE_INSTANT_RATE_REQUEST", "2147483656"),
    ("(guint) GST_MESSAGE_LATENCY", "524288"),
    ("(guint) GST_MESSAGE_NEED_CONTEXT", "536870912"),
    ("(guint) GST_MESSAGE_NEW_CLOCK", "2048"),
    ("(guint) GST_MESSAGE_PROGRESS", "33554432"),
    ("(guint) GST_MESSAGE_PROPERTY_NOTIFY", "2147483651"),
    ("(guint) GST_MESSAGE_QOS", "16777216"),
    ("(guint) GST_MESSAGE_REDIRECT", "2147483654"),
    ("(guint) GST_MESSAGE_REQUEST_STATE", "4194304"),
    ("(guint) GST_MESSAGE_RESET_TIME", "134217728"),
    ("(guint) GST_MESSAGE_SEGMENT_DONE", "131072"),
    ("(guint) GST_MESSAGE_SEGMENT_START", "65536"),
    ("(guint) GST_MESSAGE_STATE_CHANGED", "64"),
    ("(guint) GST_MESSAGE_STATE_DIRTY", "128"),
    ("(guint) GST_MESSAGE_STEP_DONE", "256"),
    ("(guint) GST_MESSAGE_STEP_START", "8388608"),
    ("(guint) GST_MESSAGE_STREAMS_SELECTED", "2147483653"),
    ("(guint) GST_MESSAGE_STREAM_COLLECTION", "2147483652"),
    ("(guint) GST_MESSAGE_STREAM_START", "268435456"),
    ("(guint) GST_MESSAGE_STREAM_STATUS", "8192"),
    ("(guint) GST_MESSAGE_STRUCTURE_CHANGE", "4096"),
    ("(guint) GST_MESSAGE_TAG", "16"),
    ("(guint) GST_MESSAGE_TOC", "67108864"),
    ("(guint) GST_MESSAGE_UNKNOWN", "0"),
    ("(guint) GST_MESSAGE_WARNING", "4"),
    ("(guint) GST_META_FLAG_LAST", "65536"),
    ("(guint) GST_META_FLAG_LOCKED", "4"),
    ("(guint) GST_META_FLAG_NONE", "0"),
    ("(guint) GST_META_FLAG_POOLED", "2"),
    ("(guint) GST_META_FLAG_READONLY", "1"),
    ("GST_META_TAG_MEMORY_REFERENCE_STR", "memory-reference"),
    ("GST_META_TAG_MEMORY_STR", "memory"),
    ("(guint) GST_MINI_OBJECT_FLAG_LAST", "16"),
    ("(guint) GST_MINI_OBJECT_FLAG_LOCKABLE", "1"),
    ("(guint) GST_MINI_OBJECT_FLAG_LOCK_READONLY", "2"),
    ("(guint) GST_MINI_OBJECT_FLAG_MAY_BE_LEAKED", "4"),
    ("GST_MSECOND", "1000000"),
    ("GST_NSECOND", "1"),
    ("(guint) GST_OBJECT_FLAG_CONSTRUCTED", "2"),
    ("(guint) GST_OBJECT_FLAG_LAST", "16"),
    ("(guint) GST_OBJECT_FLAG_MAY_BE_LEAKED", "1"),
    ("(gint) GST_PAD_ALWAYS", "0"),
    ("(guint) GST_PAD_FLAG_ACCEPT_INTERSECT", "32768"),
    ("(guint) GST_PAD_FLAG_ACCEPT_TEMPLATE", "65536"),
    ("(guint) GST_PAD_FLAG_BLOCKED", "16"),
    ("(guint) GST_PAD_FLAG_BLOCKING", "128"),
    ("(guint) GST_PAD_FLAG_EOS", "64"),
    ("(guint) GST_PAD_FLAG_FIXED_CAPS", "2048"),
    ("(guint) GST_PAD_FLAG_FLUSHING", "32"),
    ("(guint) GST_PAD_FLAG_LAST", "1048576"),
    ("(guint) GST_PAD_FLAG_NEED_PARENT", "256"),
    ("(guint) GST_PAD_FLAG_NEED_RECONFIGURE", "512"),
    ("(guint) GST_PAD_FLAG_PENDING_EVENTS", "1024"),
    ("(guint) GST_PAD_FLAG_PROXY_ALLOCATION", "8192"),
    ("(guint) GST_PAD_FLAG_PROXY_CAPS", "4096"),
    ("(guint) GST_PAD_FLAG_PROXY_SCHEDULING", "16384"),
    ("(guint) GST_PAD_LINK_CHECK_CAPS", "4"),
    ("(guint) GST_PAD_LINK_CHECK_DEFAULT", "5"),
    ("(guint) GST_PAD_LINK_CHECK_HIERARCHY", "1"),
    ("(guint) GST_PAD_LINK_CHECK_NOTHING", "0"),
    ("(guint) GST_PAD_LINK_CHECK_NO_RECONFIGURE", "8"),
    ("(guint) GST_PAD_LINK_CHECK_TEMPLATE_CAPS", "2"),
    ("(gint) GST_PAD_LINK_NOFORMAT", "-4"),
    ("(gint) GST_PAD_LINK_NOSCHED", "-5"),
    ("(gint) GST_PAD_LINK_OK", "0"),
    ("(gint) GST_PAD_LINK_REFUSED", "-6"),
    ("(gint) GST_PAD_LINK_WAS_LINKED", "-2"),
    ("(gint) GST_PAD_LINK_WRONG_DIRECTION", "-3"),
    ("(gint) GST_PAD_LINK_WRONG_HIERARCHY", "-1"),
    ("(gint) GST_PAD_MODE_NONE", "0"),
    ("(gint) GST_PAD_MODE_PULL", "2"),
    ("(gint) GST_PAD_MODE_PUSH", "1"),
    ("(gint) GST_PAD_PROBE_DROP", "0"),
    ("(gint) GST_PAD_PROBE_HANDLED", "4"),
    ("(gint) GST_PAD_PROBE_OK", "1"),
    ("(gint) GST_PAD_PROBE_PASS", "3"),
    ("(gint) GST_PAD_PROBE_REMOVE", "2"),
    ("(guint) GST_PAD_PROBE_TYPE_ALL_BOTH", "1776"),
    ("(guint) GST_PAD_PROBE_TYPE_BLOCK", "2"),
    ("(guint) GST_PAD_PROBE_TYPE_BLOCKING", "3"),
    ("(guint) GST_PAD_PROBE_TYPE_BLOCK_DOWNSTREAM", "114"),
    ("(guint) GST_PAD_PROBE_TYPE_BLOCK_UPSTREAM", "130"),
    ("(guint) GST_PAD_PROBE_TYPE_BUFFER", "16"),
    ("(guint) GST_PAD_PROBE_TYPE_BUFFER_LIST", "32"),
    ("(guint) GST_PAD_PROBE_TYPE_DATA_BOTH", "240"),
    ("(guint) GST_PAD_PROBE_TYPE_DATA_DOWNSTREAM", "112"),
    ("(guint) GST_PAD_PROBE_TYPE_DATA_UPSTREAM", "128"),
    ("(guint) GST_PAD_PROBE_TYPE_EVENT_BOTH", "192"),
    ("(guint) GST_PAD_PROBE_TYPE_EVENT_DOWNSTREAM", "64"),
    ("(guint) GST_PAD_PROBE_TYPE_EVENT_FLUSH", "256"),
    ("(guint) GST_PAD_PROBE_TYPE_EVENT_UPSTREAM", "128"),
    ("(guint) GST_PAD_PROBE_TYPE_IDLE", "1"),
    ("(guint) GST_PAD_PROBE_TYPE_INVALID", "0"),
    ("(guint) GST_PAD_PROBE_TYPE_PULL", "8192"),
    ("(guint) GST_PAD_PROBE_TYPE_PUSH", "4096"),
    ("(guint) GST_PAD_PROBE_TYPE_QUERY_BOTH", "1536"),
    ("(guint) GST_PAD_PROBE_TYPE_QUERY_DOWNSTREAM", "512"),
    ("(guint) GST_PAD_PROBE_TYPE_QUERY_UPSTREAM", "1024"),
    ("(guint) GST_PAD_PROBE_TYPE_SCHEDULING", "12288"),
    ("(gint) GST_PAD_REQUEST", "2"),
    ("(gint) GST_PAD_SINK", "2"),
    ("(gint) GST_PAD_SOMETIMES", "1"),
    ("(gint) GST_PAD_SRC", "1"),
    ("(guint) GST_PAD_TEMPLATE_FLAG_LAST", "256"),
    ("(gint) GST_PAD_UNKNOWN", "0"),
    ("GST_PARAM_CONDITIONALLY_AVAILABLE", "16384"),
    ("GST_PARAM_CONTROLLABLE", "512"),
    ("GST_PARAM_DOC_SHOW_DEFAULT", "8192"),
    ("GST_PARAM_MUTABLE_PAUSED", "2048"),
    ("GST_PARAM_MUTABLE_PLAYING", "4096"),
    ("GST_PARAM_MUTABLE_READY", "1024"),
    ("GST_PARAM_USER_SHIFT", "65536"),
    ("(gint) GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY", "4"),
    ("(gint) GST_PARSE_ERROR_DELAYED_LINK", "7"),
    ("(gint) GST_PARSE_ERROR_EMPTY", "6"),
    ("(gint) GST_PARSE_ERROR_EMPTY_BIN", "5"),
    ("(gint) GST_PARSE_ERROR_LINK", "3"),
    ("(gint) GST_PARSE_ERROR_NO_SUCH_ELEMENT", "1"),
    ("(gint) GST_PARSE_ERROR_NO_SUCH_PROPERTY", "2"),
    ("(gint) GST_PARSE_ERROR_SYNTAX", "0"),
    ("(guint) GST_PARSE_FLAG_FATAL_ERRORS", "1"),
    ("(guint) GST_PARSE_FLAG_NONE", "0"),
    ("(guint) GST_PARSE_FLAG_NO_SINGLE_ELEMENT_BINS", "2"),
    ("(guint) GST_PARSE_FLAG_PLACE_IN_BIN", "4"),
    ("(guint) GST_PIPELINE_FLAG_FIXED_CLOCK", "524288"),
    ("(guint) GST_PIPELINE_FLAG_LAST", "8388608"),
    ("(guint) GST_PLUGIN_API_FLAG_IGNORE_ENUM_MEMBERS", "1"),
    (
        "(guint) GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_PREFIX",
        "8",
    ),
    (
        "(guint) GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_SUFFIX",
        "4",
    ),
    ("(guint) GST_PLUGIN_DEPENDENCY_FLAG_NONE", "0"),
    (
        "(guint) GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_DEFAULT_ONLY",
        "2",
    ),
    (
        "(guint) GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_RELATIVE_TO_EXE",
        "16",
    ),
    ("(guint) GST_PLUGIN_DEPENDENCY_FLAG_RECURSE", "1"),
    ("(gint) GST_PLUGIN_ERROR_DEPENDENCIES", "1"),
    ("(gint) GST_PLUGIN_ERROR_MODULE", "0"),
    ("(gint) GST_PLUGIN_ERROR_NAME_MISMATCH", "2"),
    ("(guint) GST_PLUGIN_FLAG_BLACKLISTED", "32"),
    ("(guint) GST_PLUGIN_FLAG_CACHED", "16"),
    ("(gint) GST_PROGRESS_TYPE_CANCELED", "3"),
    ("(gint) GST_PROGRESS_TYPE_COMPLETE", "2"),
    ("(gint) GST_PROGRESS_TYPE_CONTINUE", "1"),
    ("(gint) GST_PROGRESS_TYPE_ERROR", "4"),
    ("(gint) GST_PROGRESS_TYPE_START", "0"),
    ("(gint) GST_PROMISE_RESULT_EXPIRED", "3"),
    ("(gint) GST_PROMISE_RESULT_INTERRUPTED", "1"),
    ("(gint) GST_PROMISE_RESULT_PENDING", "0"),
    ("(gint) GST_PROMISE_RESULT_REPLIED", "2"),
    ("GST_PROTECTION_SYSTEM_ID_CAPS_FIELD", "protection-system"),
    (
        "GST_PROTECTION_UNSPECIFIED_SYSTEM_ID",
        "unspecified-system-id",
    ),
    ("(gint) GST_QOS_TYPE_OVERFLOW", "0"),
    ("(gint) GST_QOS_TYPE_THROTTLE", "2"),
    ("(gint) GST_QOS_TYPE_UNDERFLOW", "1"),
    ("(gint) GST_QUERY_ACCEPT_CAPS", "40963"),
    ("(gint) GST_QUERY_ALLOCATION", "35846"),
    ("(gint) GST_QUERY_BITRATE", "51202"),
    ("(gint) GST_QUERY_BUFFERING", "28163"),
    ("(gint) GST_QUERY_CAPS", "43523"),
    ("(gint) GST_QUERY_CONTEXT", "48643"),
    ("(gint) GST_QUERY_CONVERT", "20483"),
    ("(gint) GST_QUERY_CUSTOM", "30723"),
    ("(gint) GST_QUERY_DRAIN", "46086"),
    ("(gint) GST_QUERY_DURATION", "5123"),
    ("(gint) GST_QUERY_FORMATS", "23043"),
    ("(gint) GST_QUERY_JITTER", "10243"),
    ("(gint) GST_QUERY_LATENCY", "7683"),
    ("GST_QUERY_NUM_SHIFT", "8"),
    ("(gint) GST_QUERY_POSITION", "2563"),
    ("(gint) GST_QUERY_RATE", "12803"),
    ("(gint) GST_QUERY_SCHEDULING", "38401"),
    ("(gint) GST_QUERY_SEEKING", "15363"),
    ("(gint) GST_QUERY_SEGMENT", "17923"),
    ("(gint) GST_QUERY_SELECTABLE", "53763"),
    ("GST_QUERY_TYPE_BOTH", "3"),
    ("(guint) GST_QUERY_TYPE_DOWNSTREAM", "2"),
    ("(guint) GST_QUERY_TYPE_SERIALIZED", "4"),
    ("(guint) GST_QUERY_TYPE_UPSTREAM", "1"),
    ("(gint) GST_QUERY_UNKNOWN", "0"),
    ("(gint) GST_QUERY_URI", "33283"),
    ("(gint) GST_RANK_MARGINAL", "64"),
    ("(gint) GST_RANK_NONE", "0"),
    ("(gint) GST_RANK_PRIMARY", "256"),
    ("(gint) GST_RANK_SECONDARY", "128"),
    ("(gint) GST_RESOURCE_ERROR_BUSY", "4"),
    ("(gint) GST_RESOURCE_ERROR_CLOSE", "8"),
    ("(gint) GST_RESOURCE_ERROR_FAILED", "1"),
    ("(gint) GST_RESOURCE_ERROR_NOT_AUTHORIZED", "15"),
    ("(gint) GST_RESOURCE_ERROR_NOT_FOUND", "3"),
    ("(gint) GST_RESOURCE_ERROR_NO_SPACE_LEFT", "14"),
    ("(gint) GST_RESOURCE_ERROR_NUM_ERRORS", "16"),
    ("(gint) GST_RESOURCE_ERROR_OPEN_READ", "5"),
    ("(gint) GST_RESOURCE_ERROR_OPEN_READ_WRITE", "7"),
    ("(gint) GST_RESOURCE_ERROR_OPEN_WRITE", "6"),
    ("(gint) GST_RESOURCE_ERROR_READ", "9"),
    ("(gint) GST_RESOURCE_ERROR_SEEK", "11"),
    ("(gint) GST_RESOURCE_ERROR_SETTINGS", "13"),
    ("(gint) GST_RESOURCE_ERROR_SYNC", "12"),
    ("(gint) GST_RESOURCE_ERROR_TOO_LAZY", "2"),
    ("(gint) GST_RESOURCE_ERROR_WRITE", "10"),
    ("(guint) GST_SCHEDULING_FLAG_BANDWIDTH_LIMITED", "4"),
    ("(guint) GST_SCHEDULING_FLAG_SEEKABLE", "1"),
    ("(guint) GST_SCHEDULING_FLAG_SEQUENTIAL", "2"),
    ("(gint) GST_SEARCH_MODE_AFTER", "2"),
    ("(gint) GST_SEARCH_MODE_BEFORE", "1"),
    ("(gint) GST_SEARCH_MODE_EXACT", "0"),
    ("GST_SECOND", "1000000000"),
    ("(guint) GST_SEEK_FLAG_ACCURATE", "2"),
    ("(guint) GST_SEEK_FLAG_FLUSH", "1"),
    ("(guint) GST_SEEK_FLAG_INSTANT_RATE_CHANGE", "1024"),
    ("(guint) GST_SEEK_FLAG_KEY_UNIT", "4"),
    ("(guint) GST_SEEK_FLAG_NONE", "0"),
    ("(guint) GST_SEEK_FLAG_SEGMENT", "8"),
    ("(guint) GST_SEEK_FLAG_SKIP", "16"),
    ("(guint) GST_SEEK_FLAG_SNAP_AFTER", "64"),
    ("(guint) GST_SEEK_FLAG_SNAP_BEFORE", "32"),
    ("(guint) GST_SEEK_FLAG_SNAP_NEAREST", "96"),
    ("(guint) GST_SEEK_FLAG_TRICKMODE", "16"),
    ("(guint) GST_SEEK_FLAG_TRICKMODE_FORWARD_PREDICTED", "512"),
    ("(guint) GST_SEEK_FLAG_TRICKMODE_KEY_UNITS", "128"),
    ("(guint) GST_SEEK_FLAG_TRICKMODE_NO_AUDIO", "256"),
    ("(gint) GST_SEEK_TYPE_END", "2"),
    ("(gint) GST_SEEK_TYPE_NONE", "0"),
    ("(gint) GST_SEEK_TYPE_SET", "1"),
    ("(guint) GST_SEGMENT_FLAG_NONE", "0"),
    ("(guint) GST_SEGMENT_FLAG_RESET", "1"),
    ("(guint) GST_SEGMENT_FLAG_SEGMENT", "8"),
    ("(guint) GST_SEGMENT_FLAG_SKIP", "16"),
    ("(guint) GST_SEGMENT_FLAG_TRICKMODE", "16"),
    (
        "(guint) GST_SEGMENT_FLAG_TRICKMODE_FORWARD_PREDICTED",
        "512",
    ),
    ("(guint) GST_SEGMENT_FLAG_TRICKMODE_KEY_UNITS", "128"),
    ("(guint) GST_SEGMENT_FLAG_TRICKMODE_NO_AUDIO", "256"),
    ("GST_SEGMENT_INSTANT_FLAGS", "912"),
    ("GST_SEQNUM_INVALID", "0"),
    ("(guint) GST_SERIALIZE_FLAG_BACKWARD_COMPAT", "1"),
    ("(guint) GST_SERIALIZE_FLAG_NONE", "0"),
    ("(guint) GST_SERIALIZE_FLAG_STRICT", "2"),
    ("(guint) GST_STACK_TRACE_SHOW_FULL", "1"),
    ("(guint) GST_STACK_TRACE_SHOW_NONE", "0"),
    ("(gint) GST_STATE_CHANGE_ASYNC", "2"),
    ("(gint) GST_STATE_CHANGE_FAILURE", "0"),
    ("(gint) GST_STATE_CHANGE_NO_PREROLL", "3"),
    ("(gint) GST_STATE_CHANGE_NULL_TO_NULL", "9"),
    ("(gint) GST_STATE_CHANGE_NULL_TO_READY", "10"),
    ("(gint) GST_STATE_CHANGE_PAUSED_TO_PAUSED", "27"),
    ("(gint) GST_STATE_CHANGE_PAUSED_TO_PLAYING", "28"),
    ("(gint) GST_STATE_CHANGE_PAUSED_TO_READY", "26"),
    ("(gint) GST_STATE_CHANGE_PLAYING_TO_PAUSED", "35"),
    ("(gint) GST_STATE_CHANGE_PLAYING_TO_PLAYING", "36"),
    ("(gint) GST_STATE_CHANGE_READY_TO_NULL", "17"),
    ("(gint) GST_STATE_CHANGE_READY_TO_PAUSED", "19"),
    ("(gint) GST_STATE_CHANGE_READY_TO_READY", "18"),
    ("(gint) GST_STATE_CHANGE_SUCCESS", "1"),
    ("(gint) GST_STATE_NULL", "1"),
    ("(gint) GST_STATE_PAUSED", "3"),
    ("(gint) GST_STATE_PLAYING", "4"),
    ("(gint) GST_STATE_READY", "2"),
    ("(gint) GST_STATE_VOID_PENDING", "0"),
    ("(gint) GST_STREAM_ERROR_CODEC_NOT_FOUND", "6"),
    ("(gint) GST_STREAM_ERROR_DECODE", "7"),
    ("(gint) GST_STREAM_ERROR_DECRYPT", "12"),
    ("(gint) GST_STREAM_ERROR_DECRYPT_NOKEY", "13"),
    ("(gint) GST_STREAM_ERROR_DEMUX", "9"),
    ("(gint) GST_STREAM_ERROR_ENCODE", "8"),
    ("(gint) GST_STREAM_ERROR_FAILED", "1"),
    ("(gint) GST_STREAM_ERROR_FORMAT", "11"),
    ("(gint) GST_STREAM_ERROR_MUX", "10"),
    ("(gint) GST_STREAM_ERROR_NOT_IMPLEMENTED", "3"),
    ("(gint) GST_STREAM_ERROR_NUM_ERRORS", "14"),
    ("(gint) GST_STREAM_ERROR_TOO_LAZY", "2"),
    ("(gint) GST_STREAM_ERROR_TYPE_NOT_FOUND", "4"),
    ("(gint) GST_STREAM_ERROR_WRONG_TYPE", "5"),
    ("(guint) GST_STREAM_FLAG_NONE", "0"),
    ("(guint) GST_STREAM_FLAG_SELECT", "2"),
    ("(guint) GST_STREAM_FLAG_SPARSE", "1"),
    ("(guint) GST_STREAM_FLAG_UNSELECT", "4"),
    ("(gint) GST_STREAM_STATUS_TYPE_CREATE", "0"),
    ("(gint) GST_STREAM_STATUS_TYPE_DESTROY", "3"),
    ("(gint) GST_STREAM_STATUS_TYPE_ENTER", "1"),
    ("(gint) GST_STREAM_STATUS_TYPE_LEAVE", "2"),
    ("(gint) GST_STREAM_STATUS_TYPE_PAUSE", "9"),
    ("(gint) GST_STREAM_STATUS_TYPE_START", "8"),
    ("(gint) GST_STREAM_STATUS_TYPE_STOP", "10"),
    ("(guint) GST_STREAM_TYPE_AUDIO", "2"),
    ("(guint) GST_STREAM_TYPE_CONTAINER", "8"),
    ("(guint) GST_STREAM_TYPE_METADATA", "32"),
    ("(guint) GST_STREAM_TYPE_TEXT", "16"),
    ("(guint) GST_STREAM_TYPE_UNKNOWN", "1"),
    ("(guint) GST_STREAM_TYPE_VIDEO", "4"),
    ("(gint) GST_STRUCTURE_CHANGE_TYPE_PAD_LINK", "0"),
    ("(gint) GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK", "1"),
    ("GST_TAG_ALBUM", "album"),
    ("GST_TAG_ALBUM_ARTIST", "album-artist"),
    ("GST_TAG_ALBUM_ARTIST_SORTNAME", "album-artist-sortname"),
    ("GST_TAG_ALBUM_GAIN", "replaygain-album-gain"),
    ("GST_TAG_ALBUM_GAIN_R128", "r128-album-gain"),
    ("GST_TAG_ALBUM_PEAK", "replaygain-album-peak"),
    ("GST_TAG_ALBUM_SORTNAME", "album-sortname"),
    ("GST_TAG_ALBUM_VOLUME_COUNT", "album-disc-count"),
    ("GST_TAG_ALBUM_VOLUME_NUMBER", "album-disc-number"),
    ("GST_TAG_APPLICATION_DATA", "application-data"),
    ("GST_TAG_APPLICATION_NAME", "application-name"),
    ("GST_TAG_ARTIST", "artist"),
    ("GST_TAG_ARTIST_SORTNAME", "artist-sortname"),
    ("GST_TAG_ATTACHMENT", "attachment"),
    ("GST_TAG_AUDIO_CODEC", "audio-codec"),
    ("GST_TAG_BEATS_PER_MINUTE", "beats-per-minute"),
    ("GST_TAG_BITRATE", "bitrate"),
    ("GST_TAG_CODEC", "codec"),
    ("GST_TAG_COMMENT", "comment"),
    ("GST_TAG_COMPOSER", "composer"),
    ("GST_TAG_COMPOSER_SORTNAME", "composer-sortname"),
    ("GST_TAG_CONDUCTOR", "conductor"),
    ("GST_TAG_CONTACT", "contact"),
    ("GST_TAG_CONTAINER_FORMAT", "container-format"),
    (
        "GST_TAG_CONTAINER_SPECIFIC_TRACK_ID",
        "container-specific-track-id",
    ),
    ("GST_TAG_COPYRIGHT", "copyright"),
    ("GST_TAG_COPYRIGHT_URI", "copyright-uri"),
    ("GST_TAG_DATE", "date"),
    ("GST_TAG_DATE_TIME", "datetime"),
    ("GST_TAG_DESCRIPTION", "description"),
    ("GST_TAG_DEVICE_MANUFACTURER", "device-manufacturer"),
    ("GST_TAG_DEVICE_MODEL", "device-model"),
    ("GST_TAG_DURATION", "duration"),
    ("GST_TAG_ENCODED_BY", "encoded-by"),
    ("GST_TAG_ENCODER", "encoder"),
    ("GST_TAG_ENCODER_VERSION", "encoder-version"),
    ("GST_TAG_EXTENDED_COMMENT", "extended-comment"),
    ("(gint) GST_TAG_FLAG_COUNT", "4"),
    ("(gint) GST_TAG_FLAG_DECODED", "3"),
    ("(gint) GST_TAG_FLAG_ENCODED", "2"),
    ("(gint) GST_TAG_FLAG_META", "1"),
    ("(gint) GST_TAG_FLAG_UNDEFINED", "0"),
    ("GST_TAG_GENRE", "genre"),
    (
        "GST_TAG_GEO_LOCATION_CAPTURE_DIRECTION",
        "geo-location-capture-direction",
    ),
    ("GST_TAG_GEO_LOCATION_CITY", "geo-location-city"),
    ("GST_TAG_GEO_LOCATION_COUNTRY", "geo-location-country"),
    ("GST_TAG_GEO_LOCATION_ELEVATION", "geo-location-elevation"),
    (
        "GST_TAG_GEO_LOCATION_HORIZONTAL_ERROR",
        "geo-location-horizontal-error",
    ),
    ("GST_TAG_GEO_LOCATION_LATITUDE", "geo-location-latitude"),
    ("GST_TAG_GEO_LOCATION_LONGITUDE", "geo-location-longitude"),
    (
        "GST_TAG_GEO_LOCATION_MOVEMENT_DIRECTION",
        "geo-location-movement-direction",
    ),
    (
        "GST_TAG_GEO_LOCATION_MOVEMENT_SPEED",
        "geo-location-movement-speed",
    ),
    ("GST_TAG_GEO_LOCATION_NAME", "geo-location-name"),
    (
        "GST_TAG_GEO_LOCATION_SUBLOCATION",
        "geo-location-sublocation",
    ),
    ("GST_TAG_GROUPING", "grouping"),
    ("GST_TAG_HOMEPAGE", "homepage"),
    ("GST_TAG_IMAGE", "image"),
    ("GST_TAG_IMAGE_ORIENTATION", "image-orientation"),
    ("GST_TAG_INTERPRETED_BY", "interpreted-by"),
    ("GST_TAG_ISRC", "isrc"),
    ("GST_TAG_KEYWORDS", "keywords"),
    ("GST_TAG_LANGUAGE_CODE", "language-code"),
    ("GST_TAG_LANGUAGE_NAME", "language-name"),
    ("GST_TAG_LICENSE", "license"),
    ("GST_TAG_LICENSE_URI", "license-uri"),
    ("GST_TAG_LOCATION", "location"),
    ("GST_TAG_LYRICS", "lyrics"),
    ("GST_TAG_MAXIMUM_BITRATE", "maximum-bitrate"),
    ("(gint) GST_TAG_MERGE_APPEND", "3"),
    ("(gint) GST_TAG_MERGE_COUNT", "7"),
    ("(gint) GST_TAG_MERGE_KEEP", "5"),
    ("(gint) GST_TAG_MERGE_KEEP_ALL", "6"),
    ("(gint) GST_TAG_MERGE_PREPEND", "4"),
    ("(gint) GST_TAG_MERGE_REPLACE", "2"),
    ("(gint) GST_TAG_MERGE_REPLACE_ALL", "1"),
    ("(gint) GST_TAG_MERGE_UNDEFINED", "0"),
    ("GST_TAG_MIDI_BASE_NOTE", "midi-base-note"),
    ("GST_TAG_MINIMUM_BITRATE", "minimum-bitrate"),
    ("GST_TAG_NOMINAL_BITRATE", "nominal-bitrate"),
    ("GST_TAG_ORGANIZATION", "organization"),
    ("GST_TAG_PERFORMER", "performer"),
    ("GST_TAG_PREVIEW_IMAGE", "preview-image"),
    ("GST_TAG_PRIVATE_DATA", "private-data"),
    ("GST_TAG_PUBLISHER", "publisher"),
    ("GST_TAG_REFERENCE_LEVEL", "replaygain-reference-level"),
    ("(gint) GST_TAG_SCOPE_GLOBAL", "1"),
    ("(gint) GST_TAG_SCOPE_STREAM", "0"),
    ("GST_TAG_SERIAL", "serial"),
    ("GST_TAG_SHOW_EPISODE_NUMBER", "show-episode-number"),
    ("GST_TAG_SHOW_NAME", "show-name"),
    ("GST_TAG_SHOW_SEASON_NUMBER", "show-season-number"),
    ("GST_TAG_SHOW_SORTNAME", "show-sortname"),
    ("GST_TAG_SUBTITLE_CODEC", "subtitle-codec"),
    ("GST_TAG_TITLE", "title"),
    ("GST_TAG_TITLE_SORTNAME", "title-sortname"),
    ("GST_TAG_TRACK_COUNT", "track-count"),
    ("GST_TAG_TRACK_GAIN", "replaygain-track-gain"),
    ("GST_TAG_TRACK_GAIN_R128", "r128-track-gain"),
    ("GST_TAG_TRACK_NUMBER", "track-number"),
    ("GST_TAG_TRACK_PEAK", "replaygain-track-peak"),
    ("GST_TAG_USER_RATING", "user-rating"),
    ("GST_TAG_VERSION", "version"),
    ("GST_TAG_VIDEO_CODEC", "video-codec"),
    ("(gint) GST_TASK_PAUSED", "2"),
    ("GST_TASK_POOL_CONTEXT_TYPE", "gst.task.pool"),
    ("(gint) GST_TASK_STARTED", "0"),
    ("(gint) GST_TASK_STOPPED", "1"),
    ("(gint) GST_TOC_ENTRY_TYPE_ANGLE", "-3"),
    ("(gint) GST_TOC_ENTRY_TYPE_CHAPTER", "3"),
    ("(gint) GST_TOC_ENTRY_TYPE_EDITION", "-1"),
    ("(gint) GST_TOC_ENTRY_TYPE_INVALID", "0"),
    ("(gint) GST_TOC_ENTRY_TYPE_TITLE", "1"),
    ("(gint) GST_TOC_ENTRY_TYPE_TRACK", "2"),
    ("(gint) GST_TOC_ENTRY_TYPE_VERSION", "-2"),
    ("(gint) GST_TOC_LOOP_FORWARD", "1"),
    ("(gint) GST_TOC_LOOP_NONE", "0"),
    ("(gint) GST_TOC_LOOP_PING_PONG", "3"),
    ("(gint) GST_TOC_LOOP_REVERSE", "2"),
    ("GST_TOC_REPEAT_COUNT_INFINITE", "-1"),
    ("(gint) GST_TOC_SCOPE_CURRENT", "2"),
    ("(gint) GST_TOC_SCOPE_GLOBAL", "1"),
    ("(guint) GST_TRACER_VALUE_FLAGS_AGGREGATED", "2"),
    ("(guint) GST_TRACER_VALUE_FLAGS_NONE", "0"),
    ("(guint) GST_TRACER_VALUE_FLAGS_OPTIONAL", "1"),
    ("(gint) GST_TRACER_VALUE_SCOPE_ELEMENT", "2"),
    ("(gint) GST_TRACER_VALUE_SCOPE_PAD", "3"),
    ("(gint) GST_TRACER_VALUE_SCOPE_PROCESS", "0"),
    ("(gint) GST_TRACER_VALUE_SCOPE_THREAD", "1"),
    ("(gint) GST_TYPE_FIND_LIKELY", "80"),
    ("(gint) GST_TYPE_FIND_MAXIMUM", "100"),
    ("(gint) GST_TYPE_FIND_MINIMUM", "1"),
    ("(gint) GST_TYPE_FIND_NEARLY_CERTAIN", "99"),
    ("(gint) GST_TYPE_FIND_NONE", "0"),
    ("(gint) GST_TYPE_FIND_POSSIBLE", "50"),
    ("(gint) GST_URI_ERROR_BAD_REFERENCE", "3"),
    ("(gint) GST_URI_ERROR_BAD_STATE", "2"),
    ("(gint) GST_URI_ERROR_BAD_URI", "1"),
    ("(gint) GST_URI_ERROR_UNSUPPORTED_PROTOCOL", "0"),
    ("GST_URI_NO_PORT", "0"),
    ("(gint) GST_URI_SINK", "1"),
    ("(gint) GST_URI_SRC", "2"),
    ("(gint) GST_URI_UNKNOWN", "0"),
    ("GST_USECOND", "1000"),
    ("GST_VALUE_EQUAL", "0"),
    ("GST_VALUE_GREATER_THAN", "1"),
    ("GST_VALUE_LESS_THAN", "-1"),
    ("GST_VALUE_UNORDERED", "2"),
];
