#!/bin/sh
#
# start/stop rpcbind daemon.

### BEGIN INIT INFO
# Provides:          rpcbind portmap
# Required-Start:    $network $local_fs
# Required-Stop:     $network $local_fs
# Default-Start:     S
# Default-Stop:      0 6
# Short-Description: RPC portmapper replacement
# Description:       rpcbind is a server that converts RPC (Remote
#                    Procedure Call) program numbers into DARPA
#                    protocol port numbers. It must be running in
#                    order to make RPC calls. Services that use
#                    RPC include NFS and NIS.
### END INIT INFO

test -f /usr/sbin/rpcbind || exit 0

. /lib/lsb/init-functions

OPTIONS="-w"
STATEDIR=/run/rpcbind
PIDFILE=/run/rpcbind.pid

if [ -f /etc/default/rpcbind ]
then
    . /etc/default/rpcbind
elif [ -f /etc/rpcbind.conf ]
then
    . /etc/rpcbind.conf
fi

start ()
{
    if [ ! -d $STATEDIR ] ; then
        mkdir $STATEDIR
        chown _rpc:root $STATEDIR
        chmod 0755 $STATEDIR
    fi
    if [ `ls -dl "$STATEDIR" | grep -cE '^drwxr-xr-x [0-9]+ _rpc root '` -lt 1 ] ; then
        log_begin_msg "$STATEDIR not owned by root"
        log_end_msg 1
        exit 1
    fi
    [ -x /sbin/restorecon ] && /sbin/restorecon $STATEDIR
    pid=$( pidofproc /usr/sbin/rpcbind )
    if [ -n "$pid" ]
    then
        log_action_msg "Already running: rpcbind"
        exit 0
    fi
    log_daemon_msg "Starting RPC port mapper daemon" "rpcbind"
    start-stop-daemon --start --quiet --oknodo --exec /usr/sbin/rpcbind -- "$@"
    pid=$( pidofproc /usr/sbin/rpcbind )
    echo -n "$pid" >"$PIDFILE"
    # /run/sendsigs.omit.d is created by /etc/init.d/mountkernfs.sh
    ln -sf "$PIDFILE" /run/sendsigs.omit.d/rpcbind
    log_end_msg $?

}

stop ()
{
    log_daemon_msg "Stopping RPC port mapper daemon" "rpcbind"
    start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --oknodo --exec /usr/sbin/rpcbind
    rm -f "$PIDFILE"
    log_end_msg $?
}

case "$1" in
    start)
        if init_is_upstart; then
            exit 1
        fi
        start $OPTIONS
        ;;
    stop)
        if init_is_upstart; then
            exit 0
        fi
        stop
        ;;
    restart|force-reload)
        if init_is_upstart; then
            exit 1
        fi
        stop
        start $OPTIONS
        ;;
    status)
        status_of_proc /usr/sbin/rpcbind rpcbind && exit 0 || exit $?
        ;;
    *)
        log_success_msg "Usage: /etc/init.d/rpcbind {start|stop|force-reload|restart|status}"
        exit 1
        ;;
esac

exit 0
