;; Tests for i64x2 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i64x2.add") (param v128 v128) (result v128) (i64x2.add (local.get 0) (local.get 1)))
  (func (export "i64x2.sub") (param v128 v128) (result v128) (i64x2.sub (local.get 0) (local.get 1)))
  (func (export "i64x2.mul") (param v128 v128) (result v128) (i64x2.mul (local.get 0) (local.get 1)))
  (func (export "i64x2.neg") (param v128) (result v128) (i64x2.neg (local.get 0)))
)


;; i64x2.add
(assert_return (invoke "i64x2.add" (v128.const i64x2 0 0)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0 0)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 2 2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0 0)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -1 -1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 4611686018427387903 4611686018427387903)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 4611686018427387904 4611686018427387904)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -4611686018427387903 -4611686018427387903)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -4611686018427387904 -4611686018427387904)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -4611686018427387905 -4611686018427387905)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 9223372036854775805 9223372036854775805)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775806 9223372036854775806))
(assert_return (invoke "i64x2.add" (v128.const i64x2 9223372036854775806 9223372036854775806)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 9223372036854775808 9223372036854775808)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -9223372036854775806 -9223372036854775806)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -9223372036854775807 -9223372036854775807)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 9223372036854775807 9223372036854775807)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 9223372036854775806 9223372036854775806))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 18446744073709551615 18446744073709551615))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x3fffffffffffffff 0x3fffffffffffffff)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x4000000000000000 0x4000000000000000)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -0x3fffffffffffffff -0x3fffffffffffffff)
                                   (v128.const i64x2 -0x40000000fffffff -0x40000000fffffff))
                                   (v128.const i64x2 -4899916394847535102 -4899916394847535102))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000000 -0x400000000000000))
                                   (v128.const i64x2 -4899916394579099648 -4899916394579099648))
(assert_return (invoke "i64x2.add" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000001 -0x400000000000001))
                                   (v128.const i64x2 -4899916394579099649 -4899916394579099649))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x7ffffffffffffff 0x7ffffffffffffff))
                                   (v128.const i64x2 -8646911284551352322 -8646911284551352322))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 -0x01 -0x01))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i8x16 0 0 0 0 0 0 0 0x80 0 0 0 0 0 0 0 0x80))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i16x8 0 0 0 0x8000 0 0 0 0x8000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i32x4 0 0x80000000 0 0x80000000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 +0.0 +0.0))
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 -0.0 -0.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 1.0 1.0))
                                   (v128.const i64x2 0xbff0000000000000 0xbff0000000000000))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 -1.0 -1.0))
                                   (v128.const i64x2 0x3ff0000000000000 0x3ff0000000000000))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const f64x2 +inf +inf))
                                   (v128.const i64x2 0x7ff0000000000001 0x7ff0000000000001))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const i64x2 0xfff0000000000001 0xfff0000000000001))
(assert_return (invoke "i64x2.add" (v128.const i64x2 1 1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const i64x2 0x7ff8000000000001 0x7ff8000000000001))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 0xffffffffffffffff))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 2))
                                   (v128.const i64x2 0 3))
(assert_return (invoke "i64x2.add" (v128.const i64x2 01_234_567_890_123_456_789 01_234_567_890_123_456_789)
                                   (v128.const i64x2 01_234_567_890_123_456_789 01_234_567_890_123_456_789))
                                   (v128.const i64x2 02_469_135_780_246_913_578 02_469_135_780_246_913_578))
(assert_return (invoke "i64x2.add" (v128.const i64x2 0x0_1234_5678_90AB_cdef 0x0_1234_5678_90AB_cdef)
                                   (v128.const i64x2 0x0_90AB_cdef_1234_5678 0x0_90AB_cdef_1234_5678))
                                   (v128.const i64x2 0x0_a2e0_2467_a2e0_2467 0x0_a2e0_2467_a2e0_2467))

;; i64x2.sub
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0 0)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0 0)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 1 1)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0 0)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 1 1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 2 2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -1 -1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 4611686018427387903 4611686018427387903)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 4611686018427387904 4611686018427387904)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -4611686018427387903 -4611686018427387903)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -4611686018427387904 -4611686018427387904)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -4611686018427387905 -4611686018427387905)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 9223372036854775805 9223372036854775805)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775804 9223372036854775804))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 9223372036854775806 9223372036854775806)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775805 9223372036854775805))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 9223372036854775808 9223372036854775808)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -9223372036854775806 -9223372036854775806)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775805 -9223372036854775805))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -9223372036854775807 -9223372036854775807)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775806 -9223372036854775806))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 9223372036854775807 9223372036854775807)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 18446744073709551615 18446744073709551615))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x3fffffffffffffff 0x3fffffffffffffff)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x4000000000000000 0x4000000000000000)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -0x3fffffffffffffff -0x3fffffffffffffff)
                                   (v128.const i64x2 -0x40000000fffffff -0x40000000fffffff))
                                   (v128.const i64x2 -4323455642007240704 -4323455642007240704))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000000 -0x400000000000000))
                                   (v128.const i64x2 -4323455642275676160 -4323455642275676160))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000001 -0x400000000000001))
                                   (v128.const i64x2 -4323455642275676159 -4323455642275676159))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x7ffffffffffffff 0x7ffffffffffffff))
                                   (v128.const i64x2 8646911284551352320 8646911284551352320))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 9223372036854775806 9223372036854775806))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 -0x01 -0x01))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 -2 -2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i8x16 0 0 0 0 0 0 0 0x80 0 0 0 0 0 0 0 0x80))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i64x2 2 2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i16x8 0 0 0 0x8000 0 0 0 0x8000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 1 1)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i64x2 2 2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i32x4 0 0x80000000 0 0x80000000))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 1 1)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i64x2 2 2))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 +0.0 +0.0))
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 -0.0 -0.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 1.0 1.0))
                                   (v128.const i64x2 0x4010000000000000 0x4010000000000000))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const f64x2 -1.0 -1.0))
                                   (v128.const i64x2 0xc010000000000000 0xc010000000000000))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 +inf +inf))
                                   (v128.const i64x2 0x8010000000000001 0x8010000000000001))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const i64x2 0x0010000000000001 0x0010000000000001))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const i64x2 0x8008000000000001 0x8008000000000001))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 0xffffffffffffffff))
                                   (v128.const i64x2 0 0x02))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 2))
                                   (v128.const i64x2 0 -1))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 03_214_567_890_123_456_789 03_214_567_890_123_456_789)
                                   (v128.const i64x2 01_234_567_890_123_456_789 01_234_567_890_123_456_789))
                                   (v128.const i64x2 01_980_000_000_000_000_000 01_980_000_000_000_000_000))
(assert_return (invoke "i64x2.sub" (v128.const i64x2 0x0_90AB_cdef_8765_4321 0x0_90AB_cdef_8765_4321)
                                   (v128.const i64x2 0x0_1234_5678_90AB_cdef 0x0_1234_5678_90AB_cdef))
                                   (v128.const i64x2 0x0_7e77_7776_f6b9_7532 0x0_7e77_7776_f6b9_7532))

;; i64x2.mul
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0 0)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0 0)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 1 1)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0 0)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 1 1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -1 -1)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 4611686018427387903 4611686018427387903)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 4611686018427387904 4611686018427387904)
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -4611686018427387903 -4611686018427387903)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -4611686018427387904 -4611686018427387904)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -4611686018427387905 -4611686018427387905)
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 9223372036854775805 9223372036854775805)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775805 9223372036854775805))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 9223372036854775806 9223372036854775806)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 9223372036854775806 9223372036854775806))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 9223372036854775808 9223372036854775808)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -9223372036854775806 -9223372036854775806)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 9223372036854775806 9223372036854775806))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -9223372036854775807 -9223372036854775807)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 9223372036854775807 9223372036854775807)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -9223372036854775808 -9223372036854775808)
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 0 0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 1 1))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 18446744073709551615 18446744073709551615)
                                   (v128.const i64x2 18446744073709551615 18446744073709551615))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x3fffffffffffffff 0x3fffffffffffffff)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 -4611686018427387904 -4611686018427387904))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x4000000000000000 0x4000000000000000)
                                   (v128.const i64x2 0x4000000000000000 0x4000000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -0x3fffffffffffffff -0x3fffffffffffffff)
                                   (v128.const i64x2 -0x40000000fffffff -0x40000000fffffff))
                                   (v128.const i64x2 -4899916394847535103 -4899916394847535103))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000000 -0x400000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 -0x4000000000000000 -0x4000000000000000)
                                   (v128.const i64x2 -0x400000000000001 -0x400000000000001))
                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x7ffffffffffffff 0x7ffffffffffffff))
                                   (v128.const i64x2 8646911284551352321 8646911284551352321))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 -0x01 -0x01))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i8x16 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2 0x2))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i16x8 0 0 0 0x02 0 0 0 0x02))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x8000000000000000 0x8000000000000000)
                                   (v128.const i32x4 0 0x02 0 0x02))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x80000000 0x80000000)
                                   (v128.const f64x2 +0.0 +0.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x80000000 0x80000000)
                                   (v128.const f64x2 -0.0 -0.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x80000000 0x80000000)
                                   (v128.const f64x2 1.0 1.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x80000000 0x80000000)
                                   (v128.const f64x2 -1.0 -1.0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 +inf +inf))
                                   (v128.const i64x2 0x7ff0000000000000 0x7ff0000000000000))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const i64x2 0xfff0000000000000 0xfff0000000000000))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x1 0x1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const i64x2 0x7ff8000000000000 0x7ff8000000000000))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 0xffffffffffffffff))
                                   (v128.const i64x2 0 0xffffffffffffffff))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0 1)
                                   (v128.const i64x2 0 2))
                                   (v128.const i64x2 0 0x02))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 01_234_567_890_123_456_789 01_234_567_890_123_456_789)
                                   (v128.const i64x2 01_234_567_890_123_456_789 01_234_567_890_123_456_789))
                                   (v128.const i64x2 09_710_478_858_155_731_897 09_710_478_858_155_731_897))
(assert_return (invoke "i64x2.mul" (v128.const i64x2 0x0_1234_5678_90AB_cdef 0x0_1234_5678_90AB_cdef)
                                   (v128.const i64x2 0x0_90AB_cdef_8765_4321 0x0_90AB_cdef_8765_4321))
                                   (v128.const i64x2 0x0_602f_05e9_e556_18cf 0x0_602f_05e9_e556_18cf))

;; i64x2.neg
(assert_return (invoke "i64x2.neg" (v128.const i64x2 0 0))
                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 1 1))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -1 -1))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 9223372036854775806 9223372036854775806))
                                   (v128.const i64x2 -9223372036854775806 -9223372036854775806))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -9223372036854775807 -9223372036854775807))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -9223372036854775808 -9223372036854775808))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 9223372036854775807 9223372036854775807))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 18446744073709551615 18446744073709551615))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 0x01 0x01))
                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -0x01 -0x01))
                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -0x8000000000000000 -0x8000000000000000))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 -0x7fffffffffffffff -0x7fffffffffffffff))
                                   (v128.const i64x2 9223372036854775807 9223372036854775807))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 0x7fffffffffffffff 0x7fffffffffffffff))
                                   (v128.const i64x2 -9223372036854775807 -9223372036854775807))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 0x8000000000000000 0x8000000000000000))
                                   (v128.const i64x2 -9223372036854775808 -9223372036854775808))
(assert_return (invoke "i64x2.neg" (v128.const i64x2 0xffffffffffffffff 0xffffffffffffffff))
                                   (v128.const i64x2 1 1))

;; type check
(assert_invalid (module (func (result v128) (i64x2.neg (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.add (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.sub (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.mul (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i64x2.neg-arg-empty (result v128)
      (i64x2.neg)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.add-1st-arg-empty (result v128)
      (i64x2.add (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.add-arg-empty (result v128)
      (i64x2.add)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.sub-1st-arg-empty (result v128)
      (i64x2.sub (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.sub-arg-empty (result v128)
      (i64x2.sub)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.mul-1st-arg-empty (result v128)
      (i64x2.mul (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.mul-arg-empty (result v128)
      (i64x2.mul)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (i64x2.add (i64x2.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-add") (param v128 v128 v128) (result v128)
    (i64x2.mul (i64x2.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-sub") (param v128 v128 v128) (result v128)
    (i64x2.mul (i64x2.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (i64x2.sub (i64x2.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (i64x2.add (i64x2.neg (local.get 0)) (local.get 1)))
  (func (export "mul-neg") (param v128 v128) (result v128)
    (i64x2.mul (i64x2.neg (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (i64x2.sub (i64x2.neg (local.get 0)) (local.get 1)))
)

(assert_return (invoke "add-sub" (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 2)
                                 (v128.const i64x2 0 2))
                                 (v128.const i64x2 0 1))
(assert_return (invoke "mul-add" (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 1)
                                 (v128.const i64x2 2 2))
                                 (v128.const i64x2 0 4))
(assert_return (invoke "mul-sub" (v128.const i64x2 0 2)
                                 (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 1))
                                 (v128.const i64x2 0 1))
(assert_return (invoke "sub-add" (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 2)
                                 (v128.const i64x2 0 2))
                                 (v128.const i64x2 0 1))
(assert_return (invoke "add-neg" (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 1))
                                 (v128.const i64x2 0 0))
(assert_return (invoke "mul-neg" (v128.const i64x2 0 1)
                                 (v128.const i64x2 2 2))
                                 (v128.const i64x2 0 -2))
(assert_return (invoke "sub-neg" (v128.const i64x2 0 1)
                                 (v128.const i64x2 0 1))
                                 (v128.const i64x2 0 -2))