


#include <tqcstring.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqlistview.h>
#include "qchecklistitem_imp.h"
#include "qlistviewitem_imp.h"
/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {
namespace Bindings {

    KJS::Object TQCheckListItemLoader::createBinding(KJSEmbedPart *jspart, KJS::ExecState *exec, const KJS::List &args) const
    {
        if ( args.size() == 0 ) {
                        // FALL THRU
        } else {
            JSOpaqueProxy * arg0 = JSProxy::toOpaqueProxy( args[ 0 ].imp() );
            TQString arg1 = ( args.size() >= 2 ) ? args[ 1 ].toString( exec ).qstring() : TQString::null;
            JSOpaqueProxy *prx = 0;

            if ( arg0 ) {
                if ( arg0->typeName() == "TQListViewItem" ) {
                    TQListViewItem * parent = arg0->toNative<TQListViewItem>();
                    prx = new JSOpaqueProxy( new TQCheckListItem( parent, arg1 ), "TQCheckListItem" );
                } else {
                    return KJS::Object();
                }
            } else {
                JSObjectProxy *arg0 = JSProxy::toObjectProxy( args[ 0 ].imp() );
                if ( arg0 ) {
                    TQListView * parent = ( TQListView * ) ( arg0->widget() );
                    prx = new JSOpaqueProxy( new TQCheckListItem( parent, arg1 ), "TQCheckListItem" );
                } else {
                    return KJS::Object();
                }
            }
            prx->setOwner( JSProxy::Native );
            KJS::Object proxyObj( prx );
            addBindings(jspart, exec, proxyObj );
            return proxyObj;
        }
        return KJS::Object();
    }
    void TQCheckListItemLoader::addBindings( KJSEmbedPart *jspart, KJS::ExecState *exec, KJS::Object &proxy ) const
    {
        TQListViewItemImp::addBindings( exec, proxy );
        TQCheckListItemImp::addBindings( exec, proxy );
    }

}
TQCheckListItemImp::TQCheckListItemImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCheckListItemImp::~TQCheckListItemImp()
{
}

void TQCheckListItemImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_paintCell_10, "paintCell" },
        { Method_paintFocus_11, "paintFocus" },
        { Method_width_12, "width" },
        { Method_setup_13, "setup" },
        { Method_setOn_14, "setOn" },
        { Method_isOn_15, "isOn" },
        { Method_type_16, "type" },
        { Method_text_17, "text" },
        { Method_text_18, "text" },
        { Method_setTristate_19, "setTristate" },
        { Method_isTristate_20, "isTristate" },
        { Method_state_21, "state" },
        { Method_setState_22, "setState" },
        { Method_rtti_23, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].id ) {
        if ( lastName != methods[idx].name ) {
            TQCheckListItemImp *meth = new TQCheckListItemImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum Type
        { "RadioButton", TQCheckListItem::RadioButton },
        { "CheckBox", TQCheckListItem::CheckBox },
        { "Controller", TQCheckListItem::Controller },
        { "RadioButtonController", TQCheckListItem::RadioButtonController },
        { "CheckBoxController", TQCheckListItem::CheckBoxController },
        // enum ToggleState
        { "Off", TQCheckListItem::Off },
        { "NoChange", TQCheckListItem::NoChange },
        { "On", TQCheckListItem::On },
	{ 0, 0 }
    };

    int enumidx = 0;
    do {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    } while( enums[enumidx].id );

}

TQCheckListItem *TQCheckListItemImp::toTQCheckListItem( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCheckListItem *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;
    return op->toNative<TQCheckListItem>();
}


KJS::Object TQCheckListItemImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCheckListItem_1:
             return TQCheckListItem_1( exec, args );
             break;

         case Constructor_QCheckListItem_2:
             return TQCheckListItem_2( exec, args );
             break;

         case Constructor_QCheckListItem_3:
             return TQCheckListItem_3( exec, args );
             break;

         case Constructor_QCheckListItem_4:
             return TQCheckListItem_4( exec, args );
             break;

         case Constructor_QCheckListItem_5:
             return TQCheckListItem_5( exec, args );
             break;

         case Constructor_QCheckListItem_6:
             return TQCheckListItem_6( exec, args );
             break;

         case Constructor_QCheckListItem_7:
             return TQCheckListItem_7( exec, args );
             break;

         case Constructor_QCheckListItem_8:
             return TQCheckListItem_8( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCheckListItemCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCheckListItemImp::TQCheckListItem_1( KJS::ExecState *exec, const KJS::List &args )
{

    TQWidget *arg0 = extractTQWidget(exec,args,0);

    TQWidget *arg1 = extractTQWidget(exec,args,1);

    TQWidget *arg2 = extractTQWidget(exec,args,2);

    return KJS::Object(  );
}

KJS::Object TQCheckListItemImp::TQCheckListItem_2( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg3 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_3( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_4( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg3 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_5( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_6( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg3 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_7( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Object TQCheckListItemImp::TQCheckListItem_8( KJS::ExecState *exec, const KJS::List &args )
{

    // TODO
    TQWidget *arg0 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg1 = extractTQWidget(exec,args,0);

    // TODO
    TQWidget *arg2 = extractTQWidget(exec,args,0);
    return KJS::Object();

}

KJS::Value TQCheckListItemImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCheckListItemImp::toTQCheckListItem( self );

    switch( id ) {

    case Method_paintCell_10:
        return paintCell_10( exec, self, args );
        break;

    case Method_paintFocus_11:
        return paintFocus_11( exec, self, args );
        break;

    case Method_width_12:
        return width_12( exec, self, args );
        break;

    case Method_setup_13:
        return setup_13( exec, self, args );
        break;

    case Method_setOn_14:
        return setOn_14( exec, self, args );
        break;

    case Method_isOn_15:
        return isOn_15( exec, self, args );
        break;

    case Method_type_16:
        return type_16( exec, self, args );
        break;

    case Method_text_17:
        return text_17( exec, self, args );
        break;

    case Method_text_18:
        return text_18( exec, self, args );
        break;

    case Method_setTristate_19:
        return setTristate_19( exec, self, args );
        break;

    case Method_isTristate_20:
        return isTristate_20( exec, self, args );
        break;

    case Method_state_21:
        return state_21( exec, self, args );
        break;

    case Method_setState_22:
        return setState_22( exec, self, args );
        break;

    case Method_rtti_23:
        return rtti_23( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCheckListItemImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCheckListItemImp::paintCell_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQPainter *
    return KJS::Value();

    TQPainter * arg0; // Dummy

    // Unsupported parameter const TQColorGroup &
    return KJS::Value();
#if 0
    const TQColorGroup & arg1; // Dummy

    int arg2 = (args.size() >= 3) ? args[2].toInteger(exec) : -1;

    int arg3 = (args.size() >= 4) ? args[3].toInteger(exec) : -1;

    int arg4 = (args.size() >= 5) ? args[4].toInteger(exec) : -1;

      instance->paintCell(
       arg0,
       arg1,
       arg2,
       arg3,
       arg4 );
      return KJS::Value(); // Returns void
#endif
}

KJS::Value TQCheckListItemImp::paintFocus_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQPainter *
    return KJS::Value();
#if 0
    TQPainter * arg0; // Dummy

    // Unsupported parameter const TQColorGroup &
    return KJS::Value();

    const TQColorGroup & arg1; // Dummy

    TQRect arg2 = extractTQRect(exec, args, 2);

      instance->paintFocus(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void
#endif
}

KJS::Value TQCheckListItemImp::width_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter const TQFontMetrics &
    return KJS::Value();
#if 0
    const TQFontMetrics & arg0; // Dummy

    // Unsupported parameter const TQListView *
    return KJS::Value();

    const TQListView * arg1; // Dummy

    int arg2 = (args.size() >= 3) ? args[2].toInteger(exec) : -1;

      int ret;
      ret = instance->width(
       arg0,
       arg1,
       arg2 );
      return KJS::Number( ret );
#endif
}

KJS::Value TQCheckListItemImp::setup_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->setup(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQCheckListItemImp::setOn_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = (args.size() >= 1) ? args[0].toBoolean(exec) : false;

      instance->setOn(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCheckListItemImp::isOn_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isOn(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCheckListItemImp::type_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->type(  );
      return KJS::Value(); // Returns 'Type'

}

KJS::Value TQCheckListItemImp::text_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      TQString ret;
      ret = instance->text(  );
      return KJS::String( ret );

}

KJS::Value TQCheckListItemImp::text_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = (args.size() >= 1) ? args[0].toInteger(exec) : -1;

      TQString ret;
      ret = instance->text(
       arg0 );
      return KJS::String( ret );

}

KJS::Value TQCheckListItemImp::setTristate_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = (args.size() >= 1) ? args[0].toBoolean(exec) : false;

      instance->setTristate(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCheckListItemImp::isTristate_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isTristate(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCheckListItemImp::state_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->state(  );
      return KJS::Value(); // Returns 'ToggleState'

}

KJS::Value TQCheckListItemImp::setState_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter ToggleState
    return KJS::Value();
#if 0
    ToggleState arg0; // Dummy

      instance->setState(
       arg0 );
      return KJS::Value(); // Returns void
#endif
}

KJS::Value TQCheckListItemImp::rtti_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed
