// File autogenerated

// declaration include
#include "profilemanager1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{

ProfileManager1Proxy::ProfileManager1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.ProfileManager1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

ProfileManager1Proxy::~ProfileManager1Proxy()
{
    delete m_baseProxy;
}

void ProfileManager1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool ProfileManager1Proxy::RegisterProfile(const TQT_DBusObjectPath& profile, const TQString& UUID, const TQMap< TQString, TQT_DBusVariant >& options, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(profile);
    parameters << TQT_DBusData::fromString(UUID);
    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(options));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("RegisterProfile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool ProfileManager1Proxy::UnregisterProfile(const TQT_DBusObjectPath& profile, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(profile);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("UnregisterProfile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

}; // namespace bluez

}; // namespace org

#include "profilemanager1Proxy.moc"

// End of File

