// File autogenerated

// declaration include
#include "propertiesProxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace freedesktop
{
namespace DBus
{

PropertiesProxy::PropertiesProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.DBus.Properties");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

PropertiesProxy::~PropertiesProxy()
{
    delete m_baseProxy;
}

void PropertiesProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool PropertiesProxy::Get(const TQString& interface, const TQString& name, TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(interface);
    parameters << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Get", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    value = reply.front().toVariant(&ok);
    if (!ok) return false;

    return true;
}

bool PropertiesProxy::Set(const TQString& interface, const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(interface);
    parameters << TQT_DBusData::fromString(name);
    parameters << TQT_DBusData::fromVariant(value);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Set", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool PropertiesProxy::GetAll(const TQString& interface, TQMap< TQString, TQT_DBusVariant >& properties, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(interface);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetAll", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    bool subOK = false;

    properties = reply.front().toStringKeyMap(&ok).toVariantMap(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

void PropertiesProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQString _interface = message[0].toString();
        TQMap< TQString, TQT_DBusVariant > _changed_properties = message[1].toStringKeyMap().toVariantMap();
        TQStringList _invalidated_properties = message[2].toList().toTQStringList();

        emit PropertiesChanged(_interface, _changed_properties, _invalidated_properties);
    }
}

}; // namespace DBus

}; // namespace freedesktop

}; // namespace org

#include "propertiesProxy.moc"

// End of File

