// File autogenerated

// declaration include
#include "connectionsettings.h"

// TQt includes
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>


namespace DBus
{

ConnectionSettingsInterface::ConnectionSettingsInterface(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Settings.Connection");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

ConnectionSettingsInterface::~ConnectionSettingsInterface()
{
    delete m_baseProxy;
}

void ConnectionSettingsInterface::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool ConnectionSettingsInterface::UpdateAsync(int& asyncCallId, const TQT_DBusDataMap< TQString >& properties, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(properties);

    asyncCallId = m_baseProxy->sendWithAsyncReply("Update", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Update";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool ConnectionSettingsInterface::DeleteAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("Delete", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Delete";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool ConnectionSettingsInterface::GetSettingsAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("GetSettings", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "GetSettings";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool ConnectionSettingsInterface::GetSecretsAsync(int& asyncCallId, const TQString& setting_name, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(setting_name);

    asyncCallId = m_baseProxy->sendWithAsyncReply("GetSecrets", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "GetSecrets";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void ConnectionSettingsInterface::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "Updated")
    {

        emit Updated();
    }
    else if (message.member() == "Removed")
    {

        emit Removed();
    }
}

void ConnectionSettingsInterface::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "Update")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit UpdateAsyncReply(_asyncCallId);
    }
    else if (signalName == "Delete")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit DeleteAsyncReply(_asyncCallId);
    }
    else if (signalName == "GetSettings")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQT_DBusDataMap< TQString > _settings = message[0].toStringKeyMap();

        emit GetSettingsAsyncReply(_asyncCallId, _settings);
    }
    else if (signalName == "GetSecrets")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQT_DBusDataMap< TQString > _secrets = message[0].toStringKeyMap();

        emit GetSecretsAsyncReply(_asyncCallId, _secrets);
    }
}

}; // namespace DBus

#include "connectionsettings.moc"

// End of File

