// File autogenerated

// declaration include
#include "wimaxproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

WiMaxDeviceProxy::WiMaxDeviceProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Device.WiMax");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

WiMaxDeviceProxy::~WiMaxDeviceProxy()
{
    delete m_baseProxy;
}

void WiMaxDeviceProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool WiMaxDeviceProxy::GetNspList(TQValueList< TQT_DBusObjectPath >& nsps, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetNspList", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    bool subOK = false;

    nsps = reply.front().toList(&ok).toObjectPathList(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

void WiMaxDeviceProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant WiMaxDeviceProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString WiMaxDeviceProxy::getHwAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("HwAddress", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 WiMaxDeviceProxy::getCenterFrequency(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("CenterFrequency", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_INT32 WiMaxDeviceProxy::getRssi(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Rssi", error);

    if (error.isValid()) return TQ_INT32();

    bool ok = false;

    TQ_INT32 result =  variant.value.toInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_INT32 WiMaxDeviceProxy::getCinr(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Cinr", error);

    if (error.isValid()) return TQ_INT32();

    bool ok = false;

    TQ_INT32 result =  variant.value.toInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_INT32 WiMaxDeviceProxy::getTxPower(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("TxPower", error);

    if (error.isValid()) return TQ_INT32();

    bool ok = false;

    TQ_INT32 result =  variant.value.toInt32(&ok);
    if (!ok) {}

    return result;
}

TQString WiMaxDeviceProxy::getBsid(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Bsid", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath WiMaxDeviceProxy::getActiveNsp(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ActiveNsp", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

void WiMaxDeviceProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
    else if (message.member() == "NspAdded")
    {
        TQT_DBusObjectPath _nsp = message[0].toObjectPath();

        emit NspAdded(_nsp);
    }
    else if (message.member() == "NspRemoved")
    {
        TQT_DBusObjectPath _nsp = message[0].toObjectPath();

        emit NspRemoved(_nsp);
    }
}

}; // namespace DBus

#include "wimaxproxy.moc"

// End of File

