/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco@Paganini                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KONQUERORSIDEBAR_H
#define KONQUERORSIDEBAR_H

#include <tdehtml_part.h>
#include <konqsidebarplugin.h>
#include <dcopclient.h>
#include <tqslider.h>
#include <tqvbox.h>
#include <tdehtmlview.h>
#include <kurl.h>
#include "amarokdcopiface_stub.h"

/**
@author Marco Gulino
*/

class universalamarokwidget;
class DCOPClient;
class TQFileInfo;
class TQDateTime;

class amarokWidget : public TQVBox
{
TQ_OBJECT
  
public:
    amarokWidget( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );

protected:
    virtual void dragEnterEvent ( TQDragEnterEvent * );
    virtual void dropEvent(TQDropEvent*);
    bool eventFilter( TQObject *o, TQEvent *e );

signals:
    void emitURL( const KURL &);
};


class UniversalAmarok : public KonqSidebarPlugin
{
TQ_OBJECT
  
public:
    UniversalAmarok(TDEInstance *inst,TQObject *parent,TQWidget *widgetParent, TQString &desktopName, const char* name=0);

    ~UniversalAmarok();

   virtual TQWidget *getWidget(){return (TQWidget*)widget;}
   virtual void *provides(const TQString &) {return 0;}
   virtual void handleURL(const KURL& /*url*/) {}
   TQString getCurrentPlaying();
   void showIntroduction();

private:
   amarokWidget* widget;
   TDEHTMLPart* browser;
   TQString amarokPlaying;
   DCOPClient* amarokDCOP;
   TQFileInfo* fileInfo;
   TQDateTime fileDT;
   TQSlider* vol_slider;
   AmarokPlayerInterface_stub *playerStub;
   AmarokPlaylistInterface_stub *playlistStub;
   AmarokContextBrowserInterface_stub *contextStub;

public slots:
    void updateBrowser(const TQString&);
    void updateStatus();
    void sendPrev() { checkForAmarok(); playerStub->prev(); }
    void sendPlay() { checkForAmarok(); playerStub->play(); }
    void sendPause() { checkForAmarok(); playerStub->pause(); }
    void sendStop() { checkForAmarok(); playerStub->stop(); }
    void sendNext() { checkForAmarok(); playerStub->next(); }
    void sendMute() { checkForAmarok(); playerStub->mute(); }
    void volChanged(int vol);
    void openURLRequest( const KURL & );
    void checkForAmarok();
    void noAmarokRunning();
    void runAmarok();
    void lyrics() { contextStub->showLyrics(); }
    void currentTrack() { contextStub->showCurrentTrack(); }
    void wiki() { contextStub->showWiki(); }
};

#endif
