/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-05-20
 * Description : search results item.
 * 
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqpainter.h>
#include <tqpixmap.h>

// Local includes.

#include "searchresultsitem.h"

namespace Digikam
{

TQPixmap* SearchResultsItem::m_basePixmap = 0;

SearchResultsItem::SearchResultsItem(TQIconView* view, const TQString& path)
    : TQIconViewItem(view), m_path(path)
{
    if (!m_basePixmap)
    {
        m_basePixmap = new TQPixmap(128, 128);
        m_basePixmap->fill(view->colorGroup().base());

        TQPainter p(m_basePixmap);
        p.setPen(TQt::lightGray);
        p.drawRect(0, 0, 128, 128);
        p.end();
    }

    setPixmap(*m_basePixmap);
    calcRect();
    m_marked = true;
}

SearchResultsItem::~SearchResultsItem()
{
    
}

void SearchResultsItem::calcRect(const TQString&)
{
    TQRect r(0,0,0,0);
    setTextRect(r);
    setPixmapRect(r);
    setItemRect(TQRect(x(),y(),130,130));
}

void SearchResultsItem::paintItem(TQPainter* p, const TQColorGroup&)
{
    TQRect r(rect());
    p->drawPixmap(r.x() + (width()-pixmap()->width())/2 ,
                  r.y() + (height()-pixmap()->height())/2,
                  *pixmap());
}

void SearchResultsItem::paintFocus(TQPainter* p, const TQColorGroup&)
{
    TQRect r(rect());
    p->save();
    p->setPen(TQPen(TQt::darkGray, 0, TQt::DotLine));
    p->drawRect(rect());
    p->restore();
}

}  // namespace Digikam
