############################################
#                                          #
#  Improvements and feedbacks are welcome  #
#                                          #
#  This file is released under GPL >= 3    #
#                                          #
############################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for X11

find_package( X11 )


##### check for dvb header

if( WITH_DVB )
    check_include_file( "linux/dvb/frontend.h" HAVE_DVB )
    if( NOT HAVE_DVB )
        tde_message_fatal( "dvb support has been requested but no dvb headers were found on your system." )
    endif()
    set( KAFFEINE_DVB_LIBRARY kaffeinedvb-static )
endif()


##### check for libcdio vs cdparanoia

pkg_search_module( CDIO_CDDA     libcdio_cdda     )
pkg_search_module( CDIO_PARANOIA libcdio_paranoia )
check_include_file( "cdio/paranoia/cdda.h" HAVE_LIBCDIO_090 )
check_include_file( "cdio/cdda.h"          HAVE_CDPARANOIA  )

if( (NOT HAVE_LIBCDIO_090) AND (NOT HAVE_CDPARANOIA) )
    tde_message_fatal( "libcdio >= 0.90 or cdparanoia are required but were not found on your system." )
endif()


##### check for xinelib

pkg_search_module( XINE libxine )
if( XINE_FOUND )
    set( HAVE_XINE 1 )
    if( ${XINE_VERSION} VERSION_GREATER "1.1.0" )
        set( XINE_PARAM_GAPLESS_SWITCH 1 )
        set( XINE_PARAM_EARLY_FINISHED_EVENT 1 )
    endif()
 else()
    tde_message_fatal( "Xine support has been requested but libxine was not found on your system." )
endif()


##### check for xinerama

if( WITH_XINERAMA )
    if( X11_Xinerama_FOUND )
        set( HAVE_XINERAMA 1)
     else()
        tde_message_fatal( "Xinerama support has been requested but was not found on your system." )
    endif()
endif( WITH_XINERAMA )


##### check for xcb

if( WITH_XCB )
    pkg_search_module( XCB xcb )

    if( XCB_FOUND )
        set( HAVE_XCB 1 )
     else()
        tde_message_fatal( "Xcb support has been requested but was not found on your system." )
    endif()
endif( WITH_XCB )


##### check for dpms(X11)

if( WITH_DPMS )
    if( X11_dpms_FOUND )
        set( HAVE_DPMS 1 )
     else()
        tde_message_fatal( "Dpms support has been requested but was not found on your system." )
    endif()
endif( WITH_DPMS )


##### check for XTest

if( WITH_XTEST )
    if( X11_XTest_FOUND )
        set( HAVE_XTEST 1 )
     else()
        tde_message_fatal( "XTest support has been requested but was not found on your system." )
    endif()
endif( WITH_XTEST )


##### check for gstreamer

if( WITH_GSTREAMER )
    pkg_search_module( GST gstreamer-1.0>=1.0.0 gstreamer-0.10>=0.10.0 )
    if( NOT GST_FOUND )
        tde_message_fatal( "gstreamer support has been requested but neither gstreamer-1.0 or gstreamer-0.10 were found on your system." )
    endif()

    if( ${GST_VERSION} GREATER "0.11.0" )
        pkg_search_module( GSTREAMER_VIDEO gstreamer-video-1.0 )
        pkg_search_module( GSTREAMER_PLUGIN gstreamer-plugins-base-1.0 )
     else()
        pkg_search_module( GSTREAMER_VIDEO gstreamer-interfaces-0.10 )
        pkg_search_module( GSTREAMER_PLUGIN gstreamer-plugins-base-0.10 )
    endif()

    message( STATUS "gstreamer version: ${GST_VERSION}" )
    message( STATUS "gstreamer video version: ${GSTREAMER_VIDEO_VERSION}" )
    message( STATUS "gstreamer plugins version: ${GSTREAMER_PLUGIN_VERSION}" )
endif( WITH_GSTREAMER )


##### check for lame

if( WITH_LAME )
    find_path( LAME_INCLUDE_DIR "lame/lame.h" )
    find_library( LAME_LIBRARIES mp3lame )
    message( STATUS "Found Lame includes directory: ${LAME_INCLUDE_DIR}" )
    
    if( NOT LAME_INCLUDE_DIR OR NOT LAME_LIBRARIES )
        tde_message_fatal( "Lame support has been requested but lame was not found on your system." )
    endif()
endif( WITH_LAME )


##### check for ogg and vorbis

if( WITH_OGGVORBIS )
    pkg_search_module( OGG ogg )
    pkg_search_module( VORBIS vorbis )
    pkg_search_module( VORBISENC vorbisenc )

    if( (NOT VORBISENC_FOUND) OR (NOT OGG_FOUND) )
        tde_message_fatal( "oggvorbis support has been requested but neither ogg or vorbis were not found on your system" )
    endif()
endif( WITH_OGGVORBIS )


##### tqt support only

if( USE_TQT_ONLY )
    set( USE_TQT_ONLY 1 )
endif()


##### xinit workaround

if( WITH_XINIT_WORKAROUND )
    set( XINIT_WKRND 1 )
endif()
