/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef COVERIMAGE_H
#define COVERIMAGE_H

#include<tqstring.h>
#include<tqimage.h>

/**
@author Bastian Holst
*/
class CoverImage 
{
public:
	CoverImage();
	
	TQImage load(int) const;
	
	virtual TQString artist() const;
	virtual TQString album() const;
	virtual TQString url() const;
	
	void setArtist(const TQString&);
	void setAlbum(const TQString&);
	void setURL(const TQString&);
private:
	TQString _artist;
	TQString _album;
	TQString _url;
	
	TQString _coverfolder;
	TQString _largefolder;
	TQString _cachefolder;
};

#endif // COVERIMAGE_H

