/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXMERGEELEMENTS_H
#define KBIBTEXMERGEELEMENTS_H

#include <kdialogbase.h>

#include "findduplicates.h"
#include "file.h"
#include "entry.h"

class KPushButton;
class KTextEdit;
class TDEListView;
class TQProgressBar;

namespace KBibTeX
{
    class MergeElementsCliqueItem : public TQObject, public TQCheckListItem
    {
        TQ_OBJECT
    public:
        MergeElementsCliqueItem( BibTeX::Entry* entry, BibTeX::Macro* macro, BibTeX::Preamble* preamble, TQListView *parent );
        BibTeX::Entry* entry;
        BibTeX::Macro* macro;
        BibTeX::Preamble* preamble;

    protected:
        void stateChange( bool );

    signals:
        void stateChanged( MergeElementsCliqueItem* );
    };

    class MergeEntriesAlternativesController: public TQCheckListItem
    {
    public:
        MergeEntriesAlternativesController( const TQString &label, TQListView *parent );
        MergeEntriesAlternativesController( BibTeX::EntryField::FieldType fieldType, TQListView *parent );
        BibTeX::EntryField::FieldType fieldType;
        const TQString fieldName;
    };

    class MergeMacrosAlternativesController: public TQCheckListItem
    {
    public:
        MergeMacrosAlternativesController( bool isKey, TQListView *parent );
    };


    class MergeEntriesAlternativesItem: public TQCheckListItem
    {
    public:
        MergeEntriesAlternativesItem( BibTeX::EntryField *field, MergeEntriesAlternativesController *parent );
        BibTeX::EntryField *field;
    };

    class MergeMacrosAlternativesItem: public TQCheckListItem
    {
    public:
        MergeMacrosAlternativesItem( BibTeX::Value *value, MergeMacrosAlternativesController *parent );
        BibTeX::Value *value;
    };

    class MergeElementsAlternativesId: public TQCheckListItem
    {
    public:
        MergeElementsAlternativesId( const TQString &id, MergeEntriesAlternativesController *parent );
        TQString id;
    };

    class MergeMacroAlternativesKey: public TQCheckListItem
    {
    public:
        MergeMacroAlternativesKey( const TQString &key, MergeMacrosAlternativesController *parent );
        TQString key;
    };


    class MergeEntriesAlternativesEntryType: public TQCheckListItem
    {
    public:
        MergeEntriesAlternativesEntryType( const TQString &typeString, MergeEntriesAlternativesController *parent );
        MergeEntriesAlternativesEntryType( BibTeX::Entry::EntryType type, MergeEntriesAlternativesController *parent );
        TQString typeString;
        BibTeX::Entry::EntryType type;
    };

    class MergePreambleAlternativesController: public TQCheckListItem
    {
    public:
        MergePreambleAlternativesController( TQListView *parent );
    };

    class MergePreambleAlternatives: public TQCheckListItem
    {
    public:
        MergePreambleAlternatives( const TQString &text, MergePreambleAlternativesController *parent );
        TQString text;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class MergeElements : public KDialogBase
    {
        TQ_OBJECT
    public:
        MergeElements( TQWidget *parent );
        ~MergeElements();
        int mergeDuplicates( BibTeX::File *bibTeXFile );

    protected:
        void showEvent( TQShowEvent * );

    protected slots:
        void slotRefreshAlternatives();
        void slotNextClique();
        void slotPreviousClique();
        void slotPreviewElement( TQListViewItem *item );
        void saveCurrentMergeSet();
        void slotRestore();

    private:
        typedef struct
        {
            BibTeX::Macro *macro;
            BibTeX::Entry *entry;
            BibTeX::EntryField *field;
        } First;

        typedef struct
        {
            TQValueList<BibTeX::Macro*> macros;
            TQValueList<BibTeX::Entry*> entries;
            TQValueList<BibTeX::EntryField*> fields;
            TQValueList<BibTeX::Preamble*> preambles;
            TQString macroKey;
            BibTeX::Value *macroValue;
            TQString id, typeString;
            BibTeX::Entry::EntryType type;
            TQString preambleText;
        } MergeSet;

        TDEListView *m_listViewClique;
        TDEListView *m_listViewAlternatives;
        TQProgressBar *m_progressBar;
        FindDuplicates::DuplicateCliqueList m_duplicateCliqueList;
        MergeSet **m_mergeSetList;
        int m_currentCliqueIndex;

        void setupGUI();
        void setClique( int cliqueIndex );
        void restoreCurrentMergeSet();
        void applyMergeSet( BibTeX::File *bibTeXFile, BibTeX::File *otherBibTeXFile = NULL );
        void restoreWindowSize( TDEConfig *config );
        void saveWindowSize( TDEConfig *config ) const;
    };

}

#endif // KBIBTEXMERGEELEMENTS_H
