/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef PREFMISC_H
#define PREFMISC_H

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>

class PrefMisc : public TQWidget
{
public:
    PrefMisc(TQWidget* parent);

    TQGridLayout m_grid;

protected:
    TQCheckBox m_popForeground;

    TQLabel m_backTimeoutLabel;
    TQLineEdit m_backTimeout;

    TQLabel m_tabWidthLabel;
    TQLineEdit m_tabWidth;

    TQLabel m_sourceFilterLabel;
    TQLineEdit m_sourceFilter;
    TQLabel m_headerFilterLabel;
    TQLineEdit m_headerFilter;

    void setupEditGroup(const TQString& label, TQLabel& labWidget, TQLineEdit& edit, int row);

public:
    bool popIntoForeground() const { return m_popForeground.isChecked(); }
    void setPopIntoForeground(bool pop) { m_popForeground.setChecked(pop); }
    int backTimeout() const;
    void setBackTimeout(int to);
    int tabWidth() const;
    void setTabWidth(int tw);
    TQString sourceFilter() const { return m_sourceFilter.text(); }
    void setSourceFilter(const TQString& f) { m_sourceFilter.setText(f); }
    TQString headerFilter() const { return m_headerFilter.text(); }
    void setHeaderFilter(const TQString& f) { m_headerFilter.setText(f); }
};

#endif // PREFMISC_H
