/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2006-05-16
 * Description : a tool to export GPS data to KML file.
 *
 * Copyright (C) 2006-2007 by Stephane Pontier <shadow dot walker at free dot fr>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef KIPIGPSSYNCPLUGINKMLGPSDATAPARSER_H
#define KIPIGPSSYNCPLUGINKMLGPSDATAPARSER_H

// Local includes.

#include "gpsdataparser.h"

// TQt includes.

#include <tqdom.h>

namespace KIPIGPSSyncPlugin 
{

/*! a classe derivated from GPSDataParser mainly to transform GPS data to KML
 *  @author Stéphane Pontier shadow.walker@free.fr
 */
class KMLGPSDataParser : public GPSDataParser
{

public:

    KMLGPSDataParser();
    ~KMLGPSDataParser();

    /*! KIPIGPSSyncPlugin::KMLGPSDataParser::lineString()
     *  @return the string containing the time ordered point (lon,lat,alt)
     */
    TQString lineString();
    /*! Create a KML Element that will contain the linetrace of the GPS
     *  @param parent the TQDomElement to which the track will be added
     *  @param root the TQDomDocument used to create all elements
     *  @param altitudeMode altitude mode of the line and points
     */

    void CreateTrackLine(TQDomElement &parent, TQDomDocument &root, int altitudeMode);
    /*! Create a KML Element that will contain the points and of the GPS
     *  @param parent the TQDomElement to which the track will be added
     *  @param root the TQDomDocument used to create all elements
     *  @param timeZone the Timezone of the pictures
     *  @param altitudeMode altitude mode of the line and points
     */
    void CreateTrackPoints(TQDomElement &parent, TQDomDocument &root, int timeZone, int altitudeMode);

private:

    /*! @todo maybe initialize it in the constructor */
    /*! the root document, used to create all TQDomElements */
    TQDomDocument *kmlDocument;

    /*!
    \fn TQDomElement KIPIGPSSyncPlugin::KMLGPSDataParser::addKmlElement(TQDomElement target, TQString tag)
     *  Add a new element
     *  @param target the parent element to which add the element
     *  @param tag the new element name
     *  @return the New element
     */
    TQDomElement addKmlElement(TQDomElement &target, TQString tag)
    {
        TQDomElement kmlElement = kmlDocument->createElement( tag );
        target.appendChild( kmlElement );
        return kmlElement;
    }

    /*!
    \fn TQDomElement KIPIGPSSyncPlugin::KMLGPSDataParser::addKmlTextElement(TQDomElement target, TQString tag, TQString text)
     *  Add a new element with a text
     *  @param target the parent element to which add the element
     *  @param tag the new element name
     *  @param text the text content of the new element
     *  @return the New element
     */
    TQDomElement addKmlTextElement(TQDomElement &target, TQString tag, TQString text)
    {
        TQDomElement kmlElement = kmlDocument->createElement( tag );
        target.appendChild( kmlElement );
        TQDomText kmlTextElement = kmlDocument->createTextNode( text );
        kmlElement.appendChild( kmlTextElement );
        return kmlElement;
    }
};

} // namespace KIPIGPSSyncPlugin 

#endif // KIPIGPSSYNCPLUGINKMLGPSDATAPARSER_H
