/* ============================================================
 * File  : gpfileitemcontainer.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-02-21
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPFILEITEMCONTAINER_H
#define GPFILEITEMCONTAINER_H

#include <tqobject.h>
#include <tqdict.h>
#include <tqptrlist.h>

#include "gpfileiteminfo.h"


class TQString;

namespace KIPIKameraKlientPlugin
{

class CameraFolderItem;
class CameraFolderView;
class CameraIconView;
class CameraIconItem;

class GPFileItemContainer : public TQObject {
    TQ_OBJECT
  

public:
    GPFileItemContainer(TQObject *parent, CameraFolderView *folderView, CameraIconView   *iconView);
    ~GPFileItemContainer();

    void addVirtualFolder(const TQString& title);
    void addRootFolder(const TQString& folder);
    void addFolder(const TQString& folder, const TQString& subfolder);

    void addFiles(const TQString& folder, const GPFileItemInfoList& infoList);
    void addFiles(const GPFileItemInfoList& infoList);
    void addFile(const TQString& folder, const GPFileItemInfo& info);

    void delFile(const TQString& folder, const TQString& name);

    CameraIconItem* findItem(const TQString& folder, const TQString& name);

    TQPtrList<GPFileItemInfo> allFiles();
    
private:
    typedef TQDict<GPFileItemInfo>  GPFileDict;
    typedef TQDictIterator<GPFileItemInfo> GPFileDictIterator;
    
    class GPFolder {
    public:
        GPFolder() {
            viewItem = 0;
            fileDict = new GPFileDict(307);
            fileDict->setAutoDelete(true);
        }

        ~GPFolder() {
            if (fileDict)
                delete fileDict;
        }
        
        GPFileDict        *fileDict;
        CameraFolderItem  *viewItem;
    };
    
    typedef TQDict<GPFolder>  GPFolderDict;
    typedef TQDictIterator<GPFolder> GPFolderDictIterator;
    
    GPFolderDict      folderDict_;
    CameraFolderView *folderView_;
    CameraIconView   *iconView_;

private slots:
    void slotFolderViewCleared();
    void slotIconViewCleared();
};

}  // NameSpace KIPIKameraKlientPlugin

#endif /* GPFILEITEMCONTAINER_H */
