/* ============================================================
 * File  : gpfileiteminfodlg.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-02-19
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * Update : 09/23/2003 - Gilles Caulier <caulier.gilles@free.fr>
 *          Improve i18n messages.

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <tqpixmap.h>
#include <tqstring.h>
#include <tqlayout.h>
#include <tqlabel.h>

#include <kiconloader.h>
#include <tdelocale.h>
#include <kseparator.h>

#include "gpfileiteminfo.h"
#include "gpfileiteminfodlg.h"

namespace KIPIKameraKlientPlugin
{

GPFileItemInfoDlg::GPFileItemInfoDlg(const GPFileItemInfo& info,
                                     TQPixmap *pixmap )
    : KDialogBase(0L, "GPFileItemInfoDlg", true,
                  info.name,
                  Ok, Ok, true)
{
    TQWidget *page = new TQWidget( this );
    setMainWidget( page );

    TQGridLayout *grid = new TQGridLayout( page, 1, 1, 5, 5);

    // -----------------------------------------------------

    TQLabel *thumbLabel = new TQLabel( page );
    thumbLabel->setFrameShape(TQFrame::Box);
    thumbLabel->setMargin(2);
    thumbLabel->setPaletteBackgroundColor(colorGroup().base());
    if (!pixmap) {
        if (info.mime.contains("image"))
            thumbLabel->setPixmap(DesktopIcon("image-x-generic"));
        else if (info.mime.contains("audio"))
            thumbLabel->setPixmap(DesktopIcon("audio"));
        else if (info.mime.contains("video"))
            thumbLabel->setPixmap(DesktopIcon("video-x-generic"));
        else
            thumbLabel->setPixmap(DesktopIcon("text-x-generic"));
    }
    else
        thumbLabel->setPixmap(*pixmap);

    grid->addWidget( thumbLabel, 0, 0);

    // ----------------------------------------------------

    TQLabel *nameLabel = new TQLabel( page );
    nameLabel->setText(info.name);

    grid->addWidget( nameLabel, 0, 2);

    // ----------------------------------------------------

    KSeparator *sep = new KSeparator( KSeparator::HLine, page );
    grid->addMultiCellWidget( sep, 1, 1, 0, 2);

    // ----------------------------------------------------

    TQLabel *l = 0;
    int currRow = 2;
    TQString value;

    l = new TQLabel(i18n("MimeType:"), page);
    grid->addWidget(l, currRow,  0);
    value = info.mime.isNull() ? i18n("Unknown") : info.mime;
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Date:"), page);
    grid->addWidget(l, currRow,  0);
    value = info.time.isNull() ? i18n("Unknown") : info.time;
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Size:"), page);
    grid->addWidget(l, currRow,  0);
    value = info.size <= 0 ? i18n("Unknown") : TQString::number(info.size);
    value += i18n( " bytes" );
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Width:"), page);
    grid->addWidget(l, currRow,  0);
    value = info.width <= 0 ? i18n("Unknown") : TQString::number(info.width);
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);


    l = new TQLabel(i18n("Height:"), page);
    grid->addWidget(l, currRow,  0);
    value = info.height <= 0 ? i18n("Unknown") : TQString::number(info.height);
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Read permissions:"), page);
    grid->addWidget(l, currRow,  0);
    if (info.readPermissions == 0)
        value = i18n("No");
    else if (info.readPermissions == 1)
        value = i18n("Yes");
    else
        value = i18n("Unknown");
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Write permissions:"), page);
    grid->addWidget(l, currRow,  0);
    if (info.writePermissions == 0)
        value = i18n("No");
    else if (info.writePermissions == 1)
        value = i18n("Yes");
    else
        value = i18n("Unknown");
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);

    l = new TQLabel(i18n("Downloaded:"), page);
    grid->addWidget(l, currRow,  0);
    if (info.downloaded == 0)
        value = i18n("No");
    else if (info.downloaded == 1)
        value = i18n("Yes");
    else
        value = i18n("Unknown");
    l = new TQLabel(value, page);
    grid->addWidget(l, currRow++, 2);


}

GPFileItemInfoDlg::~GPFileItemInfoDlg()
{

}

}  // NameSpace KIPIKameraKlientPlugin
