/***************************************************************************
                          dlg_challenge.cpp  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqregexp.h>
#include "dlg_challenge.moc"

dlg_challenge::dlg_challenge(TQWidget *parent, const char *name, resource *Rsrc ) :
	KDialogBase(	parent,
								name,
								false,
								i18n("You've Been Challenged:"),
								User1|User2,
								Ok,
								true,
								i18n("Accept"),
								i18n("Decline") )
{
	Resource = Rsrc;

	BOX_Parent = makeVBoxMainWidget();

	LABEL_Headline = new TQLabel( BOX_Parent );
	COMBO_Rated = new KComboBox( BOX_Parent );
	BOX_Time = new TQHBox( BOX_Parent );
		BOX_White = new TQGroupBox( 2, TQt::Horizontal, "-", BOX_Time );
			BOX_WhiteBase = new TQSpinBox( BOX_White );
			LABEL_WhiteBase = new TQLabel( BOX_White );
			BOX_WhiteInc = new TQSpinBox( BOX_White );
			LABEL_WhiteInc = new TQLabel( BOX_White );
		BOX_Black = new TQGroupBox( 2, TQt::Horizontal, "-", BOX_Time );
			BOX_BlackBase = new TQSpinBox( BOX_Black );
			LABEL_BlackBase = new TQLabel( BOX_Black );
			BOX_BlackInc = new TQSpinBox( BOX_Black );
			LABEL_BlackInc = new TQLabel( BOX_Black );
	BUTTON_TimeOdds = new TQCheckBox( i18n("Time Odds Match"),BOX_Parent );

	LABEL_Headline->setAlignment( TQt::AlignCenter );
	COMBO_Rated->setEditable( false );
	COMBO_Rated->insertItem( i18n("Unrated"), 0 );
	COMBO_Rated->insertItem( i18n("Rated"), 1 );

	BOX_WhiteBase->setMinValue( 0 );
	BOX_WhiteInc->setMinValue( 0 );
	BOX_WhiteBase->setMaxValue( 300 );
	BOX_WhiteInc->setMaxValue( 300 );
	BOX_WhiteBase->setSuffix( i18n(" min.") );
	BOX_WhiteInc->setSuffix( i18n(" sec.") );
	LABEL_WhiteBase->setText( i18n( "Base Time" ) );
	LABEL_WhiteInc->setText( i18n( "Increment" ) );

	BOX_BlackBase->setMinValue( 0 );
	BOX_BlackInc->setMinValue( 0 );
	BOX_BlackBase->setMaxValue( 300 );
	BOX_BlackInc->setMaxValue( 300 );
	BOX_BlackBase->setSuffix( i18n(" min.") );
	BOX_BlackInc->setSuffix( i18n(" sec.") );
	LABEL_BlackBase->setText( i18n( "Base Time" ) );
	LABEL_BlackInc->setText( i18n( "Increment" ) );

	showButton( User1, true );
	showButton( User2, true );
	enableButton( User1, true );
	enableButton( User2, true );
	show();
}

dlg_challenge::~dlg_challenge()
{
}

void dlg_challenge::setValues( const TQString &string, const TQString &local )
{
	/* we only need the first line, strip the rest */
	TQString myString( string.section('\n', 0, 0) );
	TQStringList list;

	/*remove all the white space between the rating brackets*/
	myString.replace( TQRegExp("\\(\\s"), "(" );
	myString.replace( TQRegExp("\\s\\)"), ")" );
	
	list = TQStringList::split( TQChar(' '), myString, false );
	list[7].replace(TQRegExp("\\."), "");
	if( list[0] == local )
	{
		localRating = list[1];
		otherPlayer = list[2];
		otherRating = list[3];
	}
	else
	{
		otherPlayer = list[0];
		otherRating = list[1];
		localRating = list[3];
	}
	LABEL_Headline->setText( i18n("%1 %2 vs. %3 %4\nin a %5 match.")
		.arg(local).arg(localRating).arg(otherPlayer).arg(otherRating).arg(list[5]) );
	if( list[4].lower() == "rated" )
	{	
		COMBO_Rated->setCurrentItem(1);
	}
	else
	{
		COMBO_Rated->setCurrentItem(0);
	}
	BOX_WhiteBase->setValue( list[6].toInt() );
	BOX_WhiteInc->setValue( list[7].toInt() );
	BOX_BlackBase->setValue( list[6].toInt() );
	BOX_BlackInc->setValue( list[7].toInt() );
	BOX_White->setTitle( i18n("Time Controls") );
	BOX_Black->setTitle( i18n("Time Controls") );
//	BOX_Black->setEnabled( false );
//	BUTTON_TimeOdds->setChecked( false );

	connect( COMBO_Rated, TQ_SIGNAL( activated(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BOX_WhiteBase, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BOX_WhiteInc, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BOX_BlackBase, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BOX_BlackInc, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BUTTON_TimeOdds, TQ_SIGNAL( stateChanged(int) ), this, TQ_SLOT( slot_changed(int) ) );
	connect( BUTTON_TimeOdds, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( slot_timeOdds(bool) ) );
}

TQString dlg_challenge::values( void )
{
	TQString match;
	match = TQString("match %1").arg(otherPlayer);
	if( COMBO_Rated->currentItem() == 0 )
		match += " unrated";
	else
		match += " rated";
	match += TQString(" %1 %1").arg(BOX_WhiteBase->value()).arg(BOX_WhiteInc->value());
	if( BUTTON_TimeOdds->isChecked() )
		match += TQString(" %1 %1").arg(BOX_BlackBase->value()).arg(BOX_BlackInc->value());
	return match;
}

void dlg_challenge::slot_changed( int )
{
	setButtonText( User1, i18n("Counter Offer") );
}

void dlg_challenge::slot_timeOdds( bool state )
{
	BOX_Black->setEnabled( state );
}
