/*
 *  kis_factory.cpp - part of Krayon
 *
 *  Copyright (c) 1999 Matthias Elter <elter@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <config.h>
#include LCMS_HEADER

#include <tqstringlist.h>
#include <tqdir.h>

#include <kdebug.h>
#include <tdeinstance.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <kiconloader.h>

#include "kis_aboutdata.h"
#include "kis_resourceserver.h"
#include "kis_paintop_registry.h"
#include "kis_filter_registry.h"
#include "kis_tool_registry.h"
#include "kis_doc.h"
#include "kis_brush.h"
#include "kis_imagepipe_brush.h"
#include "kis_gradient.h"
#include "kis_pattern.h"
#include "kis_palette.h"
#include <kogradientmanager.h>

#include "kis_factory.h"

TDEAboutData* KisFactory::s_aboutData = 0;
TDEInstance* KisFactory::s_instance = 0;



KisFactory::KisFactory( TQObject* parent, const char* name )
    : KoFactory( parent, name )
{
    s_aboutData = newChalkAboutData();

    (void)instance();

    // Load extension modules and plugins
    KisToolRegistry::instance();
    KisPaintOpRegistry::instance();
    KisFilterRegistry::instance();
    KisResourceServerRegistry::instance();



}

KisFactory::~KisFactory()
{
    delete s_aboutData;
    s_aboutData = 0L;
    delete s_instance;
    s_instance = 0L;
}

/**
 * Create the document
 */
KParts::Part* KisFactory::createPartObject( TQWidget *parentWidget,
                        const char *widgetName, TQObject* parent,
                        const char* name, const char* classname, const TQStringList & )
{
    bool bWantKoDocument = ( strcmp( classname, "KoDocument" ) == 0 );

    KisDoc *doc = new KisDoc( parentWidget,
                  widgetName, parent, name, !bWantKoDocument );
    TQ_CHECK_PTR(doc);

    if ( !bWantKoDocument )
        doc->setReadWrite( false );

    return doc;
}


TDEAboutData* KisFactory::aboutData()
{
    return s_aboutData;
}

TDEInstance* KisFactory::instance()
{
    TQString homedir = getenv("HOME");
    
    if ( !s_instance )
    {
        s_instance = new TDEInstance(s_aboutData);
        TQ_CHECK_PTR(s_instance);

        s_instance->dirs()->addResourceType("chalk_template", TDEStandardDirs::kde_default("data") + "chalk/templates");

        // XXX: Are these obsolete?
        s_instance->dirs()->addResourceType("kis", TDEStandardDirs::kde_default("data") + "chalk/");

        s_instance->dirs()->addResourceType("kis_pics", TDEStandardDirs::kde_default("data") + "chalk/pics/");

        s_instance->dirs()->addResourceType("kis_images", TDEStandardDirs::kde_default("data") + "chalk/images/");

        s_instance->dirs()->addResourceType("toolbars", TDEStandardDirs::kde_default("data") + "koffice/toolbar/");

        // Create spec

        s_instance->dirs()->addResourceType("kis_brushes", TDEStandardDirs::kde_default("data") + "chalk/brushes/");
        s_instance->dirs()->addResourceDir("kis_brushes", "/usr/share/create/brushes/gimp");
        s_instance->dirs()->addResourceDir("kis_brushes", TQDir::homeDirPath() + TQString("/.create/brushes/gimp"));
    
        s_instance->dirs()->addResourceType("kis_patterns", TDEStandardDirs::kde_default("data") + "chalk/patterns/");
        s_instance->dirs()->addResourceDir("kis_patterns", "/usr/share/create/patterns/gimp");
        s_instance->dirs()->addResourceDir("kis_patterns", TQDir::homeDirPath() + TQString("/.create/patterns/gimp"));

        s_instance->dirs()->addResourceType("kis_gradients", TDEStandardDirs::kde_default("data") + "chalk/gradients/");
        s_instance->dirs()->addResourceDir("kis_gradients", "/usr/share/create/gradients/gimp");
        s_instance->dirs()->addResourceDir("kis_gradients", TQDir::homeDirPath() + TQString("/.create/gradients/gimp"));
 
        s_instance->dirs()->addResourceType("kis_profiles", TDEStandardDirs::kde_default("data") + "chalk/profiles/");
        s_instance->dirs()->addResourceDir("kis_profiles", "/usr/share/color/icc");
        s_instance->dirs()->addResourceDir("kis_profiles", TQDir::homeDirPath() + TQString("/.icc"));
        s_instance->dirs()->addResourceDir("kis_profiles", TQDir::homeDirPath() + TQString("/.color/icc"));

        s_instance->dirs()->addResourceType("kis_palettes", TDEStandardDirs::kde_default("data") + "chalk/palettes/");
        s_instance->dirs()->addResourceDir("kis_palettes", "/usr/share/create/swatches");
        s_instance->dirs()->addResourceDir("kis_palettes", TQDir::homeDirPath() + TQString("/.create/swatches"));

        // Tell the iconloader about share/apps/koffice/icons
        s_instance->iconLoader()->addAppDir("koffice");
    }

    return s_instance;
}

#include "kis_factory.moc"
