/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_BASE_TARGET_STENCIL_H
#define KIVIO_BASE_TARGET_STENCIL_H

#include <tqfont.h>
#include <tqcolor.h>
#include <tqdom.h>
#include <tqptrlist.h>

class KivioCustomDragData;
class KivioConnectorPoint;
class KivioConnectorTarget;
class KivioFillStyle;
class KivioIntraStencilData;
class KivioLineStyle;
class KivioPage;
class KivioStencilSpawner;
class KivioTextStyle;

#include "kivio_stencil.h"


class KivioBaseTargetStencil : public KivioStencil
{
protected:
    KivioLineStyle *m_pLineStyle;
    KivioFillStyle *m_pFillStyle;
    KivioTextStyle *m_pTextStyle;

    TQPtrList<KivioConnectorTarget> *m_pTargets;

    virtual TQDomElement createRootElement( TQDomDocument & );

    virtual bool saveCustom( TQDomElement &, TQDomDocument & );
    virtual TQDomElement saveProperties( TQDomDocument & );
    virtual TQDomElement saveTargets( TQDomDocument & );

    virtual bool loadCustom( const TQDomElement & );
    virtual bool loadProperties( const TQDomElement & );
    virtual bool loadTargets( const TQDomElement & );

    virtual void copyBasicInto( KivioBaseTargetStencil * );

public:
    KivioBaseTargetStencil();
    virtual ~KivioBaseTargetStencil();

    virtual KivioStencil *duplicate() { return NULL; }


    //////////////////////////////
    //
    // KivioLineStyle
    //
    //////////////////////////////
    virtual TQColor fgColor();
    virtual void setFGColor( TQColor c );

    virtual void setLineWidth( double l );
    virtual double lineWidth();



    //////////////////////////////
    //
    // KivioFillStyle
    //
    //////////////////////////////
    virtual void setBGColor( TQColor c );
    virtual TQColor bgColor();

    virtual KivioFillStyle *fillStyle();



    //////////////////////////////
    //
    // KivioTextStyle
    //
    //////////////////////////////
    virtual TQColor textColor();
    virtual void setTextColor( TQColor c );

    virtual TQFont textFont();
    virtual void setTextFont( const TQFont &f );

    virtual int hTextAlign();
    virtual int vTextAlign();

    virtual void setHTextAlign(int a);
    virtual void setVTextAlign(int a);

    virtual void setText( const TQString &a );
    virtual TQString text();



    ///////////////////////////////
    //
    // Paint Routines
    //
    ///////////////////////////////
    virtual void paint( KivioIntraStencilData * );
    virtual void paintOutline( KivioIntraStencilData * );
    virtual void paintConnectorTargets( KivioIntraStencilData * );



    ///////////////////////////////
    //
    // File I/O
    //
    ///////////////////////////////
    virtual bool loadXML( const TQDomElement & );
    virtual TQDomElement saveXML( TQDomDocument & );



    ///////////////////////////////
    //
    // Geometry
    //
    ///////////////////////////////
    virtual void updateGeometry();



    ///////////////////////////////
    //
    // Connection Routines
    //
    ///////////////////////////////
    // This attempts to connect based on position
    virtual KivioConnectorTarget *connectToTarget( KivioConnectorPoint *, double );

    // This attempts to connect based on a targetID.  This should  ***ONLY*** be used
    // right after a load
    virtual KivioConnectorTarget *connectToTarget( KivioConnectorPoint *, int );


    ///////////////////////////////
    //
    // ID Generation
    //
    ///////////////////////////////
    virtual int generateIds( int );



    virtual int resizeHandlePositions();
};

#endif


