/*
    $Id: kcalc.cpp 466447 2005-10-02 17:54:10Z zander $

    kCalculator, a simple scientific calculator for KDE

    Copyright (C) 1996 Bernd Johannes Wuebben wuebben@math.cornell.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

*/

#include "configdlg.h"
#include "version.h"
#include <tdelocale.h>
#include <knotifyclient.h>
#include <tqlayout.h>
#include <tqobjectlist.h>
#include <tqpushbutton.h>
#include <tdeapplication.h>
#include <tdeglobalsettings.h>
#include <tqstyle.h>
#include <kdialog.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include "kcalc.h"

extern last_input_type last_input;
extern item_contents   display_data;
extern num_base        current_base;

TQPtrList<CALCAMNT>       temp_stack;

TQtCalculator :: TQtCalculator( Calculator *_corba, TQWidget *parent, const char *name )
  : TQDialog( parent, name )
{

    corba = _corba;
    mInternalSpacing=4;
    key_pressed = false;
    selection_timer = new TQTimer;
    status_timer = new TQTimer;

    connect(status_timer,TQ_SIGNAL(timeout()),this,TQ_SLOT(clear_status_label()));
    connect(selection_timer,TQ_SIGNAL(timeout()),this,TQ_SLOT(selection_timed_out()));

    readSettings();

    TQFont buttonfont( TDEGlobalSettings::generalFont() );
    buttonfont.setStyleStrategy( TQFont::PreferAntialias );

    // Set the window caption/title

    // connect(kapp,TQ_SIGNAL(tdedisplayPaletteChanged()),this,TQ_SLOT(set_colors()));
    // setCaption( kapp->caption() );

    // create help button

    TQPushButton *pb;

    pb = new TQPushButton( this, "helpbutton" );
    pb->setText( "kCalc" );
    pb->setFont( TQFont("times",12,TQFont::Bold,false) );
    TQToolTip::add( pb, i18n("KCalc Setup/Help") );

    connect( pb, TQ_SIGNAL(clicked()), TQ_SLOT(configclicked()) );

    // Create the display
    calc_display = new DLabel( this, "display" );
    calc_display->setFrameStyle( TQFrame::WinPanel | TQFrame::Sunken );
    calc_display->setAlignment( AlignRight|AlignVCenter );
    calc_display->setFocus();
    calc_display->setFocusPolicy( TQWidget::StrongFocus );

    connect(calc_display,TQ_SIGNAL(clicked()),this,TQ_SLOT(display_selected()));

    statusINVLabel = new TQLabel( this, "INV" );
    TQ_CHECK_PTR( statusINVLabel );
    statusINVLabel->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
    statusINVLabel->setAlignment( AlignCenter );
    statusINVLabel->setText("NORM");

    statusHYPLabel = new TQLabel( this, "HYP" );
    TQ_CHECK_PTR( statusHYPLabel );
    statusHYPLabel->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
    statusHYPLabel->setAlignment( AlignCenter );

    statusERRORLabel = new TQLabel( this, "ERROR" );
    TQ_CHECK_PTR( statusERRORLabel );
    statusERRORLabel->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
    statusERRORLabel->setAlignment( AlignLeft|AlignVCenter );

    // create angle button group

    TQAccel *accel = new TQAccel( this );

    TQButtonGroup *angle_group = new TQButtonGroup( 3,TQt::Horizontal,this, "AngleButtons" );
    angle_group->setTitle(i18n( "Angle") );

    anglebutton[0] = new TQRadioButton( angle_group );
    anglebutton[0]->setText( "&Deg" )   ;
    anglebutton[0]->setChecked(   true);
    accel->connectItem( accel->insertItem(Key_D + ALT), this ,
                        TQ_SLOT(Deg_Selected()) );

    anglebutton[1] = new TQRadioButton( angle_group );
    anglebutton[1]->setText( "&Rad" );
    accel->connectItem( accel->insertItem(Key_R + ALT), this ,
                        TQ_SLOT(Rad_Selected()) );

    anglebutton[2] = new TQRadioButton( angle_group );
    anglebutton[2]->setText( "&Gra" );
    accel->connectItem( accel->insertItem(Key_G + ALT), this ,
                        TQ_SLOT(Gra_Selected()) );

    connect( angle_group, TQ_SIGNAL(clicked(int)), TQ_SLOT(angle_selected(int)) );


//////////////////////////////////////////////////////////////////////
//
// Create Number Base Button Group
//



    TQButtonGroup *base_group = new TQButtonGroup( 4,TQt::Horizontal,this, "BaseButtons" );
    base_group->setTitle( i18n("Base") );

    basebutton[0] = new TQRadioButton( base_group );
    basebutton[0]->setText( "&Hex" );
    accel->connectItem( accel->insertItem(Key_H + ALT), this ,
                        TQ_SLOT(Hex_Selected()) );

    basebutton[1] = new TQRadioButton( base_group );
    basebutton[1]->setText( "D&ec" );
    basebutton[1]->setChecked(true);
    accel->connectItem( accel->insertItem(Key_E + ALT), this ,
                        TQ_SLOT(Dec_Selected()) );

    basebutton[2] = new TQRadioButton( base_group );
    basebutton[2]->setText( "&Oct" );
    accel->connectItem( accel->insertItem(Key_O + ALT), this ,
                        TQ_SLOT(Oct_Selected()) );

    basebutton[3] = new TQRadioButton( base_group);
    basebutton[3]->setText( "&Bin" );
    accel->connectItem( accel->insertItem(Key_B + ALT), this ,
                        TQ_SLOT(Bin_Selected()) );

    connect( base_group, TQ_SIGNAL(clicked(int)), TQ_SLOT(base_selected(int)) );

////////////////////////////////////////////////////////////////////////
//
//  Create Calculator Buttons
//


    // First the widgets that are the parents of the buttons
    mSmallPage = new TQWidget(this);
    mLargePage = new TQWidget(this);

    pbhyp = new TQPushButton("Hyp", mSmallPage, "hypbutton" );
    connect( pbhyp, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbhyptoggled(bool)));
    pbhyp->setToggleButton(true);

    pbinv = new TQPushButton( "Inv", mSmallPage, "InverseButton" );
    connect( pbinv, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbinvtoggled(bool)));
    pbinv->setToggleButton(true);

    pbA = new TQPushButton("A",mSmallPage, "Abutton" );
    connect( pbA, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbAtoggled(bool)));
    pbA->setToggleButton(true);

    pbSin = new TQPushButton("Sin",mSmallPage, "Sinbutton" );
    connect( pbSin, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbSintoggled(bool)));
    pbSin->setToggleButton(true);

    pbplusminus = new TQPushButton( "+/-", mSmallPage, "plusminusbutton" );
    connect( pbplusminus, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbplusminustoggled(bool)));
    pbplusminus->setToggleButton(true);
    pbplusminus->setFont(buttonfont);

    pbB = new TQPushButton("B", mSmallPage, "Bbutton" );
    connect( pbB, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbBtoggled(bool)));
    pbB->setToggleButton(true);

    pbCos = new TQPushButton("Cos",mSmallPage, "Cosbutton" );
    pbCos->setText( "Cos" );
    connect( pbCos, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbCostoggled(bool)));
    pbCos->setToggleButton(true);


    pbreci = new TQPushButton("1/x",mSmallPage, "recibutton" );
    connect( pbreci, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbrecitoggled(bool)));
    pbreci->setToggleButton(true);

    pbC = new TQPushButton( "C", mSmallPage, "Cbutton" );
    connect( pbC, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbCtoggled(bool)));
    pbC->setToggleButton(true);

    pbTan = new TQPushButton("Tan" ,mSmallPage,  "Tanbutton" );
    connect( pbTan, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbTantoggled(bool)));
    pbTan->setToggleButton(true);

    pbfactorial = new TQPushButton("x!",mSmallPage, "factorialbutton" );
    connect( pbfactorial, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbfactorialtoggled(bool)));
    pbfactorial->setToggleButton(true);

    pbD = new TQPushButton("D",mSmallPage,  "Dbutton" );
    connect( pbD, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbDtoggled(bool)));
    pbD->setToggleButton(true);

    pblog = new TQPushButton("Log",mSmallPage, "logbutton" );
    connect( pblog, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pblogtoggled(bool)));
    pblog->setToggleButton(true);

    pbsquare = new TQPushButton( "x^2", mSmallPage,  "squarebutton" );
    connect( pbsquare, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbsquaretoggled(bool)));
    pbsquare->setToggleButton(true);

    pbE = new TQPushButton("E",mSmallPage, "Ebutton" );
    connect( pbE, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbEtoggled(bool)));
    pbE->setToggleButton(true);


    pbln = new TQPushButton( "Ln", mSmallPage, "lnbutton" );
    connect( pbln, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pblntoggled(bool)));
    pbln->setToggleButton(true);

    pbpower = new TQPushButton("x^y",mSmallPage,  "powerbutton" );
    connect( pbpower, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbpowertoggled(bool)));
    pbpower->setToggleButton(true);

    pbF = new TQPushButton("F",mSmallPage, "Fbutton" );
    connect( pbF, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbFtoggled(bool)));
    pbF->setToggleButton(true);

    pbEE = new TQPushButton("EE",mLargePage,  "EEbutton" );
    pbEE->setToggleButton(true);
    connect( pbEE, TQ_SIGNAL(toggled(bool)), TQ_SLOT(EEtoggled(bool)));

    pbMR = new TQPushButton("MR",mLargePage,  "MRbutton" );
    connect( pbMR, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbMRtoggled(bool)));
    pbMR->setToggleButton(true);
    pbMR->setFont(buttonfont);

    pbMplusminus = new TQPushButton("M+-",mLargePage,  "Mplusminusbutton" );
    connect( pbMplusminus, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbMplusminustoggled(bool)));
    pbMplusminus->setToggleButton(true);

    pbMC = new TQPushButton("MC",mLargePage,  "MCbutton" );
    connect( pbMC, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbMCtoggled(bool)));
    pbMC->setToggleButton(true);

    pbClear = new TQPushButton("C",mLargePage,  "Clearbutton" );
    connect( pbClear, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbCleartoggled(bool)));
    pbClear->setToggleButton(true);

    pbAC = new TQPushButton("AC", mLargePage,  "ACbutton" );
    connect( pbAC, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbACtoggled(bool)));
    pbAC->setToggleButton(true);

    pb7 = new TQPushButton("7",mLargePage, "7button" );
    connect( pb7, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb7toggled(bool)));
    pb7->setToggleButton(true);

    pb8 = new TQPushButton("8",mLargePage, "8button" );
    connect( pb8, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb8toggled(bool)));
    pb8->setToggleButton(true);

    pb9 = new TQPushButton("9",mLargePage,"9button" );
    connect( pb9, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb9toggled(bool)));
    pb9->setToggleButton(true);

    pbparenopen = new TQPushButton("(",mLargePage,  "parenopenbutton" );
    connect( pbparenopen, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbparenopentoggled(bool)));
    pbparenopen->setToggleButton(true);

    pbparenclose = new TQPushButton(")",mLargePage, "parenclosebutton" );
    connect( pbparenclose, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbparenclosetoggled(bool)));
    pbparenclose->setToggleButton(true);

    pband = new TQPushButton("And",mLargePage, "andbutton" );
    connect( pband, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbandtoggled(bool)));
    pband->setToggleButton(true);
    pband->setFont(buttonfont);

    pb4 = new TQPushButton("4",mLargePage,  "4button" );
    connect( pb4, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb4toggled(bool)));
    pb4->setToggleButton(true);

    pb5 = new TQPushButton("5",mLargePage,  "5button" );
    connect( pb5, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb5toggled(bool)));
    pb5->setToggleButton(true);

    pb6 = new TQPushButton("6",mLargePage,  "6button" );
    connect( pb6, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb6toggled(bool)));
    pb6->setToggleButton(true);

    pbX = new TQPushButton("X",mLargePage, "Multiplybutton" );
    connect( pbX, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbXtoggled(bool)));
    pbX->setToggleButton(true);

    pbdivision = new TQPushButton("/",mLargePage,  "divisionbutton" );
    connect( pbdivision, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbdivisiontoggled(bool)));
    pbdivision->setToggleButton(true);

    pbor = new TQPushButton("Or",mLargePage,  "orbutton" );
    connect( pbor, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbortoggled(bool)));
    pbor->setToggleButton(true);

    pb1 = new TQPushButton("1",mLargePage,  "1button" );
    connect( pb1, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb1toggled(bool)));
    pb1->setToggleButton(true);

    pb2 = new TQPushButton("2",mLargePage,  "2button" );

    connect( pb2, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb2toggled(bool)));
    pb2->setToggleButton(true);

    pb3 = new TQPushButton("3",mLargePage,  "3button" );
    connect( pb3, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb3toggled(bool)));
    pb3->setToggleButton(true);

    pbplus = new TQPushButton("+",mLargePage, "plusbutton" );
    connect( pbplus, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbplustoggled(bool)));
    pbplus->setToggleButton(true);


    pbminus = new TQPushButton("-",mLargePage,  "minusbutton" );
    connect( pbminus, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbminustoggled(bool)));
    pbminus->setToggleButton(true);

    pbshift = new TQPushButton("Lsh",mLargePage, "shiftbutton" );
    connect( pbshift, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbshifttoggled(bool)));
    pbshift->setToggleButton(true);

    pbperiod = new TQPushButton(".",mLargePage,  "periodbutton" );
    connect( pbperiod, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbperiodtoggled(bool)));
    pbperiod->setToggleButton(true);

    pb0 = new TQPushButton("0",mLargePage,  "0button" );
    connect( pb0, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pb0toggled(bool)));
    pb0->setToggleButton(true);

    pbequal = new TQPushButton("=",mLargePage,  "equalbutton" );
    connect( pbequal, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbequaltoggled(bool)));
    pbequal->setToggleButton(true);

    pbpercent = new TQPushButton("%",mLargePage, "percentbutton" );
    connect( pbpercent, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbpercenttoggled(bool)));
    pbpercent->setToggleButton(true);

    pbnegate = new TQPushButton("Cmp",mLargePage,  "OneComplementbutton" );
    connect( pbnegate, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbnegatetoggled(bool)));
    pbnegate->setToggleButton(true);

    pbmod = new TQPushButton("Mod",mLargePage,  "modbutton" );
    connect( pbmod, TQ_SIGNAL(toggled(bool)), TQ_SLOT(pbmodtoggled(bool)));
    pbmod->setToggleButton(true);

    TQGridLayout *smallBtnLayout = new TQGridLayout(mSmallPage, 6, 3, 0,
                                                  mInternalSpacing);
    TQGridLayout *largeBtnLayout = new TQGridLayout(mLargePage, 5, 6, 0,
                                                  mInternalSpacing);

    TQHBoxLayout *topLayout		= new TQHBoxLayout();
    TQHBoxLayout *radioLayout	= new TQHBoxLayout();
    TQHBoxLayout *btnLayout		= new TQHBoxLayout();
    TQHBoxLayout *statusLayout	= new TQHBoxLayout();

    // bring them all together
    TQVBoxLayout *mainLayout = new TQVBoxLayout(this, mInternalSpacing,
                                              mInternalSpacing );

    mainLayout->addLayout(topLayout );
    mainLayout->addLayout(radioLayout, 1);
    mainLayout->addLayout(btnLayout);
    mainLayout->addLayout(statusLayout);

    // button layout
    btnLayout->addWidget(mSmallPage,0,AlignTop);
    btnLayout->addSpacing(mInternalSpacing);
    btnLayout->addWidget(mLargePage,0,AlignTop);

    // small button layout
    smallBtnLayout->addWidget(pbhyp, 0, 0);
    smallBtnLayout->addWidget(pbinv, 0, 1);
    smallBtnLayout->addWidget(pbA, 0, 2);

    smallBtnLayout->addWidget(pbSin, 1, 0);
    smallBtnLayout->addWidget(pbplusminus, 1, 1);
    smallBtnLayout->addWidget(pbB, 1, 2);

    smallBtnLayout->addWidget(pbCos, 2, 0);
    smallBtnLayout->addWidget(pbreci, 2, 1);
    smallBtnLayout->addWidget(pbC, 2, 2);

    smallBtnLayout->addWidget(pbTan, 3, 0);
    smallBtnLayout->addWidget(pbfactorial, 3, 1);
    smallBtnLayout->addWidget(pbD, 3, 2);

    smallBtnLayout->addWidget(pblog, 4, 0);
    smallBtnLayout->addWidget(pbsquare, 4, 1);
    smallBtnLayout->addWidget(pbE, 4, 2);

    smallBtnLayout->addWidget(pbln, 5, 0);
    smallBtnLayout->addWidget(pbpower, 5, 1);
    smallBtnLayout->addWidget(pbF, 5, 2);

    smallBtnLayout->setRowStretch(0, 0);
    smallBtnLayout->setRowStretch(1, 0);
    smallBtnLayout->setRowStretch(2, 0);
    smallBtnLayout->setRowStretch(3, 0);
    smallBtnLayout->setRowStretch(4, 0);
    smallBtnLayout->setRowStretch(5, 0);

    // large button layout
    largeBtnLayout->addWidget(pbEE, 0, 0);
    largeBtnLayout->addWidget(pbMR, 0, 1);
    largeBtnLayout->addWidget(pbMplusminus, 0, 2);
    largeBtnLayout->addWidget(pbMC, 0, 3);
    largeBtnLayout->addWidget(pbClear, 0, 4);
    largeBtnLayout->addWidget(pbAC, 0, 5);

    largeBtnLayout->addWidget(pb7, 1, 0);
    largeBtnLayout->addWidget(pb8, 1, 1);
    largeBtnLayout->addWidget(pb9, 1, 2);
    largeBtnLayout->addWidget(pbparenopen, 1, 3);
    largeBtnLayout->addWidget(pbparenclose, 1, 4);
    largeBtnLayout->addWidget(pband, 1, 5);

    largeBtnLayout->addWidget(pb4, 2, 0);
    largeBtnLayout->addWidget(pb5, 2, 1);
    largeBtnLayout->addWidget(pb6, 2, 2);
    largeBtnLayout->addWidget(pbX, 2, 3);
    largeBtnLayout->addWidget(pbdivision, 2, 4);
    largeBtnLayout->addWidget(pbor, 2, 5);

    largeBtnLayout->addWidget(pb1, 3, 0);
    largeBtnLayout->addWidget(pb2, 3, 1);
    largeBtnLayout->addWidget(pb3, 3, 2);
    largeBtnLayout->addWidget(pbplus, 3, 3);
    largeBtnLayout->addWidget(pbminus, 3, 4);
    largeBtnLayout->addWidget(pbshift, 3, 5);

    largeBtnLayout->addWidget(pbperiod, 4, 0);
    largeBtnLayout->addWidget(pb0, 4, 1);
    largeBtnLayout->addWidget(pbequal, 4, 2);
    largeBtnLayout->addWidget(pbpercent, 4, 3);
    largeBtnLayout->addWidget(pbnegate, 4, 4);
    largeBtnLayout->addWidget(pbmod, 4, 5);

    largeBtnLayout->addColSpacing(0,10);
    largeBtnLayout->addColSpacing(1,10);
    largeBtnLayout->addColSpacing(2,10);
    largeBtnLayout->addColSpacing(3,10);
    largeBtnLayout->addColSpacing(4,10);
    topLayout->addWidget(pb);
    topLayout->addWidget(calc_display, 10);


    // radiobutton layout
    radioLayout->addWidget(base_group);
    radioLayout->addWidget(angle_group);

    // status layout
    statusLayout->addWidget(statusINVLabel);
    statusLayout->addWidget(statusHYPLabel);
    statusLayout->addWidget(statusERRORLabel, 10);

    mNumButtonList.append(pb0);
    mNumButtonList.append(pb1);
    mNumButtonList.append(pb2);
    mNumButtonList.append(pb3);
    mNumButtonList.append(pb4);
    mNumButtonList.append(pb5);
    mNumButtonList.append(pb6);
    mNumButtonList.append(pb7);
    mNumButtonList.append(pb8);
    mNumButtonList.append(pb9);

    mFunctionButtonList.append(pbhyp);
    mFunctionButtonList.append(pbinv);
    mFunctionButtonList.append(pbSin);
    mFunctionButtonList.append(pbplusminus);
    mFunctionButtonList.append(pbCos);
    mFunctionButtonList.append(pbreci);
    mFunctionButtonList.append(pbTan);
    mFunctionButtonList.append(pbfactorial);
    mFunctionButtonList.append(pblog);
    mFunctionButtonList.append(pbsquare);
    mFunctionButtonList.append(pbln);
    mFunctionButtonList.append(pbpower);

    mHexButtonList.append(pbA);
    mHexButtonList.append(pbB);
    mHexButtonList.append(pbC);
    mHexButtonList.append(pbD);
    mHexButtonList.append(pbE);
    mHexButtonList.append(pbF);

    mMemButtonList.append(pbEE);
    mMemButtonList.append(pbMR);
    mMemButtonList.append(pbMplusminus);
    mMemButtonList.append(pbMC);
    mMemButtonList.append(pbClear);
    mMemButtonList.append(pbAC);

    mOperationButtonList.append(pbX);
    mOperationButtonList.append(pbparenopen);
    mOperationButtonList.append(pbparenclose);
    mOperationButtonList.append(pband);
    mOperationButtonList.append(pbdivision);
    mOperationButtonList.append(pbor);
    mOperationButtonList.append(pbplus);
    mOperationButtonList.append(pbminus);
    mOperationButtonList.append(pbshift);
    mOperationButtonList.append(pbperiod);
    mOperationButtonList.append(pbequal);
    mOperationButtonList.append(pbpercent);
    mOperationButtonList.append(pbnegate);
    mOperationButtonList.append(pbmod);

    set_colors();
    set_precision();
    set_style();
    updateGeometry();
    setFixedHeight(minimumHeight());
    InitializeCalculator();
}

TQtCalculator::~TQtCalculator()
{
    delete selection_timer;
    delete status_timer;

}

void TQtCalculator::set_display_font()
{
    calc_display->setFont(kcalcdefaults.font);
}

void TQtCalculator::updateGeometry()
{
    TQObjectList *l;
    TQSize s;
    int margin;

    //
    // Uppermost bar
    //
    calc_display->setMinimumWidth(calc_display->fontMetrics().maxWidth() * 15);

    //
    // Button groups (base and angle)
    //
    //TQButtonGroup *g;
    //g = (TQButtonGroup*)(anglebutton[0]->parentWidget());
    //g = (TQButtonGroup*)(basebutton[0]->parentWidget());

    //
    // Calculator buttons
    //
    s.setWidth(mSmallPage->fontMetrics().width("MMM"));
    s.setHeight(mSmallPage->fontMetrics().lineSpacing());

    l = (TQObjectList*)mSmallPage->children(); // silence please

    for(uint i=0; i < l->count(); i++)
    {
        TQObject *o = l->at(i);
        if( o->isWidgetType() )
        {
            margin = TQApplication::style().
                pixelMetric(TQStyle::PM_ButtonMargin, ((TQWidget *)o))*2;
            ((TQWidget*)o)->setMinimumSize(s.width()+margin, s.height()+margin);
            ((TQWidget*)o)->installEventFilter( this );
            ((TQWidget*)o)->setAcceptDrops(true);
        }
    }

    l = (TQObjectList*)mLargePage->children(); // silence please

    int h1 = pbF->minimumSize().height();
    int h2 = (int)((((float)h1 + 4.0) / 5.0));
    s.setWidth(mLargePage->fontMetrics().width("MMM") +
               TQApplication::style().
               pixelMetric(TQStyle::PM_ButtonMargin, pbF)*2);
    s.setHeight(h1 + h2);

    for(uint i = 0; i < l->count(); i++)
    {
        TQObject *o = l->at(i);
        if(o->isWidgetType())
        {
            ((TQWidget*)o)->setFixedSize(s);
            ((TQWidget*)o)->installEventFilter(this);
            ((TQWidget*)o)->setAcceptDrops(true);
        }
    }

    //
    // The status bar
    //
    s.setWidth( statusINVLabel->fontMetrics().width("NORM") +
                statusINVLabel->frameWidth() * 2 + 10);
    statusINVLabel->setMinimumWidth(s.width());
    statusHYPLabel->setMinimumWidth(s.width());

    //setFixedSize(minimumSize());
}

void TQtCalculator::exit()
{
    // TQApplication::exit();
}

void TQtCalculator::Hex_Selected()
{
  basebutton[0]->setChecked(true);
  basebutton[1]->setChecked(false);
  basebutton[2]->setChecked(false);
  basebutton[3]->setChecked(false);
  SetHex();
}


void TQtCalculator::Dec_Selected()
{
  basebutton[0]->setChecked(false);
  basebutton[1]->setChecked(true);
  basebutton[2]->setChecked(false);
  basebutton[3]->setChecked(false);
  SetDec();
}


void TQtCalculator::Oct_Selected()
{
  basebutton[0]->setChecked(false);
  basebutton[1]->setChecked(false);
  basebutton[2]->setChecked(true);
  basebutton[3]->setChecked(false);
  SetOct();
}



void TQtCalculator::Bin_Selected()
{
  basebutton[0]->setChecked(false);
  basebutton[1]->setChecked(false);
  basebutton[2]->setChecked(false);
  basebutton[3]->setChecked(true);
  SetBin();
}

void TQtCalculator::Deg_Selected()
{
  anglebutton[0]->setChecked(true);
  anglebutton[1]->setChecked(false);
  anglebutton[2]->setChecked(false);
  SetDeg();
}


void TQtCalculator::Rad_Selected()
{
  anglebutton[0]->setChecked(false);
  anglebutton[1]->setChecked(true);
  anglebutton[2]->setChecked(false);
  SetRad();

}


void TQtCalculator::Gra_Selected()
{
  anglebutton[0]->setChecked(false);
  anglebutton[1]->setChecked(false);
  anglebutton[2]->setChecked(true);
  SetGra();
}


void TQtCalculator::helpclicked(){
}

void TQtCalculator::keyPressEvent( TQKeyEvent *e ){

  switch (e->key() ){

  case Key_F1:
     helpclicked();
     break;
  case Key_F2:
     configclicked();
     break;
  case Key_F3:
    if(kcalcdefaults.style == 0)
      kcalcdefaults.style = 1;
    else if(kcalcdefaults.style == 1)
      kcalcdefaults.style = 2;
    else
      kcalcdefaults.style = 0;
     set_style();
     break;
  case Key_Up:
     temp_stack_prev();
     break;
  case Key_Down:
     temp_stack_next();
     break;

  case Key_Next:
     key_pressed = true;
     pbAC->setOn(true);
     break;
  case Key_Prior:
     key_pressed = true;
     pbClear->setOn(true);
     break;

  case Key_H:
     key_pressed = true;
     pbhyp->setOn(true);
     break;
  case Key_I:
     key_pressed = true;
     pbinv->setOn(true);
     break;
  case Key_A:
     key_pressed = true;
     pbA->setOn(true);

     break;
  case Key_E:
     key_pressed = true;
    if (current_base == NB_HEX)
     pbE->setOn(true);
    else
     pbEE->setOn(true);
     break;
  case Key_Escape:
     key_pressed = true;
     pbClear->setOn(true);
     break;
  case Key_Delete:
     key_pressed = true;
     pbAC->setOn(true);
     break;
  case Key_S:
     key_pressed = true;
     pbSin->setOn(true);
     break;
  case Key_Backslash:
     key_pressed = true;
     pbplusminus->setOn(true);
     break;
  case Key_B:
     key_pressed = true;
     pbB->setOn(true);
     break;
  case Key_7:
     key_pressed = true;
     pb7->setOn(true);
     break;
  case Key_8:
     key_pressed = true;
     pb8->setOn(true);
     break;
  case Key_9:
     key_pressed = true;
     pb9->setOn(true);
     break;
  case Key_ParenLeft:
     key_pressed = true;
     pbparenopen->setOn(true);
     break;
  case Key_ParenRight:
     key_pressed = true;
     pbparenclose->setOn(true);
     break;
  case Key_Ampersand:
     key_pressed = true;
     pband->setOn(true);
     break;
  case Key_C:
     key_pressed = true;
    if (current_base == NB_HEX)
     pbC->setOn(true);
    else
     pbCos->setOn(true);
     break;
  case Key_4:
     key_pressed = true;
     pb4->setOn(true);
     break;
  case Key_5:
     key_pressed = true;
     pb5->setOn(true);
     break;
  case Key_6:
     key_pressed = true;
     pb6->setOn(true);
     break;
  case Key_Asterisk:
     key_pressed = true;
     pbX->setOn(true);
     break;
  case Key_Slash:
     key_pressed = true;
     pbdivision->setOn(true);
     break;
  case Key_O:
     key_pressed = true;
     pbor->setOn(true);
     break;
  case Key_T:
     key_pressed = true;
     pbTan->setOn(true);
     break;
  case Key_Exclam:
     key_pressed = true;
     pbfactorial->setOn(true);
     break;
  case Key_D:
     key_pressed = true;
     if(kcalcdefaults.style == 0)
       pbD->setOn(true); // trig mode
     else
       pblog->setOn(true); // stat mode
    break;
  case Key_1:
     key_pressed = true;
     pb1->setOn(true);
     break;
  case Key_2:
     key_pressed = true;
     pb2->setOn(true);
     break;
  case Key_3:
     key_pressed = true;
     pb3->setOn(true);
     break;
  case Key_Plus:
     key_pressed = true;
     pbplus->setOn(true);
     break;
  case Key_Minus:
     key_pressed = true;
     pbminus->setOn(true);
     break;
  case Key_Less:
     key_pressed = true;
     pbshift->setOn(true);
     break;
  case Key_N:
     key_pressed = true;
     pbln->setOn(true);
     break;
  case Key_L:
     key_pressed = true;
     pblog->setOn(true);
     break;
  case Key_AsciiCircum:
     key_pressed = true;
     pbpower->setOn(true);
     break;
  case Key_F:
     key_pressed = true;
     pbF->setOn(true);
     break;
  case Key_Period:
     key_pressed = true;
     pbperiod->setOn(true);
     break;
  case Key_Comma:
     key_pressed = true;
     pbperiod->setOn(true);
     break;
  case Key_0:
     key_pressed = true;
     pb0->setOn(true);
     break;
     case Key_Equal:
     key_pressed = true;
     pbequal->setOn(true);
     break;
  case Key_Return:
     key_pressed = true;
     pbequal->setOn(true);
     break;
  case Key_Enter:
     key_pressed = true;
     pbequal->setOn(true);
     break;
  case Key_Percent:
     key_pressed = true;
     pbpercent->setOn(true);
     break;
  case Key_AsciiTilde:
     key_pressed = true;
     pbnegate->setOn(true);
     break;
  case Key_Colon:
     key_pressed = true;
     pbmod->setOn(true);
     break;
  case Key_BracketLeft:
     key_pressed = true;
     pbsquare->setOn(true);
     break;
 case Key_Backspace:
     key_pressed = true;
     pbAC->setOn(true);
     break;
  case Key_R:
     key_pressed = true;
     pbreci->setOn(true);
     break;
  }
}

void TQtCalculator::keyReleaseEvent( TQKeyEvent *e ){
  switch (e->key() ){

  case Key_Next:
     key_pressed = false;
     pbAC->setOn(false);
     break;
  case Key_Prior:
     key_pressed = false;
     pbClear->setOn(false);
     break;

  case Key_H:
    key_pressed = false;
     pbhyp->setOn(false);
     break;
  case Key_I:
    key_pressed = false;
     pbinv->setOn(false);
     break;
  case Key_A:
    key_pressed = false;
     pbA->setOn(false);
     break;
  case Key_E:
    key_pressed = false;
    if (current_base == NB_HEX)
     pbE->setOn(false);
    else
     pbEE->setOn(false);
     break;
  case Key_Escape:
    key_pressed = false;
     pbClear->setOn(false);
     break;
  case Key_Delete:
    key_pressed = false;
     pbAC->setOn(false);
     break;
  case Key_S:
    key_pressed = false;
     pbSin->setOn(false);
     break;
  case Key_Backslash:
    key_pressed = false;
     pbplusminus->setOn(false);
     break;
  case Key_B:
    key_pressed = false;
     pbB->setOn(false);
     break;
  case Key_7:
    key_pressed = false;
     pb7->setOn(false);
     break;
  case Key_8:
    key_pressed = false;
     pb8->setOn(false);
     break;
  case Key_9:
    key_pressed = false;
     pb9->setOn(false);
     break;
  case Key_ParenLeft:
    key_pressed = false;
     pbparenopen->setOn(false);
     break;
  case Key_ParenRight:
    key_pressed = false;
     pbparenclose->setOn(false);
     break;
  case Key_Ampersand:
    key_pressed = false;
     pband->setOn(false);
     break;
  case Key_C:
    key_pressed = false;
    if (current_base == NB_HEX)
     pbC->setOn(false);
    else
     pbCos->setOn(false);
     break;
  case Key_4:
    key_pressed = false;
     pb4->setOn(false);
     break;
  case Key_5:
    key_pressed = false;
     pb5->setOn(false);
     break;
  case Key_6:
    key_pressed = false;
     pb6->setOn(false);
     break;
  case Key_Asterisk:
    key_pressed = false;
     pbX->setOn(false);
     break;
  case Key_Slash:
    key_pressed = false;
     pbdivision->setOn(false);
     break;
  case Key_O:
    key_pressed = false;
     pbor->setOn(false);
     break;
  case Key_T:
    key_pressed = false;
     pbTan->setOn(false);
     break;
  case Key_Exclam:
    key_pressed = false;
     pbfactorial->setOn(false);
     break;
  case Key_D:
    key_pressed = false;
    if(kcalcdefaults.style == 0)
      pbD->setOn(false); // trig mode
    else
      pblog->setOn(false);// stat mode
     break;
  case Key_1:
    key_pressed = false;
     pb1->setOn(false);
     break;
  case Key_2:
    key_pressed = false;
     pb2->setOn(false);
     break;
  case Key_3:
    key_pressed = false;
     pb3->setOn(false);
     break;
  case Key_Plus:
    key_pressed = false;
     pbplus->setOn(false);
     break;
  case Key_Minus:
    key_pressed = false;
     pbminus->setOn(false);
     break;
  case Key_Less:
    key_pressed = false;
     pbshift->setOn(false);
     break;
  case Key_N:
    key_pressed = false;
     pbln->setOn(false);
     break;
  case Key_L:
    key_pressed = false;
     pblog->setOn(false);
     break;
  case Key_AsciiCircum:
    key_pressed = false;
     pbpower->setOn(false);
     break;
  case Key_F:
    key_pressed = false;
     pbF->setOn(false);
     break;
  case Key_Period:
    key_pressed = false;
     pbperiod->setOn(false);
     break;
  case Key_Comma:
    key_pressed = false;
     pbperiod->setOn(false);
     break;
  case Key_0:
    key_pressed = false;
     pb0->setOn(false);
     break;
  case Key_Equal:
    key_pressed = false;
     pbequal->setOn(false);
     break;
  case Key_Return:
    key_pressed = false;
     pbequal->setOn(false);
     break;
  case Key_Enter:
     key_pressed = false;
     pbequal->setOn(false);
     break;
  case Key_Percent:
    key_pressed = false;
     pbpercent->setOn(false);
     break;
  case Key_AsciiTilde:
    key_pressed = false;
     pbnegate->setOn(false);
     break;
  case Key_Colon:
    key_pressed = false;
     pbmod->setOn(false);
     break;
  case Key_BracketLeft:
     key_pressed = false;
     pbsquare->setOn(false);
     break;
  case Key_Backspace:
     key_pressed = false;
     pbAC->setOn(false);
     break;
  case Key_R:
     key_pressed = false;
     pbreci->setOn(false);
     break;
  }

  clear_buttons();
}

void TQtCalculator::clear_buttons(){

}

void TQtCalculator::EEtoggled(bool myboolean){

  if(myboolean)
    EE();
  if(pbEE->isOn() && (!key_pressed))
    pbEE->setOn(false);
}

void TQtCalculator::pbinvtoggled(bool myboolean){
  if(myboolean)
    SetInverse();
  if(pbinv->isOn() && (!key_pressed))
    pbinv->setOn(false);
}

void TQtCalculator::pbhyptoggled(bool myboolean){
  if(myboolean)
    EnterHyp();
  if(pbhyp->isOn() && (!key_pressed))
    pbhyp->setOn(false);
}
void TQtCalculator::pbMRtoggled(bool myboolean){
  if(myboolean)
    MR();
  if(pbMR->isOn() && (!key_pressed))
    pbMR->setOn(false);
}

void TQtCalculator::pbAtoggled(bool myboolean){
  if(myboolean)
    buttonA();
    if(pbA->isOn() && (!key_pressed))
   pbA->setOn(false);
}

void TQtCalculator::pbSintoggled(bool myboolean){
  if(myboolean)
    ExecSin();
  if(pbSin->isOn() && (!key_pressed))
    pbSin->setOn(false);
}
void TQtCalculator::pbplusminustoggled(bool myboolean){
  if(myboolean)
    EnterNegate();
  if(pbplusminus->isOn() && (!key_pressed))
    pbplusminus->setOn(false);
}
void TQtCalculator::pbMplusminustoggled(bool myboolean){
  if(myboolean)
    Mplusminus();
  if(pbMplusminus->isOn() && (!key_pressed))
    pbMplusminus->setOn(false);
}
void TQtCalculator::pbBtoggled(bool myboolean){
  if(myboolean)
    buttonB();
  if(pbB->isOn() && (!key_pressed))
    pbB->setOn(false);
}
void TQtCalculator::pbCostoggled(bool myboolean){
  if(myboolean)
    ExecCos();
  if(pbCos->isOn() && (!key_pressed))
    pbCos->setOn(false);
}
void TQtCalculator::pbrecitoggled(bool myboolean){
  if(myboolean)
    EnterRecip();
  if(pbreci->isOn() && (!key_pressed))
    pbreci->setOn(false);
}
void TQtCalculator::pbCtoggled(bool myboolean){
  if(myboolean)
    buttonC();
  if(pbC->isOn() && (!key_pressed))
    pbC->setOn(false);
}
void TQtCalculator::pbTantoggled(bool myboolean){
  if(myboolean)
    ExecTan();
  if(pbTan->isOn() && (!key_pressed))
    pbTan->setOn(false);
}
void TQtCalculator::pbfactorialtoggled(bool myboolean){
  if(myboolean)
    EnterFactorial();
  if(pbfactorial->isOn() && (!key_pressed))
    pbfactorial->setOn(false);
}
void TQtCalculator::pbDtoggled(bool myboolean){
  if(myboolean)
    buttonD();
  if(pbD->isOn() && (!key_pressed))
    pbD->setOn(false);
}
void TQtCalculator::pblogtoggled(bool myboolean){
  if(myboolean)
   EnterLogr();
  if(pblog->isOn() && (!key_pressed))
    pblog->setOn(false);
}
void TQtCalculator::pbsquaretoggled(bool myboolean){
  if(myboolean)
    EnterSquare();
  if(pbsquare->isOn() && (!key_pressed))
    pbsquare->setOn(false);
}
void TQtCalculator::pbEtoggled(bool myboolean){
  if(myboolean)
    buttonE();
  if(pbE->isOn() && (!key_pressed))
    pbE->setOn(false);
}
void TQtCalculator::pblntoggled(bool myboolean){
  if(myboolean)
    EnterLogn();
  if(pbln->isOn() && (!key_pressed))
    pbln->setOn(false);
}
void TQtCalculator::pbpowertoggled(bool myboolean){
  if(myboolean)
    Power();
  if(pbpower->isOn() && (!key_pressed))
    pbpower->setOn(false);
}
void TQtCalculator::pbFtoggled(bool myboolean){
  if(myboolean)
    buttonF();
  if(pbF->isOn() && (!key_pressed))
    pbF->setOn(false);
}
void TQtCalculator::pbMCtoggled(bool myboolean){
  if(myboolean)
    MC();
  if(pbMC->isOn() && (!key_pressed))
    pbMC->setOn(false);
}
void TQtCalculator::pbCleartoggled(bool myboolean){
  if(myboolean)
    Clear();
  if(pbClear->isOn() && (!key_pressed))
    pbClear->setOn(false);
}
void TQtCalculator::pbACtoggled(bool myboolean){
  if(myboolean)
    ClearAll();
  if(pbAC->isOn() && (!key_pressed))
    pbAC->setOn(false);
}
void TQtCalculator::pb7toggled(bool myboolean){
  if(myboolean)
    button7();
  if(pb7->isOn() && (!key_pressed))
    pb7->setOn(false);
}
void TQtCalculator::pb8toggled(bool myboolean){
  if(myboolean)
    button8();
  if(pb8->isOn() && (!key_pressed))
    pb8->setOn(false);
}
void TQtCalculator::pb9toggled(bool myboolean){
  if(myboolean)
    button9();
  if(pb9->isOn() && (!key_pressed))
    pb9->setOn(false);
}
void TQtCalculator::pbparenopentoggled(bool myboolean){
  if(myboolean)
    EnterOpenParen();
  if(pbparenopen->isOn() && (!key_pressed))
    pbparenopen->setOn(false);
}
void TQtCalculator::pbparenclosetoggled(bool myboolean){
  if(myboolean)
    EnterCloseParen();
  if(pbparenclose->isOn() && (!key_pressed))
    pbparenclose->setOn(false);
}
void TQtCalculator::pbandtoggled(bool myboolean){
  if(myboolean)
    And();
  if(pband->isOn() && (!key_pressed))
    pband->setOn(false);
}
void TQtCalculator::pb4toggled(bool myboolean){
  if(myboolean)
    button4();
  if(pb4->isOn() && (!key_pressed))
    pb4->setOn(false);
}
void TQtCalculator::pb5toggled(bool myboolean){
  if(myboolean)
    button5();
  if(pb5->isOn() && (!key_pressed))
    pb5->setOn(false);
}
void TQtCalculator::pb6toggled(bool myboolean){
  if(myboolean)
    button6();
  if(pb6->isOn() && (!key_pressed))
    pb6->setOn(false);
}
void TQtCalculator::pbXtoggled(bool myboolean){
  if(myboolean)
    Multiply();
  if(pbX->isOn() && (!key_pressed))
    pbX->setOn(false);
}
void TQtCalculator::pbdivisiontoggled(bool myboolean){
  if(myboolean)
    Divide();
  if(pbdivision->isOn() && (!key_pressed))
    pbdivision->setOn(false);
}
void TQtCalculator::pbortoggled(bool myboolean){
  if(myboolean)
    Or();
  if(pbor->isOn() && (!key_pressed))
    pbor->setOn(false);
}
void TQtCalculator::pb1toggled(bool myboolean){
  if(myboolean)
    button1();
  if(pb1->isOn() && (!key_pressed))
    pb1->setOn(false);
}
void TQtCalculator::pb2toggled(bool myboolean){
  if(myboolean)
    button2();
  if(pb2->isOn() && (!key_pressed))
    pb2->setOn(false);
}
void TQtCalculator::pb3toggled(bool myboolean){
  if(myboolean)
    button3();
  if(pb3->isOn() && (!key_pressed))
    pb3->setOn(false);
}
void TQtCalculator::pbplustoggled(bool myboolean){
  if(myboolean)
    Plus();
  if(pbplus->isOn() && (!key_pressed))
    pbplus->setOn(false);
}
void TQtCalculator::pbminustoggled(bool myboolean){
  if(myboolean)
    Minus();
  if(pbminus->isOn() && (!key_pressed))
    pbminus->setOn(false);
}
void TQtCalculator::pbshifttoggled(bool myboolean){
  if(myboolean)
    Shift();
  if(pbshift->isOn() && (!key_pressed))
    pbshift->setOn(false);
}
void TQtCalculator::pbperiodtoggled(bool myboolean){
  if(myboolean)
    EnterDecimal();
  if(pbperiod->isOn() && (!key_pressed))
    pbperiod->setOn(false);
}
void TQtCalculator::pb0toggled(bool myboolean){
  if(myboolean)
    button0();
  if(pb0->isOn() && (!key_pressed))
    pb0->setOn(false);
}
void TQtCalculator::pbequaltoggled(bool myboolean){
  if(myboolean)
    EnterEqual();
  if(pbequal->isOn() && (!key_pressed))
    pbequal->setOn(false);
}
void TQtCalculator::pbpercenttoggled(bool myboolean){
  if(myboolean)
    EnterPercent();
  if(pbpercent->isOn() && (!key_pressed))
    pbpercent->setOn(false);
}
void TQtCalculator::pbnegatetoggled(bool myboolean){
  if(myboolean)
    EnterNotCmp();
  if(pbnegate->isOn() && (!key_pressed))
    pbnegate->setOn(false);
}
void TQtCalculator::pbmodtoggled(bool myboolean)  {
  if(myboolean)
    Mod();
  if(pbmod->isOn() && (!key_pressed))
    pbmod->setOn(false);
}

void TQtCalculator::configclicked(){


  TQTabDialog * tabdialog;
  tabdialog = new TQTabDialog(0,"tabdialog",true);

  tabdialog->setCaption( i18n("KCalc Configuration") );
  tabdialog->resize( 360, 390 );
  tabdialog->setCancelButton( i18n("&Cancel") );
  tabdialog->setOKButton(i18n("&OK"));

  TQWidget *about = new TQWidget(tabdialog,"about");
  TQVBoxLayout *lay1 = new TQVBoxLayout( about );
  lay1->setMargin( KDialog::marginHint() );
  lay1->setSpacing( KDialog::spacingHint() );

  TQGroupBox *box = new TQGroupBox(0,TQt::Vertical,about,"box");
  box->layout()->setSpacing(KDialog::spacingHint());
  box->layout()->setMargin(KDialog::marginHint());
  TQGridLayout *grid1 = new TQGridLayout(box->layout(),2,2);
  TQLabel  *label = new TQLabel(box,"label");
  TQLabel  *label2 = new TQLabel(box,"label2");

  box->setTitle(i18n("About"));
  grid1->addWidget(label,0,1);
  grid1->addMultiCellWidget(label2,2,2,0,1);

  TQString labelstring = "KCalc "KCALCVERSION"\n"\
    "Bernd Johannes Wuebben\n"\
    "wuebben@math.cornell.edu\n"\
    "wuebben@kde.org\n"\
    "Copyright (C) 1996-98\n"\
    "\n\n";

  TQString labelstring2 =
#ifdef HAVE_LONG_DOUBLE
                i18n( "Base type: long double\n");
#else
                i18n( "Due to broken glibc's everywhere, "\
                      "I had to reduce KCalc's precision from 'long double' "\
                      "to 'double'. "\
                      "Owners of systems with a working libc "\
                      "should recompile KCalc with 'long double' precision "\
                      "enabled. See the README for details.");
#endif

  label->setAlignment(AlignLeft|WordBreak|ExpandTabs);
  label->setText(labelstring);

  label2->setAlignment(AlignLeft|WordBreak|ExpandTabs);
  label2->setText(labelstring2);

  // HACK
  // TQPixmap pm( BarIcon( "kcalclogo" ) );
  TQPixmap pm;
  TQLabel *logo = new TQLabel(box);
  logo->setPixmap(pm);
  grid1->addWidget(logo,0,0);
  lay1->addWidget(box);


  DefStruct newdefstruct;
  newdefstruct.forecolor  = kcalcdefaults.forecolor;
  newdefstruct.backcolor  = kcalcdefaults.backcolor;
  newdefstruct.precision  = kcalcdefaults.precision;
  newdefstruct.fixedprecision  = kcalcdefaults.fixedprecision;
  newdefstruct.fixed  = kcalcdefaults.fixed;
  newdefstruct.style  = kcalcdefaults.style;
  newdefstruct.beep  = kcalcdefaults.beep;

  ConfigDlg *configdlg;
  configdlg = new ConfigDlg(tabdialog,"configdlg",&newdefstruct);

  tabdialog->addTab(configdlg,i18n("Defaults"));
  tabdialog->addTab(about,i18n("About"));


  if(tabdialog->exec() == TQDialog::Accepted){


    kcalcdefaults.forecolor  = newdefstruct.forecolor;
    kcalcdefaults.backcolor  = newdefstruct.backcolor;
    kcalcdefaults.precision  = newdefstruct.precision;
    kcalcdefaults.fixedprecision  = newdefstruct.fixedprecision;
    kcalcdefaults.fixed  = newdefstruct.fixed;
    kcalcdefaults.style  = newdefstruct.style;
    kcalcdefaults.beep  = newdefstruct.beep;

    set_colors();
    set_precision();
    set_style();
    updateGeometry();
    resize(minimumSize());
  }
  delete configdlg;
}


void TQtCalculator::set_style(){

  switch(kcalcdefaults.style){
  case  0:{
    pbhyp->setText( "Hyp" );
    pbSin->setText( "Sin" );
    pbCos->setText( "Cos" );
    pbTan->setText( "Tan" );
    pblog->setText( "Log" );
    pbln ->setText( "Ln"  );
    break;
  }
  case 1:{
    pbhyp->setText( "N" );
    pbSin->setText( "Mea" );
    pbCos->setText( "Std" );
    pbTan->setText( "Med" );
    pblog->setText( "Dat" );
    pbln ->setText( "CSt"  );
    break;
  }
  case 2:{
    pbhyp->setText( "N" );
    pbSin->setText( "Min" );
    pbCos->setText( "Max" );
    pbTan->setText( "Med" );
    pblog->setText( "Sum" );
    pbln ->setText( "Mul"  );
    break;
  }

  default:
    break;
  }
}

void TQtCalculator::readSettings()
{
    TQColor tmpC(189, 255, 180);
    TQColor blackC(0,0,0);

    TDEConfig *config = TDEGlobal::config();
	config->setGroup("CalcPlugin");
    kcalcdefaults.forecolor = config->readColorEntry("ForeColor", &blackC);
	kcalcdefaults.backcolor = config->readColorEntry("BackColor", &tmpC);

#ifdef HAVE_LONG_DOUBLE
	kcalcdefaults.precision	= config->readNumEntry("precision", (int)14);
#else
	kcalcdefaults.precision	= config->readNumEntry("precision", (int)10);
#endif
    kcalcdefaults.fixedprecision = config->readNumEntry("fixedprecision", (int)2);
	kcalcdefaults.fixed = config->readBoolEntry("fixed", false);

	kcalcdefaults.style	= config->readNumEntry("style", (int)0);
	kcalcdefaults.beep	= config->readBoolEntry("beep", true);
}

void TQtCalculator::writeSettings()
{
    TDEConfig *config = TDEGlobal::config();

	config->setGroup("CalcPlugin");
	config->writeEntry("ForeColor",kcalcdefaults.forecolor);
	config->writeEntry("BackColor",kcalcdefaults.backcolor);

	config->writeEntry("precision",  kcalcdefaults.precision);
	config->writeEntry("fixedprecision",  kcalcdefaults.fixedprecision);
	config->writeEntry("fixed",  kcalcdefaults.fixed);

	config->writeEntry("style",(int)kcalcdefaults.style);
	config->writeEntry("beep", kcalcdefaults.beep);

	config->sync();
}

void TQtCalculator::display_selected(){

  if(calc_display->Button() == LeftButton){

    if(calc_display->isLit()){

      TQClipboard *cb = TQApplication::clipboard();
      cb->setText(calc_display->text());
      selection_timer->start(100);

    }
    else{

      selection_timer->stop();

    }

    invertColors();
  }
  else{

    TQClipboard *cb = TQApplication::clipboard();

    CALCAMNT result;
    result = (CALCAMNT) cb->text().toDouble();
    //    printf("%Lg\n",result);
    last_input = PASTE;
    DISPLAY_AMOUNT = result;
    UpdateDisplay();
  }

}

void TQtCalculator::selection_timed_out(){

  //  printf("selection timed out\n");
  selection_timer->stop();
  calc_display->setLit(false);
  invertColors();


}


void TQtCalculator::clear_status_label(){

  statusERRORLabel->setText("");
  status_timer->stop();
}

void TQtCalculator::setStatusLabel(const TQString& string){

  statusERRORLabel->setText(string);
  status_timer->start(3000,true);

}


void TQtCalculator::invertColors(){

  TQColor tmpcolor;

  if(calc_display->isLit()){
    tmpcolor = kcalcdefaults.backcolor;
    kcalcdefaults.backcolor = kcalcdefaults.forecolor;
    kcalcdefaults.forecolor = tmpcolor;
    set_colors();
    tmpcolor = kcalcdefaults.backcolor;
    kcalcdefaults.backcolor = kcalcdefaults.forecolor;
    kcalcdefaults.forecolor = tmpcolor;
  }
  else{
    set_colors();
    //printf("normal Colors\n");
  }
}

void TQtCalculator::closeEvent( TQCloseEvent*e )
{
    writeSettings();
    e->accept();
}

void TQtCalculator::set_colors(){


  TQPalette mypalette = (calc_display->palette()).copy();

  TQColorGroup cgrp = mypalette.active();
  TQColorGroup ncgrp(kcalcdefaults.forecolor,
                    cgrp.background(),
                    cgrp.light(),
                    cgrp.dark(),
                    cgrp.mid(),
                    kcalcdefaults.forecolor,
                    kcalcdefaults.backcolor);

  mypalette.setActive(ncgrp);
  mypalette.setDisabled(ncgrp);
  mypalette.setActive(ncgrp);

  calc_display->setPalette(mypalette);
  calc_display->setBackgroundColor(kcalcdefaults.backcolor);

}

void TQtCalculator::set_precision(){

  UpdateDisplay();
}

void TQtCalculator::temp_stack_next(){

  CALCAMNT *number;

  if( temp_stack.current() == temp_stack.getLast()){
        KNotifyClient::beep();
        return;
  }

  number = temp_stack.next();

  if(number == NULL){
       KNotifyClient::beep();
    return;
  }
  else{
    //    printf("Number: %Lg\n",*number);
    last_input = RECALL;
    DISPLAY_AMOUNT = *number;
    UpdateDisplay();

  }


}

void TQtCalculator::temp_stack_prev(){

  CALCAMNT *number;

  if( temp_stack.current() == temp_stack.getFirst()){
        KNotifyClient::beep();
        return;
  }

  number = temp_stack.prev();

  if(number == NULL){
    KNotifyClient::beep();
    return;
  }
  else{
    //    printf("Number: %Lg\n",*number);
    last_input = RECALL;
    DISPLAY_AMOUNT = *number;
    UpdateDisplay();

  }

}

#include "kcalc.moc"
