/***************************************************************************
 * eventslot.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "eventslot.h"

#include "variant.h"
#include "qtobject.h"

#include <tqmetaobject.h>
#include <tqucom_p.h> // for the TQt TQUObject API.

using namespace Kross::Api;

EventSlot::EventSlot(const TQString& name, TQObject* receiver, TQCString slot)
    : Event<EventSlot>(name)
    , m_receiver(receiver)
    , m_slot(slot) //TQObject::normalizeSignalSlot(slot)
{
}

EventSlot::~EventSlot()
{
}

const TQString EventSlot::getClassName() const
{
    return "Kross::Api::EventSlot";
}

Object::Ptr EventSlot::call(const TQString& /*name*/, List::Ptr arguments)
{
#ifdef KROSS_API_EVENTSLOT_CALL_DEBUG
    krossdebug( TQString("EventSlot::call() m_slot=%1 arguments=%2").arg(m_slot).arg(arguments->toString()) );
#endif

    TQString n = m_slot; //TODO name; //Variant::toString(args->item(0));

    if(n.startsWith("1")) // Remove prefix of TQ_SLOT-macros
        n.remove(0,1);

    int slotid = m_receiver->metaObject()->findSlot(n.latin1(), false);
    if(slotid < 0)
        throw Exception::Ptr( new Exception(TQString("No such slot '%1'.").arg(n)) );

    TQUObject* uo = QtObject::toTQUObject(n, arguments);
    m_receiver->tqt_invoke(slotid, uo); // invoke the slot
    delete [] uo;

    return new Variant( TQVariant(true) );
}

/*
TQCString EventSlot::getSlot(const TQCString& signal)
{
    TQString signature = TQString(signal).mid(1);
    int startpos = signature.find("(");
    int endpos = signature.findRev(")");
    if(startpos < 0 || startpos > endpos) {
        krosswarning( TQString("EventSlot::getSlot(%1) Invalid signal.").arg(signal) );
        return TQCString();
    }
    TQString signalname = signature.left(startpos);
    TQString params = signature.mid(startpos + 1, endpos - startpos - 1);
    //TQStringList paramlist = TQStringList::split(",", params);
    TQCString slot = TQString("callback(" + params + ")").latin1(); //normalizeSignalSlot();

    TQMetaObject* mo = metaObject();
    int slotid = mo->findSlot(slot, false);
    if(slotid < 0) {
        krossdebug( TQString("EventSlot::getSlot(%1) No such slot '%2' avaiable.").arg(signal).arg(slot) );
        return TQCString();
    }

    const TQMetaData* md = mo->slot(slotid, false);
    if(md->access != TQMetaData::Public) {
        krossdebug( TQString("EventSlot::getSlot(%1) The slot '%2' is not public.").arg(signal).arg(slot) );
        return TQCString();
    }

//TQMember* member = md->member;
//const TQUMethod *method = md->method;

    krossdebug( TQString("signal=%1 slot=%2 slotid=%3 params=%4 mdname=%5")
        .arg(signal).arg(slot).arg(slotid).arg(params).arg(md->name) );
    return TQCString("1" + slot); // Emulate the TQ_SLOT(...) macro by adding as first char a "1".
}

bool EventSlot::connect(EventManager* eventmanager, TQObject* senderobj, const TQCString& signal, TQString function, const TQCString& slot)
{
    if(m_sender && ! disconnect())
        return false;

    const TQCString& myslot = slot.isEmpty() ? getSlot(signal) : slot;
    if(! myslot)
        return false;

    if(! m_eventmanager) {
        EventSlot* eventslot = create(eventmanager);
        eventslot->connect(eventmanager, senderobj, signal, function, slot);
        m_slots.append(eventslot);
        krossdebug( TQString("EventSlot::connect(%1, %2, %3) added child EventSlot !!!").arg(senderobj->name()).arg(signal).arg(function) );
    }
    else {
        m_sender = senderobj;
        m_signal = signal;
        m_function = function;
        m_slot = myslot;
        if(! TQObject::connect((TQObject*)senderobj, signal, this, myslot)) {
            krossdebug( TQString("EventSlot::connect(%1, %2, %3) failed.").arg(senderobj->name()).arg(signal).arg(function) );
            return false;
        }
        krossdebug( TQString("EventSlot::connect(%1, %2, %3) successfully connected.").arg(senderobj->name()).arg(signal).arg(function) );
    }
    return true;
}

bool EventSlot::disconnect()
{
    if(! m_sender) return false;
    TQObject::disconnect((TQObject*)m_sender, m_signal, this, m_slot);
    m_sender = 0;
    m_signal = 0;
    m_slot = 0;
    m_function = TQString();
    return true;
}

void EventSlot::call(const TQVariant& variant)
{
    krossdebug( TQString("EventSlot::call() sender='%1' signal='%2' function='%3'")
                 .arg(m_sender->name()).arg(m_signal).arg(m_function) );

    Kross::Api::List* arglist = 0;

    TQValueList<Kross::Api::Object*> args;
    if(variant.isValid()) {
        args.append(Kross::Api::Variant::create(variant));
        arglist = Kross::Api::List::create(args);
    }

    try {
        m_eventmanager->m_scriptcontainer->callFunction(m_function, arglist);
    }
    catch(Exception& e) {
        //TODO add hadError(), getError() and setError()
        krossdebug( TQString("EXCEPTION in EventSlot::call('%1') type='%2' description='%3'").arg(variant.toString()).arg(e.type()).arg(e.description()) );
    }
}

void EventSlot::callback() {
    call(TQVariant()); }
void EventSlot::callback(short s) {
    call(TQVariant(s)); }
void EventSlot::callback(int i) {
    call(TQVariant(i)); }
void EventSlot::callback(int i1, int i2) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 )); }
void EventSlot::callback(int i1, int i2, int i3) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << i3 )); }
void EventSlot::callback(int i1, int i2, int i3, int i4) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << i3 << i4 )); }
void EventSlot::callback(int i1, int i2, int i3, int i4, int i5) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << i3 << i4 << i5 )); }
void EventSlot::callback(int i1, int i2, int i3, int i4, bool b) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << i3 << i4 << b )); }
void EventSlot::callback(int i1, bool b) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << b )); }
void EventSlot::callback(int i1, int i2, bool b) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << b )); }
void EventSlot::callback(int i1, int i2, const TQString& s) {
    call(TQVariant( TQValueList<TQVariant>() << i1 << i2 << s )); }
void EventSlot::callback(uint i) {
    call(TQVariant(i)); }
void EventSlot::callback(long l) {
    call(TQVariant((TQ_LLONG)l)); }
void EventSlot::callback(ulong l) {
    call(TQVariant((TQ_ULLONG)l)); }
void EventSlot::callback(double d) {
    call(TQVariant(d)); }
void EventSlot::callback(const char* c) {
    call(TQVariant(c)); }
void EventSlot::callback(bool b) {
    call(TQVariant(b)); }
void EventSlot::callback(const TQString& s) {
    call(TQVariant(s)); }
void EventSlot::callback(const TQString& s, int i) {
    call(TQVariant( TQValueList<TQVariant>() << s << i )); }
void EventSlot::callback(const TQString& s, int i1, int i2) {
    call(TQVariant( TQValueList<TQVariant>() << s << i1 << i2 )); }
void EventSlot::callback(const TQString& s, uint i) {
    call(TQVariant( TQValueList<TQVariant>() << s << i )); }
void EventSlot::callback(const TQString& s, bool b) {
    call(TQVariant( TQValueList<TQVariant>() << s << b )); }
void EventSlot::callback(const TQString& s, bool b1, bool b2) {
    call(TQVariant( TQValueList<TQVariant>() << s << b1 << b2 )); }
void EventSlot::callback(const TQString& s, bool b, int i) {
    call(TQVariant( TQValueList<TQVariant>() << s << b << i )); }
void EventSlot::callback(const TQString& s1, const TQString& s2) {
    call(TQVariant( TQValueList<TQVariant>() << s1 << s2 )); }
void EventSlot::callback(const TQString& s1, const TQString& s2, const TQString& s3) {
    call(TQVariant( TQValueList<TQVariant>() << s1 << s2 << s3 )); }
void EventSlot::callback(const TQStringList& sl) {
    call(TQVariant(sl)); }
void EventSlot::callback(const TQVariant& variant) {
    call(variant); }
*/
