//
// C++ Interface: accountsetupitem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ACCOUNTSETUPITEM_H
#define ACCOUNTSETUPITEM_H

//KDE headers
#include <tdelistview.h>
#include <tdeconfig.h>
#include <kurl.h>
#include <tdeapplication.h>

//KShowmail headers
#include "../constants.h"
#include "encryption.h"
#include "tdewalletaccess.h"

using namespace Encryption;

/**
 * @brief This class is used in ConfigAccounts to show the available accounts in the list view and to store an account setup.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class AccountSetupItem : public TDEListViewItem
{
  public:

    /**
     * General Constructor
     * @param parent the list view
     */
    AccountSetupItem( TDEListView* parent );

    /**
     * Constructor
     * @param parent the list view
     * @param name account name
     */
    AccountSetupItem( TDEListView* parent, TQString& name );

    /**
     * Destructor
     */
    ~AccountSetupItem();

    /**
     * Sets account name
     * @param name account name
     */
    void setAccountName( const TQString& name );

    /**
     * Returns the account name.
     * @return account name
     */
    TQString getAccountName() const;

    /**
     * Sets the server.
     * @param server server
     */
    void setServer( const TQString& server );

    /**
     * Returns the server.
     * @return server
     */
    TQString getServer() const;

    /**
     * Sets the protocol.
     * @param protocol protocol
     */
    void setProtocol( const TQString& protocol );

    /**
     * Returns the protocol.
     * @return protocol
     */
    TQString getProtocol() const;

    /**
     * Sets the port number.
     * @param port port number
     */
    void setPort( int port );

    /**
     * Returns the port number.
     * @return port number (0..65535)
     */
    int getPort() const;

    /**
     * Sets the user name.
     * @param user user name
     */
    void setUser( const TQString& user );

    /**
     * Returns the user name.
     * @return user name
     */
    TQString getUser() const;

    /**
     * Sets the password.
     * @param password password
     */
    void setPassword( const TQString& password );

    /**
     * Returns the password.
     * @return password
     */
    TQString getPassword() const;

    /**
     * Sets the password storage type.
     * See constants.h for valid values
     * @param type password storage type (CONFIG_VALUE_ACCOUNT_PASSWORD_DONT_SAVE, CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_FILE or CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_TDEWALLET)
     */
    void setPasswordStorageType( int type );

    /**
     * Returns the password storage type.
     * See constants.h for valid values (CONFIG_VALUE_ACCOUNT_PASSWORD_...)
     * @return storage type
     */
    int getPasswordStorageType() const;

    /**
     * Sets whether the account is active.
     * @param active true - account is active; false - account is not active
     */
    void setActive( bool active );

    /**
     * Returns whether the account is active.
     * @return true - account is active
     * @return false - account is not active
     */
    bool getActive() const;

    /**
     * Sets the transfer security.
     * See constants.h for valid values.
     * @param type transfer security type (CONFIG_VALUE_ACCOUNT_SECTRANSFER_NONE, CONFIG_VALUE_ACCOUNT_SECTRANSFER_SSL, CONFIG_VALUE_ACCOUNT_SECTRANSFER_TLS)
     */
    void setTransferSecurity( int type );

    /**
     * Returns the transfer security.
     * seee constants.h for valid values (CONFIG_VALUE_ACCOUNT_SECTRANSFER_...)
     * @return transfer security
     */
    int getTransferSecurity() const;

    /**
     * Saves this account into applications config.
     * All values are placed in a group called like the account name.
     */
    void save() const;

    /**
     * Loads the options of this account from the application config.
     */
    void load();


  private:

    /**
     * Connector to the configuration file
     */
    TDEConfig* config;

    /**
     * Account name
     */
    TQString _account;

    /**
     * Server
     */
    TQString _server;

    /**
     * Protocol
     */
    TQString _protocol;

    /**
     * Port
     */
    int _port;

    /**
     * User Name
     */
    TQString _user;

    /**
     * Password
     */
    TQString _password;

    /**
     * true - account is active
     */
    bool _active;

    /**
     * password storage type
     * Values are defined in constants.h (CONFIG_VALUE_ACCOUNT_PASSWORD_...)
     */
    int _passwordStorage;

    /**
     * transfer security
     * Values are defined in constants.h (CONFIG_VALUE_ACCOUNT_SECTRANSFER_...)
     */
    int _transferSecurity;

  protected:

    /**
     * Initializes the object.
     */
    void init();

};

#endif
