/***************************************************************************
                          kshowmailview.cpp  -  description
                             -------------------
    begin                : Sat May  6 12:13:57 MEST 2000
    copyright            : (C) 2000-2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de

     26 Sep 2002 - Allow for columns to be hidden. Allistar Melville
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for TQt
#include <tqprinter.h>
#include <tqpainter.h>
#include <tqmessagebox.h>
#include <tqkeycode.h>
#include <tqvaluelist.h>

#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kdebug.h>

// application specific includes
#include "kshowmailview.h"
#include "kshowmaildoc.h"
#include "kshowmail.h"

KshowmailView::KshowmailView(TQWidget *parent, const char *name):
	TQSplitter(Vertical, parent, name)
{
  setBackgroundMode( PaletteBase );
  setFocusPolicy( TQWidget::StrongFocus );

  //get application config object (kshowmailrc)
  config = TDEApplication::kApplication()->config();

  //load active pic for the account list
  m_pixOk = new TQPixmap( ::locate( "data", "kshowmail/pics/ok.png" ) );

  //create account list
  m_pListAccounts = new TDEListView( this, "accounts" );
  m_pListAccounts->setSelectionMode( TQListView::Extended );
  m_pListAccounts->setSorting( 1 ); // sort account column
  m_pListAccounts->setShowSortIndicator( true );
  m_pListAccounts->addColumn( i18n( "Active" ), DEFAULT_WIDTH_ACCOUNT_ACTIVE );
  m_pListAccounts->addColumn( i18n( "Account" ), DEFAULT_WIDTH_ACCOUNT_ACCOUNT );
  m_pListAccounts->addColumn( i18n( "Server" ), DEFAULT_WIDTH_ACCOUNT_SERVER );
  m_pListAccounts->addColumn( i18n( "User" ), DEFAULT_WIDTH_ACCOUNT_USER );
  m_pListAccounts->addColumn( i18n( "Messages" ), DEFAULT_WIDTH_ACCOUNT_MESSAGES );
  m_pListAccounts->addColumn( i18n( "Size" ), DEFAULT_WIDTH_ACCOUNT_SIZE );
  m_pListAccounts->setAllColumnsShowFocus( true );
  connect( m_pListAccounts, TQ_SIGNAL( rightButtonClicked( TQListViewItem*, const TQPoint &, int ) ), TQ_SLOT( slotAccountContext( TQListViewItem*, const TQPoint &, int ) ) );
  connect( m_pListAccounts, TQ_SIGNAL( clicked( TQListViewItem*, const TQPoint &, int) ), TQ_SLOT( slotAccountClicked( TQListViewItem*, const TQPoint &, int ) ) );

  //create message list
  m_pListMessages = new TDEListView( this, "messages" );
  m_pListMessages->setSelectionMode( TQListView::Extended );
  m_pListMessages->setAllColumnsShowFocus( true );
  m_pListMessages->setSorting( ShowListViewItem::_colNumber ); // sort number column
  m_pListMessages->setShowSortIndicator( true );
  m_pListMessages->addColumn( i18n( "Number" ), DEFAULT_WIDTH_MESSAGE_NUMBER );
  m_pListMessages->addColumn( i18n( "Account" ), DEFAULT_WIDTH_MESSAGE_ACCOUNT );
  m_pListMessages->addColumn( i18n( "From" ), DEFAULT_WIDTH_MESSAGE_FROM );
  m_pListMessages->addColumn( i18n( "To" ),  DEFAULT_WIDTH_MESSAGE_TO );
  m_pListMessages->addColumn( i18n( "Subject" ), DEFAULT_WIDTH_MESSAGE_SUBJECT );
  m_pListMessages->addColumn( i18n( "Date" ), DEFAULT_WIDTH_MESSAGE_DATE );
  m_pListMessages->addColumn( i18n( "Size" ), DEFAULT_WIDTH_MESSAGE_SIZE );
  m_pListMessages->addColumn( i18n( "Content" ), DEFAULT_WIDTH_MESSAGE_CONTENT );
  m_pListMessages->addColumn( i18n( "State" ),  DEFAULT_WIDTH_MESSAGE_STATE );
  connect( m_pListMessages, TQ_SIGNAL( rightButtonClicked( TQListViewItem*, const TQPoint &, int) ), TQ_SLOT( slotMessageContext( TQListViewItem*, const TQPoint &, int ) ) );
  connect( m_pListMessages, TQ_SIGNAL( doubleClicked( TQListViewItem* ) ), TQ_SLOT( slotMessageDoubleClicked( TQListViewItem* ) ) );
  connect( m_pListMessages, TQ_SIGNAL( clicked( TQListViewItem* ) ), TQ_SLOT( slotMessageClicked( TQListViewItem* ) ) );

  //read the geometry from the application config file
  readOptions();


}

KshowmailView::~KshowmailView()
{
	delete m_pListAccounts;
	delete m_pListMessages;
}

void KshowmailView::readOptions()
{
  //read splitter geometry
  config->setGroup ("Display Options");
  TQValueList<int> size;
  size.append (config->readNumEntry ("sizeaccounts", 40));
  size.append (config->readNumEntry ("sizemessages", 50));
  setSizes (size);

  // read layout of the list views
  m_pListAccounts->restoreLayout( config, CONFIG_GROUP_ACCOUNT_LIST );
  m_pListMessages->restoreLayout( config, CONFIG_GROUP_MESSAGE_LIST );
}

void KshowmailView::saveOptions (TDEConfig* config)
{
//	kdDebug () << "KshowmailView::saveOptions" << endl;
	config->setGroup("Display Options");
	//splitter
	TQValueList<int> size = sizes ();
	config->writeEntry ("sizeaccounts",  size [0]);
	config->writeEntry ("sizemessages",  size [1]);
	// layout
  m_pListAccounts->saveLayout ( config, CONFIG_GROUP_ACCOUNT_LIST );
  m_pListMessages->saveLayout (config, CONFIG_GROUP_MESSAGE_LIST );
}


void KshowmailView::slotMessageContext( TQListViewItem* pItem, const TQPoint&, int )
{
  if( pItem != NULL )
  {
    //get pointer to the main widget
    KShowMailApp* theApp = ( KShowMailApp * )parentWidget();

    //create and show popup menu
    TQWidget* w = theApp->factory()->container( "mail_context_popup", theApp );
    TQPopupMenu* popup = static_cast<TQPopupMenu*>( w );
    popup->exec( TQCursor::pos() );

    //select clicked item
    m_pListMessages->setSelected (pItem, true);
  }
}

void KshowmailView::slotAccountContext( TQListViewItem* pItem, const TQPoint&, int )
{
  if ( pItem != NULL )
  {
    //get pointer to the main widget
    KShowMailApp* theApp = ( KShowMailApp * )parentWidget();

    //create and show popup menu
    TQWidget* w = theApp->factory()->container( "account_context_popup", theApp );
    TQPopupMenu* popup = static_cast<TQPopupMenu*>( w );
    popup->exec( TQCursor::pos() );

    //select clicked item
    m_pListAccounts->setSelected( pItem, true );
  }
}

void KshowmailView::slotAccountClicked( TQListViewItem* pItem, const TQPoint&, int col )
{

  //get application config object (kshowmailrc)
  TDEConfig* config = TDEApplication::kApplication()->config();

  if( col == 0 )
  {
    KShowMailApp *theApp = (KShowMailApp *)parentWidget();
    ConfigElem* pElem = theApp->m_ConfigList.getSelectedAccount();

    if( pElem != NULL )
    {
      //get account name
      TQString name = pElem->getAccountName();

      //set config group
      config->setGroup( name );

      //toggle account active state
      pElem->setActive( !pElem->isActive() );

      if( pElem->isActive() )
      {
        //set active picture
        pItem->setPixmap( 0, *m_pixOk );

        //write active state into config file
        config->writeEntry( CONFIG_ENTRY_ACCOUNT_ACTIVE, true );
        config->sync();
      }
      else
      {
        //remove active picture
        pItem->setPixmap( 0, 0 );

        //write active state into config file
        config->writeEntry( CONFIG_ENTRY_ACCOUNT_ACTIVE, false );
        config->sync();
      }

      emit signalActiveChanged ();
    }
  }
}

void KshowmailView::slotMessageDoubleClicked (TQListViewItem* pItem)
{
	if (pItem)
	{
//		m_pListMessages->setSelected (pItem, true);

  	KShowMailApp *theApp=(KShowMailApp *) parentWidget();
		theApp->slotShowHeader ();
	}
}

void KshowmailView::slotMessageClicked (TQListViewItem* pItem)
{
  if (pItem)
	{
//		m_pListMessages->setSelected (pItem, true);

  	KShowMailApp *theApp=(KShowMailApp *) parentWidget();
		theApp->delayNextRefresh();
	}
}

void KshowmailView::clearMailListView( )
{
  m_pListMessages->clear();
}

ShowListViewItem* KshowmailView::insertMail( TQString& number, TQString& account, TQString& from, TQString& to, TQString& subject, TQString& date, TQString& size, TQString& content, TQString& state, TQString& time )
{
  //create item
  ShowListViewItem* item = new ShowListViewItem( m_pListMessages );

  //set content
  item->setNumber( number );
  item->setAccount( account );
  item->setFrom( from );
  item->setTo( to );
  item->setSubject( subject );
  item->setDate( date );
  item->setSize( size );
  item->setContent( content );
  item->setState( state );
  item->setTime( time );

  return item;
}

void KshowmailView::refreshSetup( )
{
  TQString ConfigEntryDisplay;     //entry of the config about show or hide column
  TQString ConfigEntrySavedWidth;  //entry of the config about saved width
  int DefaultWidth = 100;         //default width of the proceeded column
  bool DefaultDisplay = true;     //default show or hide of the proceeded column

  //set columns of the account list
  config->setGroup( CONFIG_GROUP_ACCOUNT_LIST );
  for( int column = 0; column <= 5; column++ )  //iterate over all columns
  {
    //get config entries and defaults of the proceeded column from the constants header
    switch( column )
    {
      case 0: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_ACTIVE;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_ACTIVE;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_ACTIVE;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_ACTIVE;
              break;

      case 1: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_ACCOUNT;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_ACCOUNT;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_ACCOUNT;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_ACCOUNT;
              break;

      case 2: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_SERVER;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_SERVER;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_SERVER;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_SERVER;
              break;

      case 3: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_USER;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_USER;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_USER;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_USER;
              break;

      case 4: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_MESSAGES;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_MESSAGES;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_MESSAGES;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_MESSAGES;
              break;

      case 5: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_ACCOUNT_SIZE;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_ACCOUNT_SIZE;
              DefaultWidth = DEFAULT_WIDTH_ACCOUNT_SIZE;
              DefaultDisplay = DEFAULT_DISPLAY_ACCOUNT_SIZE;
              break;
    } //end select

    //get desired column state
    bool showColumn = config->readBoolEntry( ConfigEntryDisplay, DefaultDisplay );

    //get currently column state
    bool curShowed = m_pListAccounts->columnWidth( column ) > 0;

    if( showColumn )
    {
      //column will be shown

      if( !curShowed )
      {
        //the column is currently not be shown

        //get saved width or take default width
        int savedWidth = config->readNumEntry( ConfigEntrySavedWidth, DefaultWidth );

        //set column width
        m_pListAccounts->setColumnWidth( column, savedWidth );
      }
        //else: the column is currently shown; do nothing
    }
    else
    {
      //column will not be shown

      if( curShowed )
      {
        //the column is currently shown

        //save current width
        config->writeEntry( ConfigEntrySavedWidth, m_pListAccounts->columnWidth( column ) );

        //hide column
        m_pListAccounts->hideColumn( column );
      }
        //else: the column is already hidden; do nothing
    }

  } //end column loop

  //set columns of the message list
  config->setGroup( CONFIG_GROUP_MESSAGE_LIST );
  for( int column = 0; column <= 8; column++ )  //iterate over all columns
  {
    //get config entries and defaults of the proceeded column from the constants header
    switch( column )
    {
      case 0: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_NUMBER;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_NUMBER;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_NUMBER;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_NUMBER;
              break;

      case 1: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_ACCOUNT;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_ACCOUNT;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_ACCOUNT;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_ACCOUNT;
              break;

      case 2: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_FROM;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_FROM;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_FROM;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_FROM;
              break;

      case 3: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_TO;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_TO;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_TO;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_TO;
              break;

      case 4: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_SUBJECT;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_SUBJECT;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_SUBJECT;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_SUBJECT;
              break;

      case 5: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_DATE;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_DATE;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_DATE;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_DATE;
              break;

      case 6: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_SIZE;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_SIZE;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_SIZE;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_SIZE;
              break;

      case 7: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_CONTENT;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_CONTENT;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_CONTENT;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_CONTENT;
              break;

      case 8: ConfigEntryDisplay = CONFIG_ENTRY_DISPLAY_MESSAGE_STATE;
              ConfigEntrySavedWidth = CONFIG_ENTRY_OLD_WIDTH_MESSAGE_STATE;
              DefaultWidth = DEFAULT_WIDTH_MESSAGE_STATE;
              DefaultDisplay = DEFAULT_DISPLAY_MESSAGE_STATE;
              break;

    } //end select

    //get desired column state
    bool showColumn = config->readBoolEntry( ConfigEntryDisplay, DefaultDisplay );

    //get currently column state
    bool curShowed = m_pListMessages->columnWidth( column ) > 0;

    if( showColumn )
    {
      //column will be shown

      if( !curShowed )
      {
        //the column is currently not be shown

        //get saved width or take default width
        int savedWidth = config->readNumEntry( ConfigEntrySavedWidth, DefaultWidth );

        //set column width
        m_pListMessages->setColumnWidth( column, savedWidth );
      }
        //else: the column is currently shown; do nothing
    }
    else
    {
      //column will not be shown

      if( curShowed )
      {
        //the column is currently shown

        //save current width
        config->writeEntry( ConfigEntrySavedWidth, m_pListMessages->columnWidth( column ) );

        //hide column
        m_pListMessages->hideColumn( column );
      }
        //else: the column is already hidden; do nothing
    }

  } //end column loop

  //save current layout
  m_pListAccounts->saveLayout( config, CONFIG_GROUP_ACCOUNT_LIST );
  m_pListMessages->saveLayout( config, CONFIG_GROUP_MESSAGE_LIST );
  config->sync();
}

#include "kshowmailview.moc"
