/*****************************************************************

Copyright (c) 2001 Carsten Pfeiffer <pfeiffer@kde.org>
              2001 Matthias Elter   <elter@kde.org>
              2001 Martijn Klingens <mklingens@yahoo.com>

              KShutDown Branch:
              2005 Stephen Ellwood
              2005 Konrad Twardowski <kdtonline@poczta.onet.pl>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

// TODO: 2.0: update handbook

#include <sys/types.h>

#include "lockout.h"

#include <tqlayout.h>
#include <tqtoolbutton.h>
#include <tqtooltip.h>

#include <dcopclient.h>
#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <kprocess.h>
#include <krun.h>

// plugin

extern "C"
{
	TDE_EXPORT KPanelApplet *init(TQWidget *parent, const TQString& configFile)
	{
		// share i18n with KShutDown
		TDEGlobal::locale()->insertCatalogue("kshutdown");

		return new Lockout(configFile, parent);
	}
}

// public

Lockout::Lockout(const TQString& configFile, TQWidget *parent)
	: KPanelApplet(
		configFile,
		KPanelApplet::Normal,
		0, // no standard actions
		parent,
		"kshutdownlockout"
	)
{
	setBackgroundOrigin(AncestorOrigin);
	setFrameStyle(Panel | Sunken);

	initActions();

	TDEPopupMenu *pm_actions = new TDEPopupMenu(this);
	pm_actions->insertTitle(SmallIcon("messagebox_warning"), i18n("No Delay"));
	_shutDownAction->plug(pm_actions);
	_rebootAction->plug(pm_actions);
	_lockScreenAction->plug(pm_actions);
	_logoutAction->plug(pm_actions);
	pm_actions->insertSeparator();
	_configureKShutDownAction->plug(pm_actions);

	TQVBoxLayout *layout = new TQVBoxLayout(this);
	TQToolButton *button = new TQToolButton(this);
	button->setAutoRaise(true);
	button->setBackgroundMode(X11ParentRelative);
	button->setPixmap(SmallIcon("system-log-out"));
	button->setPopupDelay(100);
	button->setMinimumSize(button->pixmap()->size());
	button->setSizePolicy(TQSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding));
	connect(button, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotShowKShutDown()));

	button->setPopup(pm_actions);
	layout->addWidget(button);

/*	// read configuration
	TDEConfig *config = this->config();
	config->setGroup("kshutdownlockout");
	_transparent = config->readBoolEntry("Transparent", true);
*/
	if (!kapp->dcopClient()->isAttached())
		kapp->dcopClient()->attach();
	connect(kapp, TQ_SIGNAL(iconChanged(int)), TQ_SLOT(slotIconChanged()));

	TQToolTip::add(
		this,
		"<qt>" \
		"<b>KShutDown</b><br><br>" +
		i18n("Click for KShutDown main window<br>Click and hold for menu") +
		"</qt>"
	);
}

Lockout::~Lockout()
{
	TDEGlobal::locale()->removeCatalogue("kshutdown");
}

int Lockout::heightForWidth(int/* width*/) const
{
	return sizeHint().height();
}

int Lockout::widthForHeight(int/* height*/) const
{
	return sizeHint().width();
}

// private

void Lockout::callKShutDown(const TQCString &function) {
	DCOPClient *client = kapp->dcopClient();
	if (!client->isApplicationRegistered("kshutdown")) {
		// run KShutDown
		TDEProcess *p = new TDEProcess();
		if (!p) {
			KMessageBox::error(0, i18n("Could not run KShutDown!"));

			return;
		}
		*p << "kshutdown";
		*p << "--init";
		if (!p->start(TDEProcess::Block))
			KMessageBox::error(0, i18n("Could not run KShutDown!"));
		delete p;
	}
	client->send("kshutdown", "KShutdownIface", function, "");
}

void Lockout::initActions() {
	TDEActionCollection *ac_shutDown = new TDEActionCollection(this, this);

	_lockScreenAction = new TDEAction(
		i18n("Lock Screen"), "system-lock-screen", TDEShortcut(),
		this, TQ_SLOT(slotLockScreen()),
		ac_shutDown, "kshutdown_lockscreen"
	);

	_logoutAction = new TDEAction(
		i18n("End Current Session"), "edit-undo", TDEShortcut(),
		this, TQ_SLOT(slotLogout()),
		ac_shutDown, "kshutdown_logout"
	);

	_rebootAction = new TDEAction(
		i18n("Restart Computer"), "reload", TDEShortcut(),
		this, TQ_SLOT(slotReboot()),
		ac_shutDown, "kshutdown_reboot"
	);

	_shutDownAction = new TDEAction(
		i18n("Turn Off Computer"), "system-log-out", TDEShortcut(),
		this, TQ_SLOT(slotShutDown()),
		ac_shutDown, "kshutdown_shutdown"
	);

	// standard actions

	_configureKShutDownAction = new TDEAction(
		i18n("&Configure KShutDown..."), "configure", TDEShortcut(),
		this, TQ_SLOT(slotConfigureKShutDown()),
		ac_shutDown, "options_configure"
	);
}

void Lockout::runCommand(const TQString &command) {
	pid_t pid = KRun::run(command, KURL::List());
	if (!pid)
		KMessageBox::error(0, i18n("Could not run KShutDown!"));
}

// private slots

void Lockout::slotCancel() {
	callKShutDown("cancel()");
}

void Lockout::slotConfigureKShutDown() {
	callKShutDown("configure()");
}

void Lockout::slotIconChanged() {
// FIXME: 2.0: update action icons
	setIcon(SmallIcon("system-log-out"));
}

void Lockout::slotLockScreen() {
	callKShutDown("lockScreen()");
}

void Lockout::slotLogout() {
	runCommand("kshutdown --init --confirm --logout");
}

void Lockout::slotReboot() {
	runCommand("kshutdown --init --confirm --reboot");
}

void Lockout::slotShowKShutDown() {
	callKShutDown("makeVisible()");
}

void Lockout::slotShutDown() {
	runCommand("kshutdown --init --confirm --shutdown");
}
#include "lockout.moc"
