#ifndef _SETUPWIZARD_H_
#define _SETUPWIZARD_H_
//=============================================================================
//
//   File : setupwizard.h
//   Creation date : Sat Oct  6 02:06:51 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================


#include <kvi_tal_wizard.h>
#include "kvi_tal_vbox.h"
#include "kvi_tal_hbox.h"
#include "kvi_tal_groupbox.h"
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqlineedit.h>
 #include <tqvbuttongroup.h>
#define KviTalVButtonGroup TQVButtonGroup
#include <tqradiobutton.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_selectors.h"

class KviSetupWizard;

class KviSetupPage : public TQWidget
{
	TQ_OBJECT
  
public:
	KviSetupPage(KviSetupWizard * w);
	~KviSetupPage();
public:
	KviTalVBox * m_pVBox;
	TQLabel * m_pPixmapLabel;
	TQLabel * m_pTextLabel;
   
};


#define THEME_APPLY_NONE 0
#define THEME_APPLY_HIRES 1
#define THEME_APPLY_LORES 2

class KviSetupWizard : public KviTalWizard
{
	TQ_OBJECT
  
public:
	KviSetupWizard();
	~KviSetupWizard();
public:
	TQPixmap       * m_pLabelPixmap;

	KviSetupPage  * m_pWelcome;
	KviSetupPage  * m_pLicense;
	KviSetupPage  * m_pDirectory;
	KviSetupPage  * m_pIdentity;
//	KviSetupPage  * m_pTheme;
	KviSetupPage  * m_pDesktopIntegration;
	KviSetupPage  * m_pServers;
	
	// Theme
	KviTalVButtonGroup * m_pThemeButtonGroup;

	TQRadioButton  * m_pThemeHiRes;
	TQRadioButton  * m_pThemeLoRes;
	TQRadioButton  * m_pThemeNone;
	
	// Welcome
	TQCheckBox     * m_pCreateUrlHandlers;
	TQCheckBox     * m_pCreateDesktopShortcut;
	
	//Dir
	TQLineEdit     * m_pDataPathEdit;
	TQLineEdit     * m_pIncomingPathEdit;
	KviTalVButtonGroup * m_pDirButtonGroup;
	TQRadioButton  * m_pDirUsePrev;
	TQRadioButton  * m_pDirUseNew;
#ifdef COMPILE_ON_WINDOWS
	TQRadioButton  * m_pDirMakePortable;
#endif
	//TQRadioButton  * m_pDirRestore;
	TQLineEdit     * m_pOldDataPathEdit;
	KviTalHBox         * m_pOldPathBox;
	KviTalHBox         * m_pNewPathBox;
	KviTalHBox         * m_pNewIncomingBox;
	
	//Identify
	TQComboBox        * m_pAgeCombo;
	TQComboBox        * m_pGenderCombo;
	
	KviStringSelector * m_pNickSelector;
	KviStringSelector * m_pRealNameSelector;
	KviStringSelector * m_pLocationSelector;
	KviStringSelector * m_pLanguagesSelector;
	//KviStringSelector * m_pOtherInfoSelector;
	
	//Servers
	//KviTalVButtonGroup * m_pServersButtonGroup;
	//TQRadioButton  * m_pServersChooseFromList;
	//TQRadioButton  * m_pServersSpecifyManually;
	//TQRadioButton  * m_pServersOpenIrcUrl;
	//TQRadioButton  * m_pServersLoadConfig;
#ifdef COMPILE_ON_WINDOWS
	TQString         m_szMircServerIniFile;
	TQRadioButton  * m_pUseMircServerList;
#endif
	
	TQString		    m_szServerConfigFile;
	TQString		    m_szServerUrl;
	TQString		    m_szServerHost;
	unsigned int        m_uServerPort;
	
	KviStringSelector * m_pServerHostSelector;
	KviStringSelector * m_pServerUrlSelector;
	//KviFileSelector   * m_pServerConfigSelector;
	KviUIntSelector   *m_pServerPortSelector;
	
protected:
	void makeLink();
	void setUrlHandlers();
	virtual void showEvent(TQShowEvent *e);
public slots:
	void chooseOldDataPath();
	void chooseDataPath();
	void chooseIncomingPath();
	virtual void accept();
	virtual void reject();
	
	void oldDirClicked();
	void newDirClicked();
	
	void oldDataTextChanged ( const TQString & );
	void newDataTextChanged ( const TQString & );
	void newIncomingTextChanged ( const TQString & );
};


#endif //_SETUPWIZARD_H_
