/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "generateopenvpnkeydialog.h"
#include <tdemessagebox.h>
#include <tdetempfile.h>
#include <tdelocale.h>
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <tqfile.h>
#include <tqurl.h>
#include <kurl.h>
#include <tqstring.h>

#include <iostream>
#include <unistd.h>
//
GenerateOpenvpnKeyDialog::GenerateOpenvpnKeyDialog(KVpncConfig *GlobalConfig,TQWidget *parent, const TQString& caption)
		: KDialogBase( parent, "Import_Cisco_PCF_profile", true, caption,
		               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	this->GlobalConfig=GlobalConfig;
	filename = "";
	genOk = false;
	main = new GenerateOpenvpnKeyDialogBase(this);
	setMainWidget(main);
	//main->setMinimumSize(main->sizeHint());

	main->FilenameUrlrequester->setFilter( "*.key" );

}

GenerateOpenvpnKeyDialog::~GenerateOpenvpnKeyDialog()
{
// 	delete generateOpenvpnKeyProcess;
	delete main;
}

void GenerateOpenvpnKeyDialog::accept()
{

	//filename="/etc/CiscoSystemsVPNClient/Profiles/hs_harz.pcf";
	filename = main->FilenameUrlrequester->url();
	if ( !filename.isEmpty() )
	{
		canAccept();
	}

	else
	{
		GlobalConfig->appendLogEntry( i18n("GenerateOpenvpnKeyDialog: empty file name"), GlobalConfig->error);
		KMessageBox::sorry( 0, i18n( "File name can not be empty!" ), i18n( "Empty File Name" ) );
	}
}


void GenerateOpenvpnKeyDialog::canAccept()
{

	/*
		TQFile f( filename );
		if ( !f.exists() )
		{
			KMessageBox::information( 0, i18n( "File not found." ), i18n( "No fFile" ) );
	 
			//		emit progress( 100 );
			return ;
		}*/
	generateOpenvpnKeyProcess = new TQProcess(this);
	generateOpenvpnKeyProcess->addArgument(GlobalConfig->pathToOpenvpn);
	generateOpenvpnKeyProcess->addArgument("--genkey");
	generateOpenvpnKeyProcess->addArgument("--secret");
	generateOpenvpnKeyProcess->addArgument(filename);

	connect( generateOpenvpnKeyProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErr() ) );
	connect( generateOpenvpnKeyProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdErr() ) );
	if ( !generateOpenvpnKeyProcess->start(env) )
	{
		KMessageBox::sorry( this, i18n( "Generating of %1 key failed!" ).arg( "openvpn" ) );
		GlobalConfig->appendLogEntry(i18n( "\"%1\" start failed!" ).arg( "openvpn" ),GlobalConfig->error);
	}
	else
	{
		GlobalConfig->appendLogEntry( i18n("Generating of %1 key was successful.").arg("openvpn"), GlobalConfig->info);
		genOk = true;
	}

	while (generateOpenvpnKeyProcess->isRunning())
	{
		sleep(1);
	}
	disconnect( generateOpenvpnKeyProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErr() ) );
	disconnect( generateOpenvpnKeyProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdErr() ) );
	delete generateOpenvpnKeyProcess;
	generateOpenvpnKeyProcess = 0L;
	if (genOk)
		KMessageBox::information( this, i18n( "Generating the key in \"%1\" was successful." ).arg( filename ) );
	else
		KMessageBox::sorry( this, i18n( "Generating the key in \"%1\" failed!" ).arg( filename ) );
	//std::cout << "accept" << std::endl;
	TQDialog::accept();
}

void GenerateOpenvpnKeyDialog::readStdErr()
{
	// while ( generateOpenvpnKeyProcess->canReadLineStderr() ) {
	// ProcessMsg_connect = generateOpenvpnKeyProcess->readLineStderr();
	TQString ProcessMsg_connect = TQString( generateOpenvpnKeyProcess->readStderr() );
	if (ProcessMsg_connect.isEmpty())
		ProcessMsg_connect = TQString( generateOpenvpnKeyProcess->readStdout() );

	if ( ProcessMsg_connect.find( "Permission denied", 0 , false ) > -1 )
	{
		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "[openvpn genkey err] " + ProcessMsg_connect, GlobalConfig->error );
		genOk = false;
		//}
	}
}

#include "generateopenvpnkeydialog.moc"
