/***************************************************************************
                           kxeprintsettings.h
                           ------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEPRINTSETTINGS_H
#define KXEPRINTSETTINGS_H

#include "kxesettings.h"

class KXEPrintSettingsPage;

/**
 * This class represents the group of configuration settings for
 * printing.
 *
 * @author Olaf Hartig
 */
class KXEPrintSettings : public KXESettings
{
	public:

		KXEPrintSettings( TQObject * pParent = 0, const char * pszName = 0 );

		// The following functions can be used to access this object's settings.
		TQString fontFamily() const { return m_strFontFamily; }
		int fontSize() const { return m_iFontSize; }
		int indentSteps() const { return m_iIndentSteps; }
		bool hasHeader() const { return m_bWithHeader; }
		bool hasFooter() const { return m_bWithFooter; }

		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageName() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageHeader() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageIcon() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQWidget * dialogPage( TQFrame * pParent );

	protected:

		/**
		 * Derived from @ref KXESettings
		 */
		virtual void write( TDEConfig * ) const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void read( const TDEConfig * );
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void setFromPage();
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void updatePage() const;

		// the settings itself
		TQString m_strFontFamily;
		int m_iFontSize;
		int m_iIndentSteps;
		bool m_bWithHeader;
		bool m_bWithFooter;

		/**
		 * the corresponding configuration dialog page
		 * It is created on demand by @ref dialogPage.
		 */
		KXEPrintSettingsPage * m_pDialogPage;

};

#endif
