/*************************************************************************** 
                          xsldbgglobalvariablesimpl.cpp  -  description 
                             ------------------- 
    begin                : Sat Jan 5 2002 
    copyright            : (C) 2002 by Keith Isdale 
    email                : k_isdale@tpg.com.au 
 ***************************************************************************/ 
 
/*********************************************************************************** 
 *                                                                         										* 
 *   This program is free software; you can redistribute it and/or modify       * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or         * 
 *   (at your option) any later version.                                   							* 
 *                                                                         										* 
 ************************************************************************************/ 
 
#include <tqlistview.h> 
#include <tqlineedit.h> 
 
#include "xsldbgglobalvariablesimpl.h" 
#include "xsldbgdebugger.h" 
#include "xsldbggloballistitem.h" 
 
 
XsldbgGlobalVariablesImpl::XsldbgGlobalVariablesImpl(XsldbgDebugger *debugger, 
	TQWidget *parent /*=0*/, const char *name /*=0*/) 
		:  XsldbgGlobalVariables(parent, name),  XsldbgDialogBase() 
{	 
	this->debugger = debugger; 
	connect(debugger, TQ_SIGNAL(globalVariableItem(TQString /*name */, TQString /* fileName */, int /*lineNumber */)), 
		this, TQ_SLOT(slotProcGlobalVariableItem(TQString /*name */, TQString /* fileName */, int /*lineNumber */))); 
	connect( varsListView,  TQ_SIGNAL(selectionChanged(TQListViewItem *)), 
						this, TQ_SLOT(selectionChanged(TQListViewItem*))); 
	show(); 
} 
 
 
XsldbgGlobalVariablesImpl::~XsldbgGlobalVariablesImpl(){ 
    debugger = 0L; 
} 
 
void XsldbgGlobalVariablesImpl::slotProcGlobalVariableItem(TQString name , TQString fileName, int lineNumber) 
{ 
	if (name.isNull()) 
		  varsListView->clear(); 
	else{ 
		varsListView->insertItem(new XsldbgGlobalListItem(varsListView, 
																					fileName, lineNumber, name)); 
	} 
 
} 
 
 
void XsldbgGlobalVariablesImpl::selectionChanged(TQListViewItem *item) 
{ 
	XsldbgGlobalListItem *globalItem = dynamic_cast<XsldbgGlobalListItem*>(item); 
	if (globalItem != 0 && debugger != 0) { 
		debugger->gotoLine(globalItem->getFileName(), globalItem->getLineNumber());	 
	} 
} 
 
void XsldbgGlobalVariablesImpl::refresh() 
{
    if (debugger != 0) 
	debugger->fakeInput("globals -q", true) ; 
} 
 
void XsldbgGlobalVariablesImpl::slotEvaluate()
{
  if (debugger != 0L)
    debugger->slotCatCmd( expressionEdit->text() );
} 
 
 

#include "xsldbgglobalvariablesimpl.moc"
