/* ============================================================
 * File   : imagedialog.h
 * Authors: KIPI team developers (see AUTHORS files for details)
 *	    
 * Date   : 2004-05
 * Description : an image files selector dialog.
 *
 * Copyright 2004 by the KIPI team
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */

#ifndef IMAGEDIALOG_H
#define IMAGEDIALOG_H

// TQt includes.

#include <tqvaluelist.h>
#include <tqwidget.h>

// KDE includes.

#include <kurl.h>
#include <kdialogbase.h>

// LibKipi includes.

#include "libkipi/interface.h"
#include "libkipi/imagecollection.h"
#include "libkipi/libkipi_export.h"

class TQListViewItem;

class KFileItem;
class TDEListView;

namespace KIPI
{


class LIBKIPI_EXPORT ImageDialog : public KDialogBase 
{
TQ_OBJECT
  
    
    class Private;
    
public:

    ImageDialog(TQWidget*, Interface*, bool singleSelection=false);
    ~ImageDialog();

    KURL       url() const;
    KURL::List urls() const;
    
    static KURL getImageURL(TQWidget*, Interface*);
    static KURL::List getImageURLs(TQWidget*, Interface*);

private slots:

    void fillImageList(TQListViewItem*);
    void slotImageSelected(TQListViewItem*);
    void slotImagesSelected();
    void slotGotPreview(const KFileItem* , const TQPixmap&);
    void slotHelp( void );
    void slotInitialShow();

private:
    Private* d;
};

} // namespace KIPI

#endif /* IMAGECOLLECTIONDIALOG_H */
