/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Dario Freddi <drf@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "polkit-tqt-gui-actionbuttons.h"
#include "polkit-tqt-gui-actionbuttons_p.h"

#include <tqbutton.h>
#include <tqstring.h>
#include <tqvaluelist.h>


namespace PolkitTQt
{

namespace Gui
{

ActionButtons::ActionButtons(TQValueList<TQButton*> &buttons, const TQString &actionId,
        TQObject *parent) : ActionButton(*new ActionButtonPrivate(), actionId, parent)
{
  setButtons(buttons);
}

ActionButtons::~ActionButtons()
{
}

void ActionButtons::setButtons(TQValueList<TQButton*> &buttons)
{
  for (TQButton *&ent : buttons)
  {
    addButton(ent);
  }
}

TQValueList<TQButton*> ActionButtons::buttons() const
{
  return d->buttons;
}

void ActionButtons::addButton(TQButton *button)
{
  d->addButton(button);
}

void ActionButtons::removeButton(TQButton *button)
{
  d->removeButton(button);
}

}

}

#include "polkit-tqt-gui-actionbuttons.moc"
