# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2002,2003 Colin Walters <walters@debian.org>
# Copyright © 2011-2012, 2014, 2016-2017 Jonas Smedegaard <dr@jones.dk>
# Description: Sets core language variables, such as CFLAGS and CXXFLAGS
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_class_langcore
_cdbs_class_langcore = 1

include $(_cdbs_rules_path)/buildvars.mk$(_cdbs_makefile_suffix)

# Resolve our defaults
# GNU Make doesn't export current environment in $(shell ..) function.
# We need at least some of the DEB_* flags for dpkg-buildflags, so
# extract them from the defined variables.  Sadly there seems to be no
# way to just get all exported variables.
#
# massage dpkg-buildflag output:
#  * filter to include only lines matching expected format
#  * transform prefix, e.g. "export LDFLAGS := ..." -> "LDFLAGS ?= ..."
$(shell \
	$(call cdbs_set_nondefaultvars,\
		$(foreach flag,$(shell dpkg-buildflags --list),\
			$(foreach op,SET STRIP APPEND PREPEND,\
				DEB_$(flag)_$(op) DEB_$(flag)_MAINT_$(op)))\
		DEB_BUILD_OPTIONS DEB_BUILD_MAINT_OPTIONS) \
	dpkg-buildflags --export=make \
	| perl -pe 's/^export\s+//; s/:=/?=/' \
	> debian/_cdbs_buildflags.mk )
-include debian/_cdbs_buildflags.mk
$(shell rm -f debian/_cdbs_buildflags.mk)

$(eval $(and $(cdbs_crossbuild),$(filter default,$(origin CC)),\
	CC := $(DEB_HOST_GNU_TYPE)-gcc))
$(eval $(and $(cdbs_crossbuild),$(filter default,$(origin CXX)),\
	CXX := $(DEB_HOST_GNU_TYPE)-g++))

ifneq (,$(filter parallel=%,$(DEB_BUILD_OPTIONS)))
	DEB_PARALLEL_JOBS ?= $(patsubst parallel=%,%,$(filter parallel=%,$(DEB_BUILD_OPTIONS)))
endif

endif
