
#ifndef DNDLISTBOX_H
#define DNDLISTBOX_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tdelistbox.h>
#include <tqptrlist.h>
#include <tqstringlist.h>
#include "baghirasidebariface.h"

class DCOPClient;
class TQDragEnterEvent;
class TQDragMoveEvent;
class TQDragLeaveEvent;
class TQDropEvent;
class TQKeyEvent;
class TQPoint;
class TDEPopupMenu;
class LinkConfig;
class ListBoxLink;
class ListBoxDevice;
class TQResizeEvent;

class ResizingLinkBox : public TDEListBox
{
    TQ_OBJECT
    
public:
   ResizingLinkBox( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
   ~ResizingLinkBox(){};
   void insertItem( const TQListBoxItem *, int index=-1 );
   void insertItem( const TQListBoxItem *lbi, const TQListBoxItem *after );
   void insertItem( const TQString & icon, const TQString & title, const TQString & url );
   void insertItem( const TQString &text, int index=-1 )
   {
      insertItem( new TQListBoxText(text), index );
   }
   void insertItem( const TQPixmap &pixmap, int index=-1 )
   {
      insertItem( new TQListBoxPixmap(pixmap), index );
   }
   void insertItem( const TQPixmap &pixmap, const TQString &text, int index=-1 ){
      insertItem( new TQListBoxPixmap(pixmap, text), index );
   }
   
   void removeItem( int index );
protected:
   void mousePressEvent ( TQMouseEvent * );
   void mouseReleaseEvent ( TQMouseEvent * );
   void contentsWheelEvent ( TQWheelEvent * );
   TDEPopupMenu *popupMenu;
   uint size_;
private slots:
   void setIconSize(int);
signals:
   void itemNumberChanged(bool);
   void scrolled(int,int);
};

class MediaListBox : public ResizingLinkBox, virtual public BaghiraSidebarIface
{
   TQ_OBJECT
public:
   MediaListBox( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
   ~MediaListBox();
   ListBoxDevice *createListBoxDevice(TQStringList & deviceProperties, uint n = 0);
   void mediumAdded(const TQString &name);
   void mediumRemoved(const TQString &name);
   void mediumChanged(const TQString &name);
   int index (const TQString & name );
   void removeItem( int index );
protected:
   void mousePressEvent ( TQMouseEvent * );
   void resizeEvent ( TQResizeEvent * );
private:
   TDEPopupMenu *devicePopup;
   DCOPClient *client;
   ListBoxDevice *currentFloppy;
   typedef TQPtrList<ListBoxDevice> DeviceList;
   DeviceList deviceList;
   TQStringList hiddenDevices;
private slots:
   void kfloppy();
   void toggleDevice(int id);
};

class DnDListBox : public ResizingLinkBox
{
    TQ_OBJECT
    
public:
     DnDListBox( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );

    /** destructor */
    ~DnDListBox();
   void poof(ListBoxLink *link);

protected:
   void mousePressEvent ( TQMouseEvent * );
   void mouseReleaseEvent ( TQMouseEvent * );
   void mouseMoveEvent ( TQMouseEvent * e );
   void dragEnterEvent ( TQDragEnterEvent * );
//    void dragMoveEvent ( TQDragMoveEvent * );
//    void dragLeaveEvent ( TQDragLeaveEvent * );
   void dropEvent ( TQDropEvent * );
   void startDrag();
private:
   ListBoxLink *currentItem; //TODO: unshadow int TDEListBox::currentItem()
   LinkConfig *dialog;
   bool dragging_;
   void pasteURL(int mode, TQListBoxItem *after = 0);
   bool _draggedMe;
   int _poofIndex;
   TQPixmap *_poofPix;
   TQPixmap *_poofAnimPix;
   TQWidget *_poof;
private slots:
   void configureLink();
   void updateLink();
   void runPoof();
};

#endif
