/*
Copyright (C) 2006 Michael Lentner <michaell@gmx.net>

based on the Plastik configuration dialog:
Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

based on the Keramik configuration dialog:
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#ifndef DOMINO_CONF_H
#define DOMINO_CONF_H

#include <../domino/domino.h>
#include <tqlineedit.h>


class DSpinBox;
class PreviewCheckBox;
class PreviewRadioButton;
class PreviewTabBar;
class IndicatorPrevButton;
class IndicatorPrevWidget;
class DominoKTabWidget;
class TextEffectPrevWidget;
class TextEffectPrevButton;
class DominoKTabPrevWidget;
class TabWidgetIndicator;
class DominoStyleConfig;

DominoStyleConfig* styleConfig;

struct DSurface;

class SchemeEntry {
	public:
		SchemeEntry(const TQString &_fileName, const TQString &_schemeName, const bool &_deletable)
	: fileName(_fileName), schemeName(_schemeName), deletable(_deletable) { }
		
		TQString getSchemeName() const { return schemeName; }
		TQString getFileName() const { return fileName; }
		bool isDeletable() const { return deletable; }
		
	private:
		TQString fileName;
		TQString schemeName;
		bool deletable;
};

class SchemeList : public TQPtrList<SchemeEntry> {
	public:
		SchemeList()
			{ setAutoDelete(true); }
};

class DominoStyleConfig: public TQWidget
{
	TQ_OBJECT
public:
	DominoStyleConfig(TQWidget* parent);
	~DominoStyleConfig();
	
	TQFrame* frame3;
	TQListBox* listBox1;
	TQHeader* header1;

	DominoKTabWidget* tabWidget2;
	TQWidget* tab1;
	TQGroupBox* groupBox22;
	TQLabel* textLabel1_2;
	KColorButton* kColorButton27_2;
	TQGroupBox* groupBox10_2_2_2;
	TQPushButton* pushButton16;
	TQGroupBox* groupBox8_2_2_2;
	TQLabel* textLabel4_3_2_2_2;
	DSpinBox* spinBox2_2_2_2_2;
	TQLabel* textLabel2_2_2_2_2;
	KColorButton* kColorButton1_2_2_2_2;
	TQLabel* textLabel3_3_2_2_2;
	DSpinBox* spinBox1_2_2_2_2;
	TQLabel* textLabel1_4_2_2_2;
	KColorButton* kColorButton2_4_2_2_2;
	TQGroupBox* groupBox9_2_2_2;
	TQLabel* textLabel4_4_2_2_2;
	DSpinBox* spinBox2_3_2_2_2;
	TQLabel* textLabel3_4_2_2_2;
	DSpinBox* spinBox1_3_2_2_2;
	KColorButton* kColorButton1_3_2_2_2;
	KColorButton* kColorButton2_5_2_2_2;
	TQLabel* textLabel1_5_2_2_2;
	TQLabel* textLabel2_3_2_2_2;
	TQLabel* textLabel7_4;
	TQComboBox* comboBox3_4;
	TQPushButton* pushButton4_4;
	TQWidget* tab2;
	TQGroupBox* groupBox22_2;
	TQGroupBox* groupBox8_2_2_2_2;
	TQLabel* textLabel4_3_2_2_2_2;
	DSpinBox* spinBox2_2_2_2_2_2;
	TQLabel* textLabel2_2_2_2_2_2;
	KColorButton* kColorButton1_2_2_2_2_2;
	TQLabel* textLabel3_3_2_2_2_2;
	DSpinBox* spinBox1_2_2_2_2_2;
	TQLabel* textLabel1_4_2_2_2_2;
	KColorButton* kColorButton2_4_2_2_2_2;
	TQGroupBox* groupBox9_2_2_2_2;
	TQLabel* textLabel4_4_2_2_2_2;
	DSpinBox* spinBox2_3_2_2_2_2;
	TQLabel* textLabel3_4_2_2_2_2;
	DSpinBox* spinBox1_3_2_2_2_2;
	KColorButton* kColorButton1_3_2_2_2_2;
	KColorButton* kColorButton2_5_2_2_2_2;
	TQLabel* textLabel1_5_2_2_2_2;
	TQLabel* textLabel2_3_2_2_2_2;
	TQLabel* textLabel1_2_2;
	KColorButton* kColorButton27_2_2;
	TQGroupBox* groupBox10_2_2_2_2;
	TQComboBox* comboBox17;
	DSpinBox* spinBox44;
	TQLabel* textLabel7_4_2;
	TQComboBox* comboBox3_4_2;
	TQPushButton* pushButton4_4_2;
	TQWidget* tab3;
	TQGroupBox* groupBox22_2_2;
	TQGroupBox* groupBox8_2_2_2_2_4;
	TQLabel* textLabel4_3_2_2_2_2_4;
	DSpinBox* spinBox2_2_2_2_2_2_4;
	TQLabel* textLabel2_2_2_2_2_2_4;
	KColorButton* kColorButton1_2_2_2_2_2_4;
	TQLabel* textLabel3_3_2_2_2_2_4;
	DSpinBox* spinBox1_2_2_2_2_2_4;
	TQLabel* textLabel1_4_2_2_2_2_4;
	KColorButton* kColorButton2_4_2_2_2_2_4;
	TQGroupBox* groupBox9_2_2_2_2_4;
	TQLabel* textLabel4_4_2_2_2_2_4;
	DSpinBox* spinBox2_3_2_2_2_2_4;
	TQLabel* textLabel3_4_2_2_2_2_4;
	DSpinBox* spinBox1_3_2_2_2_2_4;
	KColorButton* kColorButton1_3_2_2_2_2_4;
	KColorButton* kColorButton2_5_2_2_2_2_4;
	TQLabel* textLabel1_5_2_2_2_2_4;
	TQLabel* textLabel2_3_2_2_2_2_4;
	TQGroupBox* groupBox10_2_2_2_2_4;
	TQScrollBar* scrollBar5;
	TQScrollBar* scrollBar6;
	KColorButton* kColorButton27_2_2_2;
	TQLabel* textLabel1_2_2_2;
	TQComboBox* comboBox7;
	TQLabel* textLabel7_4_2_3;
	TQComboBox* comboBox3_4_2_3;
	TQPushButton* pushButton4_4_2_3;
	TQWidget* tab4;
	TQGroupBox* groupBox22_2_2_3;
	KColorButton* kColorButton27_2_2_2_2;
	TQLabel* textLabel1_2_2_2_2;
	TQGroupBox* groupBox10_2_2_2_2_4_3;
	TQGroupBox* groupBox8_2_2_2_2_4_3;
	TQLabel* textLabel4_3_2_2_2_2_4_3;
	DSpinBox* spinBox2_2_2_2_2_2_4_3;
	TQLabel* textLabel2_2_2_2_2_2_4_3;
	KColorButton* kColorButton1_2_2_2_2_2_4_3;
	TQLabel* textLabel3_3_2_2_2_2_4_3;
	DSpinBox* spinBox1_2_2_2_2_2_4_3;
	TQLabel* textLabel1_4_2_2_2_2_4_3;
	KColorButton* kColorButton2_4_2_2_2_2_4_3;
	TQGroupBox* groupBox9_2_2_2_2_4_3;
	TQLabel* textLabel4_4_2_2_2_2_4_3;
	DSpinBox* spinBox2_3_2_2_2_2_4_3;
	TQLabel* textLabel3_4_2_2_2_2_4_3;
	DSpinBox* spinBox1_3_2_2_2_2_4_3;
	KColorButton* kColorButton1_3_2_2_2_2_4_3;
	KColorButton* kColorButton2_5_2_2_2_2_4_3;
	TQLabel* textLabel1_5_2_2_2_2_4_3;
	TQLabel* textLabel2_3_2_2_2_2_4_3;
	TQLabel* textLabel7_4_2_3_3;
	TQComboBox* comboBox3_4_2_3_3;
	TQPushButton* pushButton4_4_2_3_3;
	TQWidget* tab5;
	TQGroupBox* groupBox22_2_2_3_2;
	TQGroupBox* groupBox8_2_2_2_2_4_3_2;
	TQLabel* textLabel4_3_2_2_2_2_4_3_2;
	DSpinBox* spinBox2_2_2_2_2_2_4_3_2;
	TQLabel* textLabel2_2_2_2_2_2_4_3_2;
	KColorButton* kColorButton1_2_2_2_2_2_4_3_2;
	TQLabel* textLabel3_3_2_2_2_2_4_3_2;
	DSpinBox* spinBox1_2_2_2_2_2_4_3_2;
	TQLabel* textLabel1_4_2_2_2_2_4_3_2;
	KColorButton* kColorButton2_4_2_2_2_2_4_3_2;
	KColorButton* kColorButton27_2_2_2_3;
	TQLabel* textLabel1_2_2_2_3;
	TQGroupBox* groupBox10_2_2_2_2_4_3_2;
	PreviewRadioButton* radioButton2;
	PreviewCheckBox* checkBox2;
	TQGroupBox* groupBox9_2_2_2_2_4_3_2;
	TQLabel* textLabel4_4_2_2_2_2_4_3_2;
	DSpinBox* spinBox2_3_2_2_2_2_4_3_2;
	TQLabel* textLabel3_4_2_2_2_2_4_3_2;
	DSpinBox* spinBox1_3_2_2_2_2_4_3_2;
	KColorButton* kColorButton1_3_2_2_2_2_4_3_2;
	KColorButton* kColorButton2_5_2_2_2_2_4_3_2;
	TQLabel* textLabel1_5_2_2_2_2_4_3_2;
	TQLabel* textLabel2_3_2_2_2_2_4_3_2;
	TQLabel* textLabel7_4_2_3_3_2;
	TQComboBox* comboBox3_4_2_3_3_2;
	TQPushButton* pushButton4_4_2_3_3_2;
// 	KTabWidget *prevTopTabWidget;
// 	KTabWidget *prevBottomTabWidget;
	TabWidgetIndicator* prevBottomPage1;
	TabWidgetIndicator* prevBottomPage2;
	TabWidgetIndicator* prevBottomPage3;
	TabWidgetIndicator* prevTopPage1;
	TabWidgetIndicator* prevTopPage2;
	TabWidgetIndicator* prevTopPage3;
	PreviewTabBar* tabBarBottom;
	PreviewTabBar* tabBarTop;
	TQHBoxLayout* tabComboLayout;
	
	
	// tab 3 - load/save
// 	KTabWidget* tabWidget3;
	TQWidget* tab;
	TQGroupBox* groupBox_ls;
	TQListView* listView_ls;
	TQPushButton* loadButton;
	TQPushButton* saveButton;
	TQPushButton* deleteButton;
	TQPushButton* importButton;
	TQWidget* tab_2;
	
	// focusIndicator
	TQGroupBox* indicateFocusFrame;
	TQCheckBox* indicateFocus;
	TQLabel* labelIndicatorColor;
	TQLabel* labelIndicatorBtnColor;
	IndicatorPrevWidget* indicatorPrevWidget;
	IndicatorPrevButton* indicatorPrevButton;
	TQLabel* labelIndicatorColorOpacity;
	TQLabel* labelIndicatorBtnColorOpacity;
	
	TQGroupBox* gb1;
	TQGroupBox* gb2;
	TQGroupBox* gb3;
	
	// text effect
	TQGroupBox* textEffectFrame;
	TQLabel* labelTextEffectColor;
	TQLabel* labelTextEffectButtonColor;
	TextEffectPrevWidget* textEffectPrevWidget;
	TextEffectPrevButton* textEffectPrevButton;
	TQLabel* labelTextEffectColorOpacity;
	TQLabel* labelTextEffectButtonColorOpacity;
	TQLabel* labelTextEffectPos;
	TQLabel* labelTextEffectButtonPos;
	
	TQCheckBox* drawButtonSunkenShadow;
	
	TQLabel* buttonTypLabel;
	TQLabel* labelButtonContourColors;
	TQPushButton* buttonContourPrevButton;
	TQLabel* labelPopupMenuOptions;
	
signals:
	void changed(bool);

public slots:
	void save();
	void defaults();
	void userLoadTabConfig();
	
protected slots:
	void updateChanged();
	virtual void languageChange();
	void userLoadScrollBarConfig();
	void testCanDecode(const TQDragMoveEvent * e, bool & accept);
	
private slots:
	void btnPv1(const TQColor&);
	void btnPv2(const TQColor&);
	void btnPv3(const TQColor&);
	void btnPv4(const TQColor&);
	void btnPv5(const TQColor&);
	void btnPv6(int);
	void btnPv7(int);
	void btnPv8(int);
	void btnPv9(int);
	
	void hPv1(const TQColor&);
	void hPv2(const TQColor&);
	void hPv3(const TQColor&);
	void hPv4(const TQColor&);
	void hPv5(const TQColor&);
	void hPv6(int);
	void hPv7(int);
	void hPv8(int);
	void hPv9(int);
	
	void chbPv1(const TQColor&);
	void chbPv2(const TQColor&);
	void chbPv3(const TQColor&);
	void chbPv4(const TQColor&);
	void chbPv5(const TQColor&);
	void chbPv6(int);
	void chbPv7(int);
	void chbPv8(int);
	void chbPv9(int);
	
	void sbPv1(const TQColor&);
	void sbPv2(const TQColor&);
	void sbPv3(const TQColor&);
	void sbPv4(const TQColor&);
	void sbPv5(const TQColor&);
	void sbPv6(int);
	void sbPv7(int);
	void sbPv8(int);
	void sbPv9(int);
	
	void tabPv1(const TQColor&col);
	void tabPv2(const TQColor&col);
	void tabPv3(const TQColor&col);
	void tabPv4(const TQColor&col);
	void tabPv5(const TQColor&col);
	void tabPv6(int);
	void tabPv7(int);
	void tabPv8(int);
	void tabPv9(int);
	
	
	void slotLoad();
	void slotSave();
	void slotDelete();
	void slotImport();
	void slotDelPerm(TQListViewItem*);
	void scrollBar1GradientChanged();
	void scrollBar2GradientChanged();
	void scrollBarNumGradientsChanged(int g=0);
	void btn1GradientChanged();
	void btn2GradientChanged();
	void btnNumGradientsChanged(int g=0);
	void header1GradientChanged();
	void header2GradientChanged();
	void headerNumGradientsChanged(int g=0);
	void checkItem1GradientChanged();
	void checkItem2GradientChanged();
	void checkItemNumGradientsChanged(int g=0);
	void tab1GradientChanged();
	void tab2GradientChanged();
	void tabNumGradientsChanged(int g=0);
	
	void copyColorsToButton();
	void copyColorsToTab();
	void copyColorsToScrollBar();
	void copyColorsToHeader();
	void copyColorsToCheckItem();
	
	void resetGroupBoxBackgroundColor();
	
	void textEffectModeChanged();
	void indicatorModeChanged();
	
	void grValueLabelNum(int num);
	void updateButtonContourSettings();
	void updateTextEffectSettings();
	void updateCheckItemIndicators();
	void updateFocusIndicatorSettings();
	void updateGroupBoxSettings();
	
	void rubberSelChanged(int);
	void updateArgbRubberOptions(bool);

protected:
	
	bool hasCompositeExtension;
	
	TQVBoxLayout* frame3Layout;
	TQVBoxLayout* layout1;
	TQGroupBox* grFrame;
	TQLabel* grValueLabel;
	
	//We store settings directly in widgets to
	//avoid the hassle of sync'ing things
	TQCheckBox* animateProgressBar;
	TQCheckBox* drawTriangularExpander;
	TQCheckBox* customCheckMarkColor;
	KColorButton* checkMarkColor;
	TQCheckBox* customToolTipColor;
	KColorButton* toolTipColor;
	TQCheckBox* highlightToolBtnIcons;
	TQCheckBox* toolBtnAsBtn;
	
	TQLabel* labelRubberOptions;
	TQRadioButton* argbRubber;
	TQRadioButton* lineRubber;
	TQRadioButton* distRubber;
	int rubberBandType;
	
	TQLabel* labelArgbRubberColor;
	TQLabel* labelArgbRubberOpacity;
	KColorButton* argbRubberColor;
	DSpinBox* argbRubberOpacity;
	
	TQCheckBox* smoothScrolling;
	DSpinBox* buttonHeightAdjustment;
	TQLabel* buttonHeightAdjustmentLabel;
	TQCheckBox* customPopupMenuColor;
	KColorButton* popupMenuColor;
	TQCheckBox* centerTabs;
	TQCheckBox* customSelMenuItemColor;
	KColorButton* selMenuItemColor;
	TQCheckBox* drawPopupMenuGradient;
	TQCheckBox* indentPopupMenuItems;
	
	//Original settings, for accurate dirtiness tracking
	bool	   origAnimProgressBar;
	bool origDrawTriangularExpander;
	bool origToolBtnAsBtn;
	bool origHighlightToolBtnIcons;
	
	bool origCustomCheckMarkColor;
	TQColor origCheckMarkColor;
	bool origTintGroupBoxBackground;
	int origGroupBoxBrightness;
	bool origCustomGroupBoxBackgroundColor;
	TQColor origGroupBoxBackgroundColor;
	
	bool origCustomToolTipColor;
	TQColor origToolTipColor;
	
	int origRubberBandType;
	TQColor origArgbRubberColor;
	int origArgbRubberOpacity;

	bool origSmoothScrolling;
	int origButtonHeightAdjustment;
	int origButtonContourType;
	bool origCustomPopupMenuColor;
	TQColor origPopupMenuColor;
	bool origCustomSelMenuItemColor;
	TQColor origSelMenuItemColor;
	bool origDrawPopupMenuGradient;
	bool origIndentPopupMenuItems;
	
	bool origCenterTabs;
	bool origIndicateFocus;
	TQColor origIndicatorColor;
	TQColor origIndicatorBtnColor;
	int origIndicatorOpacity;
	int origIndicatorBtnOpacity;
	
	bool origDrawUnderline;
	int origTextEffectMode;
	TQColor origTextEffectColor;
	TQColor origTextEffectButtonColor;
	bool origDrawTextEffect;
	int origTextEffectOpacity;
	int origTextEffectButtonOpacity;
	int origTextEffectPos;
	int origTextEffectButtonPos;
	
	bool origDrawButtonSunkenShadow;
	
	TQColor origButtonContourColor;
	TQColor origButtonDefaultButtonContourColor;
	TQColor origButtonMouseOverContourColor;
	TQColor origButtonPressedContourColor;
	
	
	int konqTabBarContrast;
	
	TQString currentConfig;
	TQLabel* currentConfigLabel;

	SchemeList* schemeList;
	bool configLoaded;
	DSurface* currentScrollBarSurface;
	DSurface* currentTabSurface;
	
	void loadConfig(const TQString &name);
	void saveConfig(const TQString &fileName, const TQString &schemeName);
	void getConfigSchemes();
	

	
	//////////////////////////////////////////////// form:
	//protected:
	TQVBoxLayout* tab1Layout;
	TQGridLayout* groupBox22Layout;
	TQSpacerItem* spacer6;
	TQSpacerItem* spacer3;
	TQSpacerItem* spacer43;
	TQSpacerItem* spacer46;
	TQSpacerItem* spacer2;
	TQVBoxLayout* groupBox10_2_2_2Layout;
	TQGridLayout* groupBox8_2_2_2Layout;
	TQGridLayout* groupBox9_2_2_2Layout;
	TQHBoxLayout* layout9;
	TQSpacerItem* spacer7;
	TQVBoxLayout* tab2Layout;
	TQGridLayout* groupBox22_2Layout;
	TQSpacerItem* spacer46_2;
	TQSpacerItem* spacer43_2;
	TQSpacerItem* spacer6_2;
	TQSpacerItem* spacer2_2;
	TQSpacerItem* spacer3_2;
	TQGridLayout* groupBox8_2_2_2_2Layout;
	TQGridLayout* groupBox9_2_2_2_2Layout;
	TQVBoxLayout* groupBox10_2_2_2_2Layout;
	TQHBoxLayout* layout9_2;
	TQSpacerItem* spacer7_2;
	TQVBoxLayout* tab3Layout;
	TQGridLayout* groupBox22_2_2Layout;
	TQSpacerItem* spacer46_2_2;
	TQSpacerItem* spacer43_2_2;
	TQSpacerItem* spacer3_2_2;
	TQSpacerItem* spacer6_2_2;
	TQSpacerItem* spacer2_2_2;
	TQGridLayout* groupBox8_2_2_2_2_4Layout;
	TQGridLayout* groupBox9_2_2_2_2_4Layout;
	TQGridLayout* groupBox10_2_2_2_2_4Layout;
	TQSpacerItem* spacer35;
	TQHBoxLayout* layout6;
	TQSpacerItem* spacer7_2_3;
	TQVBoxLayout* tab4Layout;
	TQGridLayout* groupBox22_2_2_3Layout;
	TQSpacerItem* spacer3_2_2_2;
	TQSpacerItem* spacer6_2_2_2;
	TQSpacerItem* spacer2_2_2_2;
	TQSpacerItem* spacer46_2_2_2;
	TQSpacerItem* spacer43_2_2_2;
	TQVBoxLayout* groupBox10_2_2_2_2_4_3Layout;
	TQGridLayout* groupBox8_2_2_2_2_4_3Layout;
	TQGridLayout* groupBox9_2_2_2_2_4_3Layout;
	TQHBoxLayout* layout21;
	TQSpacerItem* spacer7_2_3_3;
	TQVBoxLayout* tab5Layout;
	TQGridLayout* groupBox22_2_2_3_2Layout;
	TQSpacerItem* spacer3_2_2_3;
	TQSpacerItem* spacer6_2_2_3;
	TQSpacerItem* spacer2_2_2_3;
	TQSpacerItem* spacer46_2_2_3;
	TQSpacerItem* spacer43_2_2_2_2;
	TQGridLayout* groupBox8_2_2_2_2_4_3_2Layout;
	TQVBoxLayout* groupBox10_2_2_2_2_4_3_2Layout;
	TQGridLayout* groupBox9_2_2_2_2_4_3_2Layout;
	TQHBoxLayout* layout22;
	TQSpacerItem* spacer7_2_3_3_2;
	
	// tab 3 - load/save
	TQVBoxLayout* tab_lsLayout;
	TQHBoxLayout* groupBox_lsLayout;
	TQVBoxLayout* layout8;
	TQSpacerItem* spacer32;
	
};




class DSpinBox : public TQSpinBox
{
public:
	DSpinBox(TQWidget *parent, const char* name=0): TQSpinBox(parent, name){};
	DSpinBox( int minValue, int maxValue, int step = 1, TQWidget* parent=0, const char* name=0 ): TQSpinBox(minValue, maxValue, step, parent, name){};
	void setAlignRight() {
		this->editor()->setAlignment(TQt::AlignRight);
	}
	TQSpinWidget* spinWidget() {
		return static_cast<TQSpinWidget*>(editor()->parentWidget());
	}
};

class PreviewCheckBox : public TQCheckBox
{
	public:
		PreviewCheckBox(TQWidget *parent, const char * name = 0 ): TQCheckBox( parent, name){};
		void paintEvent(TQPaintEvent *event);
		void drawButton(TQPainter *paint);
};

class PreviewRadioButton : public TQRadioButton
{
	public:
		PreviewRadioButton(TQWidget *parent, const char * name = 0 ): TQRadioButton( parent, name){};
		void paintEvent(TQPaintEvent *event);
		void drawButton(TQPainter *paint);
};


class PreviewTabBar : public TQTabBar
{
	public:
		PreviewTabBar(TQWidget *parent, const char * name = 0 ): TQTabBar( parent, name){};
		void mousePressEvent(TQMouseEvent* event);
		void paintEvent(TQPaintEvent *event);
};

class IndicatorPrevButton : public TQPushButton
{
	public:
		IndicatorPrevButton(TQWidget *parent, const char * name = 0 ): TQPushButton( parent, name){};
		void paintEvent(TQPaintEvent *event);
};

class IndicatorPrevWidget : public TQPushButton /*TQWidget*/
{
	public:
		IndicatorPrevWidget(TQWidget *parent, const char * name = 0) : TQPushButton( parent, name){};
		void paintEvent(TQPaintEvent *event);
};

class DominoKTabWidget : public KTabWidget
{
	TQ_OBJECT
	friend class DominoStyleConfig;
	public:
		DominoKTabWidget( TQWidget* parent=0, const char* name=0 ) : KTabWidget( parent, name ) {}
	protected slots:
		void wheelDelta( int ) {};
};

class DominoKTabPrevWidget : public KTabWidget
{
	friend class DominoStyleConfig;
	friend class TabWidgetIndicator;
	public:
		DominoKTabPrevWidget( TQWidget* parent=0, const char* name=0 ) : KTabWidget( parent, name ) {}
};

class TabWidgetIndicator : public TQWidget
{
	friend class DominoStyleConfig;
	public:
		TabWidgetIndicator( TQWidget* parent=0, const char* name=0 ) : TQWidget( parent, name ) {}
		void paintEvent(TQPaintEvent *event);
};

class TextEffectPrevButton : public TQPushButton
{
	public:
		TextEffectPrevButton(TQWidget *parent, const char * name = 0 ): TQPushButton( parent, name){};
		void paintEvent(TQPaintEvent *event);
};

class TextEffectPrevWidget : public TQWidget
{
	public:
		TextEffectPrevWidget(TQWidget *parent, const char * name = 0, uint flags = 0 ): TQWidget( parent, name, flags){};
		void paintEvent(TQPaintEvent *event);
};

class PreviewStyle : public DominoStyle
{
	friend class IndicatorPrevButton;
	friend class DominoStyleConfig;
	public:
};
PreviewStyle* previewStyle;

DSurface origBtnSurface;
DSurface origTabTopSurface;
DSurface origActiveTabTopSurface;
DSurface origTabBottomSurface;
DSurface origActiveTabBottomSurface;
DSurface origScrollBarSurface;
DSurface origScrollBarGrooveSurface;
DSurface origHeaderSurface;
DSurface origCheckItemSurface;

// global
bool initialized;

TQComboBox* indicatorModeCombo;
KColorButton* indicatorBtnColor;
KColorButton* indicatorColor;
TQString indicatorPreviewText;
TQSpinBox* indicatorOpacity;
TQSpinBox* indicatorBtnOpacity;

TQCheckBox* tintGroupBoxBackground;
TQCheckBox* customGroupBoxBackgroundColor;
KColorButton* groupBoxBackgroundColor;
TQSlider* grSlider;

// text effect
TQComboBox* textEffectModeCombo;
TQCheckBox* drawTextEffect;
KColorButton* textEffectColor;
KColorButton* textEffectButtonColor;
TQString textEffectPreviewText;
TQSpinBox* textEffectOpacity;
TQSpinBox* textEffectButtonOpacity;

TQComboBox* textEffectPos;
TQComboBox* textEffectButtonPos;

// button contour colors
TQComboBox* buttonContourType;

KColorButton* buttonContourColor;
KColorButton* buttonDefaultButtonContourColor;
KColorButton* buttonMouseOverContourColor;
KColorButton* buttonPressedContourColor;

TQComboBox* tabPosCombo;
TQComboBox* tabStateCombo;
DominoKTabPrevWidget *prevTopTabWidget;
DominoKTabPrevWidget *prevBottomTabWidget;

enum DominoStyleFlags {
	Domino_noCache = 0x80000000
};
#endif
