/*
Copyright (C) 2004-2007 Patrice Tremblay <tremblaypatrice@yahoo.fr>
			http://www.poplix.info/lipstik

based on plastik:
Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

based on the Keramik configuration dialog:
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqsettings.h>
#include <tqcolor.h>
#include <tqlabel.h>
#include <tqcombobox.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kcolorbutton.h>
#include <tqtabwidget.h>
#include <tqvgroupbox.h>
#include <tqspinbox.h>
#include <tqgrid.h>

#include "lipstikconf.h"

extern "C"
{
	TDE_EXPORT TQWidget* allocate_tdestyle_config(TQWidget* parent)
	{
		TDEGlobal::locale()->insertCatalogue("tdestyle_lipstik_config");
		return new LipstikStyleConfig(parent);
	}
}

LipstikStyleConfig::LipstikStyleConfig(TQWidget* parent): TQWidget(parent)
{
	TQVBoxLayout* layout = new TQVBoxLayout(this, 0, 0);
	TQGridLayout* tabLayout = new TQGridLayout(this, 2, 1, 10);

	TDEGlobal::locale()->insertCatalogue("tdestyle_lipstik_config");

	///Init tabs
	TQTabWidget *tabWidget = new TQTabWidget(this);
	layout->addWidget(tabWidget);

	///Init tab1 
	TQWidget *page1 = new TQWidget(tabWidget);
        layout = new TQVBoxLayout(page1);
	tabWidget->insertTab(page1, i18n("Configuration"));
	layout->addLayout(tabLayout);	

	///General group
	TQVGroupBox *generalGrp = new TQVGroupBox(i18n("General"), page1);

	reverseGradients = new TQCheckBox(i18n("Plastik gradients"), generalGrp );
	drawTriangularExpander = new TQCheckBox(i18n("Triangular tree expander"), generalGrp);
	drawStatusBarFrame = new TQCheckBox(i18n("Draw status bar frame"), generalGrp);
	animateProgressBar = new TQCheckBox(i18n("Animate progress bars"), generalGrp);
	flatHeaders = new TQCheckBox(i18n("Flatten column headers"), generalGrp);
	tickCheckMark = new TQCheckBox(i18n("Use a tick for checkmarks"), generalGrp);

	tabLayout->addWidget(generalGrp,0,0,0);

	///Toolbar group
	TQVGroupBox *toolbarGrp = new TQVGroupBox(i18n("Toolbars"), page1);
	TQLabel* toolBarSpacingLabel;

	drawToolBarSeparator = new TQCheckBox(i18n("Draw separators"), toolbarGrp);
	drawToolBarItemSeparator = new TQCheckBox(i18n("Draw item separators"), toolbarGrp);
	drawToolBarHandle = new TQCheckBox(i18n("Draw handles"), toolbarGrp);
	drawToolBarGradient = new TQCheckBox(i18n("Draw gradients"), toolbarGrp);
	invertBarGrad = new TQCheckBox(i18n("Invert gradients"), toolbarGrp);

        toolBarSpacingLabel = new TQLabel(toolbarGrp);
        toolBarSpacingLabel->setText(i18n("Items spacing :"));
	toolBarSpacing = new TQSpinBox ( 0, 6, 1, toolbarGrp );

	tabLayout->addWidget(toolbarGrp,0,1,0);	

	///Menus group
	TQVGroupBox *menusGrp = new TQVGroupBox(i18n("Menus"), page1);
	TQLabel* menuSpacingLabel;

	alterMenuGradients = new TQCheckBox(i18n("Button-like menu gradients"), menusGrp);
	sharperMenuGradient = new TQCheckBox(i18n("Sharper menu gradients"), menusGrp);

	menuLeftSideBar = new TQCheckBox(i18n("Menu Stripe"), menusGrp);
	flatStripe = new TQCheckBox(i18n("Flatten Stripe"), menusGrp);
	customMenuStripeColor = new TQCheckBox(i18n("Custom Stripe color :"), menusGrp);
	TQHBox *menuColorBox = new TQHBox(menusGrp);
	menuColorBox->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );

	menuStripeColor = new KColorButton(menuColorBox);

        menuSpacingLabel = new TQLabel(menusGrp);
        menuSpacingLabel->setText(i18n("Menu spacing :"));
	menuSpacing = new TQSpinBox ( 0, 8, 1, menusGrp );

	tabLayout->addWidget(menusGrp,1,0,0);

	///Scrollbar group
	TQVGroupBox *scrollGrp = new TQVGroupBox(i18n("Scrollbars and Sliders"), page1);
	TQLabel* scrollBarStyleLabel;
	TQLabel* scrollBarWidthLabel;
	TQLabel* sliderStyleLabel;

	paintGroove = new TQCheckBox(i18n("Draw Scrollbar grooves"), scrollGrp);

        scrollBarStyleLabel = new TQLabel(scrollGrp);
        scrollBarStyleLabel->setText(i18n("Scrollbar style :       "));
	scrollBarStyle = new TQComboBox(i18n("Scrollbar style").utf8(), scrollGrp);
	scrollBarStyle->setEditable(false);
	scrollBarStyle->insertItem("Windows style");
	scrollBarStyle->insertItem("Platinum style");
	scrollBarStyle->insertItem("KDE style");
	scrollBarStyle->insertItem("Next style");

        scrollBarWidthLabel = new TQLabel(scrollGrp);
        scrollBarWidthLabel->setText(i18n("Scrollbar width :       "));
	scrollBarWidth = new TQComboBox(i18n("Scrollbar width").utf8(), scrollGrp);
	scrollBarWidth->setEditable(false);
	scrollBarWidth->insertItem("Small");
	scrollBarWidth->insertItem("Normal");
	scrollBarWidth->insertItem("Large");

        sliderStyleLabel = new TQLabel(scrollGrp);
        sliderStyleLabel->setText(i18n("Slider handle size :       "));
	sliderStyle = new TQComboBox(i18n("Slider handle size").utf8(), scrollGrp);
	sliderStyle->setEditable(false);
	sliderStyle->insertItem("Small");
	sliderStyle->insertItem("Medium");
	sliderStyle->insertItem("Large");

	tabLayout->addWidget(scrollGrp,1,1,0);	

	///Highlighting group
	TQVGroupBox *lightGrp = new TQVGroupBox(i18n("Highlighting"), page1);

	drawFocusRect = new TQCheckBox(i18n("Colored focus rectangle"), lightGrp);
	comboboxColored = new TQCheckBox(i18n("Colored comboboxes handles"), lightGrp);
	coloredMenuBar = new TQCheckBox(i18n("Colored menu bar items"), lightGrp);
	drawTabHighlight = new TQCheckBox(i18n("Highlight active tab"), lightGrp);
	inputFocusHighlight = new TQCheckBox(i18n("Highlight focused input fields"), lightGrp);

	tabLayout->addWidget(lightGrp,0,2,0);	

	///Other colors group
	TQVGroupBox *otherGrp = new TQVGroupBox(i18n("Custom colors"), page1);

        customFocusHighlightColor = new TQCheckBox(i18n("Input fields highlight :"), otherGrp);
	TQHBox *hbox1 = new TQHBox(otherGrp);
	hbox1->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	focusHighlightColor = new KColorButton(hbox1);

	customOverHighlightColor = new TQCheckBox(i18n("Mouse hover highlight :"), otherGrp);
	TQHBox *hbox2 = new TQHBox(otherGrp);
	hbox2->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	overHighlightColor = new KColorButton(hbox2);

	customCheckMarkColor = new TQCheckBox(i18n("Checkmark/Radiobuttons :"), otherGrp);
	TQHBox *hbox3 = new TQHBox(otherGrp);
	hbox3->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	checkMarkColor = new KColorButton(hbox3);

	customTabHighlightColor = new TQCheckBox(i18n("Active tab highlight :"), otherGrp);
	TQHBox *hbox4 = new TQHBox(otherGrp);
	hbox4->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	tabHighlightColor = new KColorButton(hbox4);

	tabLayout->addWidget(otherGrp,1,2,0);	

	///Init tab2
	TQWidget *page2 = new TQWidget(tabWidget);
	TQLabel* lipstikLabel;
	TQLabel* authorLabel;
	TQLabel* authorAddressLabel;
	TQLabel* authorWebLabel;
	TQLabel* plastikLabel;
	TQLabel* alsoLabel;
	TQLabel* cuLabel;
	TQLabel* dnLabel;
	TQLabel* pqLabel;
	TQLabel* cxLabel;
	TQLabel* kpLabel;
	TQLabel* blLabel;
	TQLabel* ksLabel;
	TQLabel* peLabel;
	TQLabel* bastianLabel;
	TQLabel* pcbsdLabel;
	TQLabel* othersLabel;

        layout = new TQVBoxLayout(page2, 10, -1);
	    
	tabWidget->insertTab(page2, i18n("About"));

	lipstikLabel = new TQLabel(page2);
        lipstikLabel->setText(i18n("Lipstik 2.2.3"));
	lipstikLabel->setFrameStyle( TQFrame::StyledPanel | TQFrame::Raised );

	authorLabel = new TQLabel(page2);
        authorLabel->setText(i18n("     Copyright 2004-2005-2006-2007 (C) Patrice Tremblay (Poplix)"));

	authorAddressLabel = new TQLabel(page2);
        authorAddressLabel->setText(i18n("      poplixos@gmail.com"));

	authorWebLabel = new TQLabel(page2);
        authorWebLabel->setText(i18n("      http://poplix.homelinux.com/lipstik"));

	plastikLabel = new TQLabel(page2);
        plastikLabel->setText(i18n("Based on plastik [thanks to Sandro Giessl]"));

	alsoLabel = new TQLabel(page2);
        alsoLabel->setText(i18n("Also based on :"));

	cuLabel = new TQLabel(page2);
        cuLabel->setText(i18n("    TQtCurve [thanks to Craig Drummond],"));

	dnLabel = new TQLabel(page2);
        dnLabel->setText(i18n("    DotNET [thanks to Chris Lee],"));

	pqLabel = new TQLabel(page2);
        pqLabel->setText(i18n("    PlastikQ [thanks to Martin Beck],"));

	cxLabel = new TQLabel(page2);
        cxLabel->setText(i18n("    Comix [thanks to Jens Luetkens],"));

	kpLabel = new TQLabel(page2);
        kpLabel->setText(i18n("    Krisp [thanks to Keith Meehl],"));

	blLabel = new TQLabel(page2);
        blLabel->setText(i18n("    Ballistik [thanks to Florian Merz],"));

	ksLabel = new TQLabel(page2);
        ksLabel->setText(i18n("    Kerastik [thanks to Victor Perez Q],"));

	peLabel = new TQLabel(page2);
        peLabel->setText(i18n("    Polyester [thanks to Marco Martin]."));

	bastianLabel = new TQLabel(page2);
        bastianLabel->setText(i18n("Thanks to Bastian Venthur, the Debian maintainer of tde-style-lipstik."));

	pcbsdLabel = new TQLabel(page2);
        pcbsdLabel->setText(i18n("Thanks to Charles A. Landemaine, of PC-BSD, for the feature suggestion."));

	othersLabel = new TQLabel(page2);
        othersLabel->setText(i18n("Special thanks to Dominique and all the kde-look.org users."));

	layout->add(lipstikLabel);
	layout->add(authorLabel);
	layout->add(authorAddressLabel);
	layout->add(authorWebLabel);

	layout->addSpacing(10);
	layout->add(plastikLabel);

	layout->addSpacing(10);
	layout->add(alsoLabel);
	layout->add(cuLabel);
	layout->add(dnLabel);
	layout->add(pqLabel);
	layout->add(cxLabel);
	layout->add(kpLabel);
	layout->add(blLabel);
	layout->add(ksLabel);
	layout->add(peLabel);

	layout->addSpacing(10);
	layout->add(bastianLabel);
	layout->add(pcbsdLabel);
	layout->add(othersLabel);

	///Populate!
	TQSettings s;

	origReverseGradients = s.readBoolEntry("/lipstikstyle/Settings/reverseGradients", false);
	reverseGradients->setChecked(origReverseGradients);

	origPaintGroove = s.readBoolEntry("/lipstikstyle/Settings/paintGroove", true);
	paintGroove->setChecked(origPaintGroove);

	origSharperMenuGradient = s.readBoolEntry("/lipstikstyle/Settings/sharperMenuGradient", false);
	sharperMenuGradient->setChecked(origSharperMenuGradient);

	origAlterMenuGradients = s.readBoolEntry("/lipstikstyle/Settings/alterMenuGradients", true);
	alterMenuGradients->setChecked(origAlterMenuGradients);

	origMenuLeftSideBar = s.readBoolEntry("/lipstikstyle/Settings/menuLeftSideBar", true);
	menuLeftSideBar->setChecked(origMenuLeftSideBar);

	origFlatStripe = s.readBoolEntry("/lipstikstyle/Settings/flatStripe", false);
	flatStripe->setChecked(origFlatStripe);

	origComboboxColored = s.readBoolEntry("/lipstikstyle/Settings/comboboxColored", false);
	comboboxColored->setChecked(origComboboxColored);

	origColoredMenuBar = s.readBoolEntry("/lipstikstyle/Settings/coloredMenuBar", false);
	coloredMenuBar->setChecked(origColoredMenuBar);

	origDrawTabHighlight = s.readBoolEntry("/lipstikstyle/Settings/drawTabHighlight", true);
	drawTabHighlight->setChecked(origDrawTabHighlight);

	origMenuSpacing = s.readNumEntry("/lipstikstyle/Settings/menuSpacing", 5);
	menuSpacing->setValue(origMenuSpacing);

	origToolBarSpacing = s.readNumEntry("/lipstikstyle/Settings/toolBarSpacing", 0);
	toolBarSpacing->setValue(origToolBarSpacing);

	origScrollBarStyle = s.readEntry("/lipstikstyle/Settings/scrollBarStyle", "WindowsStyleScrollBar");
	scrollBarStyle->setCurrentItem(scrollBarItem(origScrollBarStyle));

	origScrollBarWidth = s.readEntry("/lipstikstyle/Settings/scrollBarWidth", "Small");
	scrollBarWidth->setCurrentItem(scrollBarWidthItem(origScrollBarWidth));

	origSliderStyle = s.readEntry("/lipstikstyle/Settings/sliderStyle", "sliderLipstikStyle");
	sliderStyle->setCurrentItem(sliderItem(origSliderStyle));

	origDrawStatusBarFrame = s.readBoolEntry("/lipstikstyle/Settings/drawStatusBarFrame", false);
	drawStatusBarFrame->setChecked(origDrawStatusBarFrame);

	origDrawToolBarHandle = s.readBoolEntry("/lipstikstyle/Settings/drawToolBarHandle", true);
	drawToolBarHandle->setChecked(origDrawToolBarHandle);

	origAnimProgressBar = s.readBoolEntry("/lipstikstyle/Settings/animateProgressBar", false);
	animateProgressBar->setChecked(origAnimProgressBar);

	origDrawToolBarSeparator = s.readBoolEntry("/lipstikstyle/Settings/drawToolBarSeparator", true);
	drawToolBarSeparator->setChecked(origDrawToolBarSeparator);

	origDrawToolBarGradient = s.readBoolEntry("/lipstikstyle/Settings/drawToolBarGradient", false);
	drawToolBarGradient->setChecked(origDrawToolBarGradient);

	origInvertBarGrad = s.readBoolEntry("/lipstikstyle/Settings/invertBarGrad", true);
	invertBarGrad->setChecked(origInvertBarGrad);

	origDrawToolBarItemSeparator = s.readBoolEntry("/lipstikstyle/Settings/drawToolBarItemSeparator", true);
	drawToolBarItemSeparator->setChecked(origDrawToolBarItemSeparator);

 	origDrawFocusRect = s.readBoolEntry("/lipstikstyle/Settings/drawFocusRect", true);
	drawFocusRect->setChecked(origDrawFocusRect);

 	origFlatHeaders = s.readBoolEntry("/lipstikstyle/Settings/flatHeaders", true);
	flatHeaders->setChecked(origFlatHeaders);

 	origTickCheckMark = s.readBoolEntry("/lipstikstyle/Settings/tickCheckMark", true);
	tickCheckMark->setChecked(origTickCheckMark);

	origDrawTriangularExpander = s.readBoolEntry("/lipstikstyle/Settings/drawTriangularExpander", false);
	drawTriangularExpander->setChecked(origDrawTriangularExpander);

	origInputFocusHighlight = s.readBoolEntry("/lipstikstyle/Settings/inputFocusHighlight", true);
	inputFocusHighlight->setChecked(origInputFocusHighlight);

	origCustomOverHighlightColor = s.readBoolEntry("/lipstikstyle/Settings/customOverHighlightColor", false);
	customOverHighlightColor->setChecked(origCustomOverHighlightColor);

	origOverHighlightColor = s.readEntry("/lipstikstyle/Settings/overHighlightColor", "/TQt/KWinPalette/activeBackground");
	overHighlightColor->setColor(origOverHighlightColor);

	origCustomMenuStripeColor = s.readBoolEntry("/lipstikstyle/Settings/customMenuStripeColor", false);
	customMenuStripeColor->setChecked(origCustomMenuStripeColor);

	origMenuStripeColor = s.readEntry("/lipstikstyle/Settings/menuStripeColor", "/TQt/KWinPalette/activeBackground");
	menuStripeColor->setColor(origMenuStripeColor);

	origCustomFocusHighlightColor = s.readBoolEntry("/lipstikstyle/Settings/customFocusHighlightColor", false);
	customFocusHighlightColor->setChecked(origCustomFocusHighlightColor);

	origFocusHighlightColor = s.readEntry("/lipstikstyle/Settings/focusHighlightColor", "/TQt/KWinPalette/activeBackground");
	focusHighlightColor->setColor(origFocusHighlightColor);

	origCustomCheckMarkColor = s.readBoolEntry("/lipstikstyle/Settings/customCheckMarkColor", false);
	customCheckMarkColor->setChecked(origCustomCheckMarkColor);

	origCheckMarkColor = s.readEntry("/lipstikstyle/Settings/checkMarkColor", "/TQt/KWinPalette/activeBackground");
	checkMarkColor->setColor(origCheckMarkColor);

	origCustomTabHighlightColor = s.readBoolEntry("/lipstikstyle/Settings/customTabHighlightColor", false);
	customTabHighlightColor->setChecked(origCustomTabHighlightColor);

	origTabHighlightColor = s.readEntry("/lipstikstyle/Settings/tabHighlightColor", "/TQt/KWinPalette/activeBackground");
	tabHighlightColor->setColor(origTabHighlightColor);

	connect(reverseGradients, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(paintGroove, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(sharperMenuGradient, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(alterMenuGradients, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(menuLeftSideBar, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(flatStripe, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawStatusBarFrame, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawToolBarHandle, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(comboboxColored, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(coloredMenuBar, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawTabHighlight, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(menuSpacing, TQ_SIGNAL( valueChanged(int) ), TQ_SLOT( updateChanged() ) );
	connect(toolBarSpacing, TQ_SIGNAL( valueChanged(int) ), TQ_SLOT( updateChanged() ) );
	connect(scrollBarStyle, TQ_SIGNAL( activated(int) ), TQ_SLOT( updateChanged() ) );
	connect(scrollBarWidth, TQ_SIGNAL( activated(int) ), TQ_SLOT( updateChanged() ) );
	connect(sliderStyle, TQ_SIGNAL( activated(int) ), TQ_SLOT( updateChanged() ) );
	connect(animateProgressBar, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawToolBarSeparator, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawToolBarGradient, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(invertBarGrad, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawToolBarItemSeparator, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
 	connect(drawFocusRect, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
 	connect(flatHeaders, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
 	connect(tickCheckMark, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(drawTriangularExpander, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(inputFocusHighlight, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(customOverHighlightColor, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(overHighlightColor, TQ_SIGNAL( pressed() ), TQ_SLOT( updateChanged() ) );
	connect(customMenuStripeColor, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(menuStripeColor, TQ_SIGNAL( pressed() ), TQ_SLOT( updateChanged() ) );
	connect(customFocusHighlightColor, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(focusHighlightColor, TQ_SIGNAL( pressed() ), TQ_SLOT( updateChanged() ) );
	connect(customCheckMarkColor, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(checkMarkColor, TQ_SIGNAL( pressed() ), TQ_SLOT( updateChanged() ) );
	connect(customTabHighlightColor, TQ_SIGNAL( toggled(bool) ), TQ_SLOT( updateChanged() ) );
	connect(tabHighlightColor, TQ_SIGNAL( pressed() ), TQ_SLOT( updateChanged() ) );

	//Menu Stripe 
	if ( menuLeftSideBar->isChecked() ) {
	    customMenuStripeColor->setEnabled(true);
	    flatStripe->setEnabled(true);
	} else {
	    customMenuStripeColor->setEnabled(false);
	    flatStripe->setEnabled(false);
	}

	//Toolbar gradients.
	if ( drawToolBarGradient->isChecked() ) {
	    invertBarGrad->setEnabled(true);
	} else {
	    invertBarGrad->setEnabled(false);
	}

	if ( customMenuStripeColor->isChecked() && customMenuStripeColor->isEnabled())
	 menuStripeColor->setEnabled(true);
	else
	 menuStripeColor->setEnabled(false);

	//Input Focus 
	if ( inputFocusHighlight->isChecked() )
	    customFocusHighlightColor->setEnabled(true);
	else
	    customFocusHighlightColor->setEnabled(false);

	if ( customFocusHighlightColor->isChecked() && customFocusHighlightColor->isEnabled())
	 focusHighlightColor->setEnabled(true);
	else
	 focusHighlightColor->setEnabled(false);

	//Custom checkmark color.
	if ( customCheckMarkColor->isChecked() )
	 checkMarkColor->setEnabled(true);
	else
	 checkMarkColor->setEnabled(false);

	//Custom tab highlight color.
	if ( customTabHighlightColor->isChecked() )
	 tabHighlightColor->setEnabled(true);
	else
	 tabHighlightColor->setEnabled(false);

	if ( customOverHighlightColor->isChecked() )
	 overHighlightColor->setEnabled(true);
	else
	 overHighlightColor->setEnabled(false);
}

LipstikStyleConfig::~LipstikStyleConfig()
{
}


void LipstikStyleConfig::save()
{
	TQSettings s;
	s.writeEntry("/lipstikstyle/Settings/reverseGradients", reverseGradients->isChecked());
	s.writeEntry("/lipstikstyle/Settings/paintGroove", paintGroove->isChecked());
	s.writeEntry("/lipstikstyle/Settings/sharperMenuGradient", sharperMenuGradient->isChecked());
	s.writeEntry("/lipstikstyle/Settings/alterMenuGradients", alterMenuGradients->isChecked());
	s.writeEntry("/lipstikstyle/Settings/menuLeftSideBar", menuLeftSideBar->isChecked());
	s.writeEntry("/lipstikstyle/Settings/flatStripe", flatStripe->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawStatusBarFrame", drawStatusBarFrame->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawToolBarHandle", drawToolBarHandle->isChecked());
	s.writeEntry("/lipstikstyle/Settings/comboboxColored", comboboxColored->isChecked());
	s.writeEntry("/lipstikstyle/Settings/coloredMenuBar", coloredMenuBar->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawTabHighlight", drawTabHighlight->isChecked());
	s.writeEntry("/lipstikstyle/Settings/menuSpacing", menuSpacing->value());
	s.writeEntry("/lipstikstyle/Settings/toolBarSpacing", toolBarSpacing->value());
	s.writeEntry("/lipstikstyle/Settings/scrollBarStyle", scrollBarType(scrollBarStyle->currentItem()));
	s.writeEntry("/lipstikstyle/Settings/scrollBarWidth", scrollBarWidthType(scrollBarWidth->currentItem()));
	s.writeEntry("/lipstikstyle/Settings/sliderStyle", sliderType(sliderStyle->currentItem()));
	s.writeEntry("/lipstikstyle/Settings/animateProgressBar", animateProgressBar->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawToolBarSeparator", drawToolBarSeparator->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawToolBarGradient", drawToolBarGradient->isChecked());
	s.writeEntry("/lipstikstyle/Settings/invertBarGrad", invertBarGrad->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawToolBarItemSeparator", drawToolBarItemSeparator->isChecked());
 	s.writeEntry("/lipstikstyle/Settings/drawFocusRect", drawFocusRect->isChecked());
 	s.writeEntry("/lipstikstyle/Settings/flatHeaders", flatHeaders->isChecked());
 	s.writeEntry("/lipstikstyle/Settings/tickCheckMark", tickCheckMark->isChecked());
	s.writeEntry("/lipstikstyle/Settings/drawTriangularExpander", drawTriangularExpander->isChecked());
	s.writeEntry("/lipstikstyle/Settings/inputFocusHighlight", inputFocusHighlight->isChecked());
	s.writeEntry("/lipstikstyle/Settings/customOverHighlightColor", customOverHighlightColor->isChecked());
	s.writeEntry("/lipstikstyle/Settings/overHighlightColor", TQColor(overHighlightColor->color()).name());
	s.writeEntry("/lipstikstyle/Settings/customMenuStripeColor", customMenuStripeColor->isChecked());
	s.writeEntry("/lipstikstyle/Settings/menuStripeColor", TQColor(menuStripeColor->color()).name());
	s.writeEntry("/lipstikstyle/Settings/customFocusHighlightColor", customFocusHighlightColor->isChecked());
	s.writeEntry("/lipstikstyle/Settings/focusHighlightColor", TQColor(focusHighlightColor->color()).name());
	s.writeEntry("/lipstikstyle/Settings/customCheckMarkColor", customCheckMarkColor->isChecked());
	s.writeEntry("/lipstikstyle/Settings/checkMarkColor", TQColor(checkMarkColor->color()).name());
	s.writeEntry("/lipstikstyle/Settings/customTabHighlightColor", customTabHighlightColor->isChecked());
	s.writeEntry("/lipstikstyle/Settings/tabHighlightColor", TQColor(tabHighlightColor->color()).name());
}

void LipstikStyleConfig::defaults()
{
	reverseGradients->setChecked(false);
	paintGroove->setChecked(true);
	sharperMenuGradient->setChecked(false);
	alterMenuGradients->setChecked(true);
	menuLeftSideBar->setChecked(true);
	flatStripe->setChecked(false);
	menuSpacing->setValue(5);
	toolBarSpacing->setValue(0);
	drawStatusBarFrame->setChecked(false);
	drawToolBarHandle->setChecked(true);
	comboboxColored->setChecked(false);
	coloredMenuBar->setChecked(false);
	drawTabHighlight->setChecked(true);
	scrollBarStyle->setCurrentItem(0);
	scrollBarWidth->setCurrentItem(0);
	sliderStyle->setCurrentItem(1);
	animateProgressBar->setChecked(false);
	drawToolBarSeparator->setChecked(true);
	drawToolBarGradient->setChecked(false);
	invertBarGrad->setChecked(true);
	drawToolBarItemSeparator->setChecked(true);
 	drawFocusRect->setChecked(true);
 	flatHeaders->setChecked(true);
 	tickCheckMark->setChecked(true);
	drawTriangularExpander->setChecked(false);
	inputFocusHighlight->setChecked(true);
	customOverHighlightColor->setChecked(false);
	overHighlightColor->setColor("/TQt/KWinPalette/activeBackground");
	customMenuStripeColor->setChecked(false);
	menuStripeColor->setColor("/TQt/KWinPalette/activeBackground");
	customFocusHighlightColor->setChecked(false);
	focusHighlightColor->setColor("/TQt/KWinPalette/activeBackground");
	customCheckMarkColor->setChecked(false);
	checkMarkColor->setColor("/TQt/KWinPalette/activeBackground");
	customTabHighlightColor->setChecked(false);
	tabHighlightColor->setColor("/TQt/KWinPalette/activeBackground");
	//updateChanged would be done by setChecked already
}

void LipstikStyleConfig::updateChanged()
{
	if ( customOverHighlightColor->isChecked() )
	 overHighlightColor->setEnabled(true);
	else
	 overHighlightColor->setEnabled(false);

	if ( drawToolBarGradient->isChecked() )
	 invertBarGrad->setEnabled(true);
	else
	 invertBarGrad->setEnabled(false);

	//Stripe
	if ( menuLeftSideBar->isChecked() ) {
	    customMenuStripeColor->setEnabled(true);
	    flatStripe->setEnabled(true);
	    if ( customMenuStripeColor->isEnabled() )
		menuStripeColor->setEnabled(true);
	    else
		menuStripeColor->setEnabled(false);
	} else {
	    customMenuStripeColor->setEnabled(false);
	    menuStripeColor->setEnabled(false);
	    flatStripe->setEnabled(false);
	}
	
	if ( customMenuStripeColor->isChecked() && customMenuStripeColor->isEnabled() )
	 menuStripeColor->setEnabled(true);
	else
	 menuStripeColor->setEnabled(false);

	//Input Focus
	if ( inputFocusHighlight->isChecked() ) {
	    customFocusHighlightColor->setEnabled(true);
	    if ( customFocusHighlightColor->isEnabled() )
		focusHighlightColor->setEnabled(true);
	    else
		focusHighlightColor->setEnabled(false);
	} else {
	    customFocusHighlightColor->setEnabled(false);
	    focusHighlightColor->setEnabled(false);
	}

	if ( customFocusHighlightColor->isChecked() && customFocusHighlightColor->isEnabled() )
	 focusHighlightColor->setEnabled(true);
	else
	 focusHighlightColor->setEnabled(false);

	if ( customCheckMarkColor->isChecked() )
	 checkMarkColor->setEnabled(true);
	else
	 checkMarkColor->setEnabled(false);

	if ( customTabHighlightColor->isChecked() )
	 tabHighlightColor->setEnabled(true);
	else
	 tabHighlightColor->setEnabled(false);

	if ((animateProgressBar->isChecked() == origAnimProgressBar) &&
	    (reverseGradients->isChecked() == origReverseGradients) &&
	    (paintGroove->isChecked() == origPaintGroove) &&
	    (sharperMenuGradient->isChecked() == origSharperMenuGradient) &&
	    (alterMenuGradients->isChecked() == origAlterMenuGradients) &&
	    (menuLeftSideBar->isChecked() == origMenuLeftSideBar) &&
	    (flatStripe->isChecked() == origFlatStripe) &&
	    (menuSpacing->value() == origMenuSpacing) &&
	    (toolBarSpacing->value() == origToolBarSpacing) &&
	    (drawStatusBarFrame->isChecked() == origDrawStatusBarFrame) &&
	    (drawToolBarHandle->isChecked() == origDrawToolBarHandle) &&
	    (comboboxColored->isChecked() == origComboboxColored) &&
	    (coloredMenuBar->isChecked() == origColoredMenuBar) &&
	    (drawTabHighlight->isChecked() == origDrawTabHighlight) &&
	    (drawToolBarSeparator->isChecked() == origDrawToolBarSeparator) &&
	    (drawToolBarGradient->isChecked() == origDrawToolBarGradient) &&
	    (invertBarGrad->isChecked() == origInvertBarGrad) &&
	    (drawToolBarItemSeparator->isChecked() == origDrawToolBarItemSeparator) &&
 	    (drawFocusRect->isChecked() == origDrawFocusRect) &&
 	    (flatHeaders->isChecked() == origFlatHeaders) &&
 	    (tickCheckMark->isChecked() == origTickCheckMark) &&
	    (drawTriangularExpander->isChecked() == origDrawTriangularExpander) &&
	    (inputFocusHighlight->isChecked() == origInputFocusHighlight) &&
	    (customOverHighlightColor->isChecked() == origCustomOverHighlightColor) &&
	    (overHighlightColor->color() == origOverHighlightColor) &&
	    (customMenuStripeColor->isChecked() == origCustomMenuStripeColor) &&
	    (menuStripeColor->color() == origMenuStripeColor) &&
	    (customFocusHighlightColor->isChecked() == origCustomFocusHighlightColor) &&
	    (focusHighlightColor->color() == origFocusHighlightColor) &&
	    (customCheckMarkColor->isChecked() == origCustomCheckMarkColor) &&
	    (checkMarkColor->color() == origCheckMarkColor) &&
	    (customTabHighlightColor->isChecked() == origCustomTabHighlightColor) &&
	    (tabHighlightColor->color() == origTabHighlightColor) &&
	    (scrollBarStyle->currentText() == origScrollBarStyle) &&
	    (scrollBarWidth->currentText() == origScrollBarWidth) &&
	    (sliderStyle->currentText() == origSliderStyle)
	)
	    emit changed(false);
	else
	    emit changed(true);
}

//Scrollbar types
TQString LipstikStyleConfig::scrollBarType( int listnr )
{
    switch ( listnr ) {
        case 0:
            return TQString("WindowsStyleScrollBar");
        case 1:
            return TQString("PlatinumStyleScrollBar");
	case 2:
	    return TQString("ThreeButtonScrollBar");
	case 3:
	    return TQString("NextStyleScrollBar");
	default:
	    return TQString("PlatinumStyleScrollBar");
    }
}

int LipstikStyleConfig::scrollBarItem( TQString kSBType )
{
    if( !strcmp(kSBType.latin1(), "WindowsStyleScrollBar") )
        return 0;
    else if( !strcmp(kSBType.latin1(), "PlatinumStyleScrollBar") )
        return 1;
    else if( !strcmp(kSBType.latin1(), "ThreeButtonScrollBar") )
        return 2;
    else if( !strcmp(kSBType.latin1(), "NextStyleScrollBar") )
        return 3;
    else
        return 1;
}

//Scrollbar Widths
TQString LipstikStyleConfig::scrollBarWidthType( int widthListnr )
{
    switch ( widthListnr ) {
        case 0:
            return TQString("Small");
        case 1:
            return TQString("Normal");
	case 2:
	    return TQString("Large");
	default:
	    return TQString("Small");
    }
}

int LipstikStyleConfig::scrollBarWidthItem( TQString kSBWidthType )
{
    if( !strcmp(kSBWidthType.latin1(), "Small") )
        return 0;
    else if( !strcmp(kSBWidthType.latin1(), "Normal") )
        return 1;
    else if( !strcmp(kSBWidthType.latin1(), "Large") )
        return 2;
    else
        return 0;
}

//Slider types
int LipstikStyleConfig::sliderItem( TQString kSliderType )
{
    if( !strcmp(kSliderType.latin1(), "sliderPlastikStyle") )
        return 0;
    else if( !strcmp(kSliderType.latin1(), "sliderLipstikStyle") )
        return 1;
    else if( !strcmp(kSliderType.latin1(), "sliderGtkStyle") )
        return 2;
    else
        return 2;
}

TQString LipstikStyleConfig::sliderType( int sliderlistnr )
{
    switch ( sliderlistnr ) {
        case 0:
            return TQString("sliderPlastikStyle");
        case 1:
            return TQString("sliderLipstikStyle");
	case 2:
	    return TQString("sliderGtkStyle");
	default:
	    return TQString("sliderGtkStyle");
    }
}

#include "lipstikconf.moc"
